/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.training.CrossValidator;
import chemaxon.calculations.training.FullMatrix;
import chemaxon.calculations.training.MatrixWrapper;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.logp.LogPPredictionPreProcessor;
import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.calculations.training.logp.LogPPredictorFactory;
import chemaxon.calculations.training.logp.LogPTrainer;
import chemaxon.calculations.training.logp.LogPTrainerFactory;
import chemaxon.calculations.training.logp.LogPUserModel;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class LogPCrossValidator
extends CrossValidator<Molecule, double[]> {
    protected LogPCrossValidator(int threadCount) {
        super(new LogPCrossValidationTask(threadCount));
    }

    @Override
    public boolean add(Molecule data, double experimentalValue) {
        data = ((LogPCrossValidationTask)this.crossValidation.getTask()).preProcessor.preprocess(data);
        if (super.add(data, experimentalValue)) {
            ((LogPCrossValidationTask)this.crossValidation.getTask()).moleculeSet.add(data);
            return true;
        }
        return false;
    }

    public void setPH(double pH) {
        ((LogPCrossValidationTask)this.crossValidation.getTask()).preProcessor.setPH(pH);
    }

    protected static class LogPCrossValidationTask
    extends CrossValidator.CrossValidationTask<Molecule, double[]> {
        protected ArrayList<Molecule> moleculeSet = new ArrayList();
        private LogPPredictionPreProcessor preProcessor = new LogPPredictionPreProcessor();
        private ArrayList<Double> postProcessedExpValues = new ArrayList();

        public LogPCrossValidationTask(int threadCount) {
            super(new ArrayList(), new ArrayList(), new FullMatrix(300), new ArrayList());
            this.threadCount = threadCount;
            this.trainingModels.add(new LogPUserModel());
        }

        @Override
        public double[] call() throws Exception {
            this.postProcessedExpValues.clear();
            for (int i = 0; i < this.experimentalValues.size(); ++i) {
                this.postProcessedExpValues.add((Double)this.experimentalValues.get(i));
            }
            return super.call();
        }

        @Override
        protected double getPredictedValue(int rowIndex, int threadIndex) {
            LogPTrainer trainer = LogPTrainerFactory.createLogPTrainer();
            double prediction = -1.0;
            MatrixWrapper filteredMatrix = new MatrixWrapper(this.descriptorMatrix);
            ArrayList<Double> filteredValues = new ArrayList<Double>();
            filteredValues.addAll(this.postProcessedExpValues);
            filteredMatrix.setState(rowIndex, false);
            filteredValues.remove(rowIndex);
            try {
                for (int j = 0; j < filteredMatrix.getRowCount(); ++j) {
                    trainer.add(filteredMatrix.getRow(j), (double)((Double)filteredValues.get(j)));
                }
                SVDTrainingResult coeff = (SVDTrainingResult)trainer.getResults();
                LogPPredictor predictor = LogPPredictorFactory.createLogPPredictor(1);
                predictor.setWeightOfMethods(0.0, 0.0, 0.0, 1.0);
                predictor.setLogPMethod(LogPPredictor.MethodType.IONIC);
                predictor.setTrainingResults(coeff);
                prediction = predictor.predict(this.moleculeSet.get(rowIndex));
            }
            catch (Exception e) {
                // empty catch block
            }
            return prediction;
        }
    }
}

