/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.AtomicContributionBasedPostProcessor;
import chemaxon.calculations.training.logp.LogPUtil;
import chemaxon.struc.Molecule;

public class LogPPredictionPostProcessor
extends AtomicContributionBasedPostProcessor {
    double[] methodWeights = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] HBondCount = null;
    double cKation = 0.1;
    double cAnion = 0.1;
    Molecule mol;
    private static final int COOn = 1;
    private static final int On = 2;
    private static final int Np = 4;
    private static final int Sn = 3;
    private static final int aNp = 5;
    private static final int Nn = 6;
    private static final int Cn = 7;
    private static final int XOOOn = 8;
    private int araAnion_N = 0;
    private int aliAnion_N = 0;
    private int araKation = 0;
    private int aliKation = 0;
    private int aliAnion_CO = 0;
    private int aliAnion_O = 0;
    private int aliAnion_S = 0;
    private int aliAnion_C = 0;
    private int aliAnion_XOOO = 0;
    private int[] ionTypes;
    private int sphereSize = 0;
    private int[] sphere;
    private int[] shortestDist;
    private int[][] ctab;
    double ionicInc = 0.0;
    double halogenInc = 0.0;
    Ionizer ionizer;
    int[][] atomIDs;
    protected boolean processIons;

    @Override
    public double postprocess(Molecule data, double prediction) {
        this.mol = data;
        if (this.atomIDs == null) {
            this.atomIDs = this.getAtomIDs(data);
        }
        this.processMolecule(data, -1);
        double value = prediction + (1.0 - this.methodWeights[3]) * (this.getCorrection() + this.ionicInc + this.halogenInc);
        this.atomIDs = null;
        return value;
    }

    protected double getStructuralIncrement(Molecule data) {
        this.mol = data;
        this.atomIDs = this.getAtomIDs(data);
        this.processMolecule(data, -1);
        this.atomIDs = null;
        return this.getCorrection();
    }

    public void setAtomIDs(int[][] atomIDs) {
        this.atomIDs = atomIDs;
    }

    private int[][] getAtomIDs(Molecule molecule) {
        int[][] ids = new int[molecule.getAtomCount()][2];
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            ids[i] = LogPUtil.getAtomID(molecule, i);
        }
        return ids;
    }

    void resetProcessor(Molecule molecule) {
        this.ionTypes = new int[molecule.getAtomCount()];
        this.ctab = molecule.getCtab();
        this.araAnion_N = 0;
        this.aliAnion_N = 0;
        this.araKation = 0;
        this.aliKation = 0;
        this.aliAnion_CO = 0;
        this.aliAnion_O = 0;
        this.aliAnion_S = 0;
        this.aliAnion_C = 0;
        this.aliAnion_XOOO = 0;
        this.ionicInc = 0.0;
        this.halogenInc = 0.0;
    }

    void resetIonizer(Molecule mol, double[] HBondCounts, Ionizer ionizer) {
        this.HBondCount = HBondCounts;
        this.ionizer = ionizer;
    }

    void resetIonizer(Molecule mol) {
        Ionizer ionizer = this.createIonizer(mol);
        double[] HBondCounts = new double[]{ionizer.getlogPHBondCount(), ionizer.getlogPHBondCount()};
        this.resetIonizer(mol, HBondCounts, ionizer);
    }

    void setMethodWeights(double[] weights) {
        this.methodWeights = weights;
    }

    void setKationConcentration(double cKation) {
        this.cKation = cKation;
    }

    void setAnionConcentration(double cAnion) {
        this.cAnion = cAnion;
    }

    private double getCorrection() {
        double zcorr = this.getZCorrection_New();
        double an = this.getAnionCorrection(this.cAnion);
        double kat = this.getKationCorrection(this.cKation);
        double hbond = this.getHBondCorrection();
        return an + kat + zcorr + hbond;
    }

    double getHBondCorrection() {
        return 0.65 * (this.methodWeights[0] * this.HBondCount[0] + (1.0 - this.methodWeights[0]) * this.HBondCount[1]);
    }

    private void processMolecule(Molecule molecule, int atomIndex) {
        this.resetProcessor(molecule);
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            this.processAtom(molecule, i, this.ionizer, atomIndex);
        }
    }

    private void processAtom(Molecule molecule, int atomIndex, Ionizer ionizer, int actIndex) {
        int[] ids = this.atomIDs[atomIndex];
        int pc = molecule.getAtom(atomIndex).getAtno();
        int charge = molecule.getAtom(atomIndex).getCharge();
        if (pc == 7 && (ids[0] == 1 || ids[0] == 2) && charge != 0) {
            switch (ids[1]) {
                case 2592: {
                    ++this.araAnion_N;
                    break;
                }
                case 12: {
                    ++this.aliAnion_N;
                    this.ionTypes[atomIndex] = 6;
                    break;
                }
                case 200: {
                    ++this.aliKation;
                    this.ionTypes[atomIndex] = 4;
                    break;
                }
                case 36: 
                case 72: 
                case 156: {
                    break;
                }
                default: {
                    if (ionizer.getCarboxy(atomIndex) == 400) {
                        ++this.aliKation;
                        this.ionTypes[atomIndex] = 4;
                        break;
                    }
                    ++this.aliAnion_N;
                    this.ionTypes[atomIndex] = 6;
                }
            }
        }
        if (pc == 7 && charge != 0 && ids[0] == 3) {
            switch (ids[1]) {
                case 2593: {
                    ++this.araKation;
                    this.ionTypes[atomIndex] = 5;
                    break;
                }
                case 9078: {
                    ++this.araKation;
                    this.ionTypes[atomIndex] = 5;
                    break;
                }
                case 9108: {
                    ++this.araKation;
                    this.ionTypes[atomIndex] = 5;
                    break;
                }
                case 223: {
                    ++this.aliKation;
                    this.ionTypes[atomIndex] = 4;
                    break;
                }
                case 228: {
                    ++this.aliKation;
                    this.ionTypes[atomIndex] = 4;
                    break;
                }
                case 2598: {
                    ++this.araKation;
                    this.ionTypes[atomIndex] = 5;
                    break;
                }
                case 267: {
                    ++this.aliKation;
                    this.ionTypes[atomIndex] = 4;
                    break;
                }
                default: {
                    if (ionizer.getCarboxy(atomIndex) == 1200) break;
                    ++this.aliKation;
                    this.ionTypes[atomIndex] = 4;
                }
            }
        }
        if (pc == 7 && charge != 0 && ids[0] == 4) {
            ++this.aliKation;
            this.ionTypes[atomIndex] = 4;
        }
        if (pc == 8 && charge != 0 && ids[0] == 1) {
            switch (ids[1]) {
                case 6: {
                    ++this.aliAnion_CO;
                    this.ionTypes[atomIndex] = 1;
                    break;
                }
                case 50: {
                    ++this.aliAnion_O;
                    this.ionTypes[atomIndex] = 2;
                    if (actIndex != -1 && actIndex != atomIndex) break;
                    this.ionicInc += (1.0 - this.methodWeights[0]) * (-0.105 * ionizer.getMpk0(atomIndex) - 1.16);
                    break;
                }
                case 36: {
                    ++this.aliAnion_XOOO;
                    this.ionTypes[atomIndex] = 8;
                    break;
                }
                default: {
                    ++this.aliAnion_O;
                    this.ionTypes[atomIndex] = 2;
                    if (actIndex != -1 && actIndex != atomIndex) break;
                    this.ionicInc += (1.0 - this.methodWeights[0]) * (-0.105 * ionizer.getMpk0(atomIndex) - 1.16);
                }
            }
        }
        if (pc == 16 && charge != 0) {
            ++this.aliAnion_S;
            this.ionTypes[atomIndex] = 3;
        }
        if (pc == 6 && charge != 0 && ids[0] == 3) {
            ++this.aliAnion_C;
            this.ionTypes[atomIndex] = 7;
        }
        if (actIndex != -1 && actIndex != atomIndex) {
            return;
        }
        if (pc == 33 && ids[1] == 108) {
            this.halogenInc += this.getXHalogenInc(atomIndex);
        }
        if (pc == 5) {
            if ((ids[1] == 122 || ids[1] == 108) && ionizer.getValenceState(atomIndex) == 3) {
                this.halogenInc += 1.5 * this.getXHalogenInc(atomIndex);
            } else if (ids[1] != 48 && ids[1] != 78 && ionizer.getValenceState(atomIndex) == 3) {
                this.halogenInc += this.getXHalogenInc(atomIndex);
            }
        }
    }

    private double getXHalogenInc(int a) {
        int inc = 0;
        for (int i = 0; i < this.ctab[a].length; ++i) {
            if (this.ionizer.getCarboxy(this.ctab[a][i]) != 1400) continue;
            ++inc;
        }
        return -0.35 * (double)inc * this.methodWeights[0];
    }

    double getZCorrection_New() {
        double logPMicro = 0.0;
        if (this.aliKation > 0 & this.aliAnion_CO > 0) {
            logPMicro += 4.3 * this.getDipolFact(this.aliKation, this.aliAnion_CO);
        } else if (this.aliAnion_CO > 0 & this.araKation > 0) {
            logPMicro += 3.3 * this.getDipolFact(this.araKation, this.aliAnion_CO);
        } else if (this.aliKation > 0 & this.aliAnion_O > 0) {
            logPMicro += 4.3 * this.getDipolFact(this.aliKation, this.aliAnion_O);
        } else if (this.araKation > 0 & this.aliAnion_XOOO > 0) {
            logPMicro += 1.2 * this.getDipolFact(this.araKation, this.aliAnion_XOOO);
        } else if (this.aliKation > 0 & this.aliAnion_XOOO > 0) {
            logPMicro += 4.4 * this.getDipolFact(this.aliKation, this.aliAnion_XOOO);
        } else if (this.aliKation > 0 & this.aliAnion_S > 0) {
            logPMicro += 4.2 * this.getDipolFact(this.aliKation, this.aliAnion_S);
        } else if (this.aliKation > 0 & this.aliAnion_N > 0) {
            logPMicro += 3.1 * this.getDipolFact(this.aliKation, this.aliAnion_N);
        } else if (this.aliKation > 0 & this.aliAnion_C > 0) {
            logPMicro += 3.6 * this.getDipolFact(this.aliKation, this.aliAnion_C);
        }
        return logPMicro;
    }

    double getDipolFact(int c, int a) {
        double dipFact = c > a ? (double)a : (double)c;
        return dipFact;
    }

    double getZCorrection() {
        double dFact = 0.0;
        double logPMicro = 0.0;
        if (this.aliKation > 0 & this.aliAnion_CO > 0) {
            dFact = this.calcDistanceFactor(1);
            logPMicro += dFact * (double)(this.aliKation > this.aliAnion_CO ? this.aliAnion_CO : this.aliKation);
        } else if (this.aliAnion_CO > 0 & this.araKation > 0) {
            dFact = this.calcDistanceFactor(2);
            logPMicro += 0.7 * dFact * (double)(this.araKation > this.aliAnion_CO ? this.aliAnion_CO : this.araKation);
        } else if (this.aliKation > 0 & this.aliAnion_O > 0) {
            dFact = this.calcDistanceFactor(3);
            logPMicro += 0.9 * dFact * (double)(this.aliKation > this.aliAnion_O ? this.aliAnion_O : this.aliKation);
        } else if (this.araKation > 0 & this.aliAnion_XOOO > 0) {
            dFact = this.calcDistanceFactor(7);
            logPMicro += 0.25 * dFact * (double)(this.araKation > this.aliAnion_XOOO ? this.aliAnion_XOOO : this.araKation);
        } else if (this.aliKation > 0 & this.aliAnion_XOOO > 0) {
            dFact = this.calcDistanceFactor(8);
            logPMicro += dFact * (this.aliKation > this.aliAnion_XOOO ? 1.0 + 0.66 * (double)(this.aliKation - 1) : 1.0 + 0.66 * (double)(this.aliAnion_XOOO - 1));
        } else if (this.aliKation > 0 & this.aliAnion_S > 0) {
            logPMicro += 4.8 * (double)(this.aliKation > this.aliAnion_S ? this.aliAnion_S : this.aliKation);
        } else if (this.aliKation > 0 & this.aliAnion_N > 0) {
            dFact = this.calcDistanceFactor(5);
            logPMicro += 0.66 * dFact * (double)(this.aliKation > this.aliAnion_N ? this.aliAnion_N : this.aliKation);
        } else if (this.aliKation > 0 & this.aliAnion_C > 0) {
            dFact = this.calcDistanceFactor(6);
            logPMicro += 0.8 * dFact * (double)(this.aliKation > this.aliAnion_C ? this.aliAnion_C : this.aliKation);
        }
        return logPMicro;
    }

    private double calcDistanceFactor(int interactionType) {
        switch (interactionType) {
            case 1: {
                return this.calcDistanceFactor(1, 4, 15);
            }
            case 2: {
                return this.calcDistanceFactor(1, 5, 10);
            }
            case 3: {
                return this.calcDistanceFactor(2, 4, 15);
            }
            case 4: 
            case 5: {
                return this.calcDistanceFactor(6, 4, 15);
            }
            case 6: {
                return this.calcDistanceFactor(7, 4, 15);
            }
            case 7: {
                return this.calcDistanceFactor(8, 5, 15);
            }
            case 8: {
                return this.calcDistanceFactor(8, 4, 15);
            }
        }
        return 0.0;
    }

    private double calcDistanceFactor(int ionType1, int ionType2, int maxDistance) {
        double factor = 0.0;
        for (int i = 0; i < this.ionTypes.length; ++i) {
            if (this.ionTypes[i] != ionType1) continue;
            this.calcShortestDistance(i, maxDistance);
            double tempF = this.calcFactor(ionType2);
            if (!(tempF > factor)) continue;
            factor = tempF;
        }
        return factor;
    }

    private double calcFactor(int itype) {
        double factor = 0.0;
        double tempF = 0.0;
        for (int i = 0; i < this.sphereSize; ++i) {
            double factorForOther;
            int distance;
            double factorForVG;
            int a = this.sphere[i];
            if (this.ionTypes[a] != itype || !((tempF = (factorForVG = (tempF = -0.05476 * (double)(distance = this.shortestDist[a] - 2) * (double)distance + 0.17024 * (double)distance + 4.71429)) * this.methodWeights[0] + (factorForOther = -0.05476 * (double)distance * (double)distance + 0.17024 * (double)distance + 3.71429) * (this.methodWeights[1] + this.methodWeights[2] + this.methodWeights[3])) > factor)) continue;
            factor = tempF;
        }
        if (factor < 0.0) {
            factor = 0.0;
        }
        return factor;
    }

    private void calcShortestDistance(int atom, int maxDistance) {
        int actAtom = atom;
        int MOLATOMS = this.ionTypes.length;
        this.shortestDist = new int[MOLATOMS];
        this.sphere = new int[MOLATOMS];
        this.sphereSize = 0;
        for (int i = 0; i < MOLATOMS; ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        while (distance < maxDistance + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.ctab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.ctab[actAtom][j];
                    if (sphereAtom >= MOLATOMS || this.shortestDist[sphereAtom] != 0 || sphereAtom == atom) continue;
                    this.shortestDist[sphereAtom] = distance;
                    this.sphere[this.sphereSize] = sphereAtom;
                    ++this.sphereSize;
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = this.shortestDist[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            ++i;
        }
        if (this.sphereSize != 0) {
            this.shortestDist[atom] = 0;
        }
    }

    double getKationCorrection(double cKation) {
        double DlogPMicro = 0.0;
        if (this.aliAnion_O != 0) {
            DlogPMicro = (5.07 * Math.pow(cKation, 0.11863) - 1.912 * cKation - 3.64) * (double)this.aliAnion_O;
        }
        if (this.aliAnion_S != 0 || this.aliAnion_CO != 0 || this.aliAnion_N != 0 || this.araAnion_N != 0) {
            DlogPMicro += 3.19 * Math.pow(cKation, 0.047) + 1.762 * cKation - 3.06;
            DlogPMicro = (double)(this.aliAnion_S + this.aliAnion_CO + this.aliAnion_N + this.araAnion_N + this.aliAnion_C) * DlogPMicro;
        }
        return DlogPMicro;
    }

    double getAnionCorrection(double cAnion) {
        double DlogPMicro = 6.27 * Math.pow(cAnion, 0.19489) - 1.015 * cAnion - 3.902;
        int multi = this.aliKation + this.araKation;
        return (double)multi * DlogPMicro;
    }

    @Override
    public double postprocess(Molecule data, int atomIndex, double prediction) {
        if (data.getAtomCount() <= atomIndex) {
            return 0.0;
        }
        if (this.atomIDs == null) {
            this.atomIDs = this.getAtomIDs(data);
        }
        this.processMolecule(data, atomIndex);
        double atomicCorrection = this.processIons ? this.getCorrection() / (double)data.getAtomCount() : 0.0;
        double value = prediction + atomicCorrection + this.ionicInc + this.halogenInc;
        if (atomIndex == data.getAtomCount() - 1) {
            this.atomIDs = null;
        }
        return value;
    }

    private Ionizer createIonizer(Molecule mol) {
        Ionizer ionizer = new Ionizer();
        ionizer.setpKaPrefixType(1);
        ionizer.setMolecule(mol);
        ionizer.setMspHCalc(true);
        ionizer.calculatepKa(0.0);
        return ionizer;
    }
}

