/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.Preprocessor;
import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class LogPPredictionPreProcessor
implements Preprocessor<Molecule> {
    LogPPredictor.MethodType methodType = LogPPredictor.MethodType.IONIC;
    private double pH = -1.0;
    private boolean convertOnlyZwitterIons = false;

    void setMethodType(LogPPredictor.MethodType methodType) {
        this.methodType = methodType;
    }

    protected void setPH(double pH) {
        this.pH = pH;
    }

    protected double getPH() {
        return this.pH;
    }

    protected void setOnlyZwitterIonsConvertToMajorForm(boolean onlyZwitterIons) {
        this.convertOnlyZwitterIons = onlyZwitterIons;
    }

    @Override
    public Molecule preprocess(Molecule data) {
        Molecule cloneMol;
        Molecule molecule = cloneMol = this.pH > 0.0 ? this.getMajorForm(data, this.pH, this.convertOnlyZwitterIons) : data.cloneMoleculeWithDocument();
        if (this.methodType.equals((Object)LogPPredictor.MethodType.NONE)) {
            return cloneMol;
        }
        cloneMol.implicitizeHydrogens(2047);
        if (this.methodType.equals((Object)LogPPredictor.MethodType.NEUTRAL) || this.methodType.equals((Object)LogPPredictor.MethodType.TRUE) || this.methodType.equals((Object)LogPPredictor.MethodType.AMPHOTER) && this.pH < 0.0) {
            LogPPredictionPreProcessor.neutralizeMolecule(cloneMol);
        }
        cloneMol.aromatize(1);
        return cloneMol;
    }

    protected Molecule getMajorForm(Molecule molecule, double pH, boolean convertOnlyZwitterIons) {
        if (Double.isNaN(pH)) {
            return molecule;
        }
        Ionizer ionizer = new Ionizer();
        ionizer.setpKaPrefixType(1);
        ionizer.setMolecule(molecule);
        ionizer.setMspHCalc(true);
        ionizer.calculatepKa(pH);
        if (!convertOnlyZwitterIons || ionizer.isTrueZwitterIon()) {
            return ionizer.getMajorMicroSpecies(pH, molecule);
        }
        return molecule.cloneMoleculeWithDocument();
    }

    protected static void neutralizeMolecule(Molecule m) {
        int atomCount = m.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            MolAtom atom = m.getAtom(i);
            int charge = atom.getCharge();
            int pc = atom.getAtno();
            boolean single = LogPPredictionPreProcessor.isSingleAnion(atom, charge);
            if (pc != 8 && pc != 7 && pc != 16 && pc != 15 && !single && (pc != 6 || charge != -1) || charge == 0) continue;
            int implicitHCount = atom.getImplicitHcount();
            if (charge < 0) {
                int v = atom.getBondCount() + (implicitHCount - charge);
                if (pc == 7 && v > 3) {
                    return;
                }
                atom.setImplicitHcount(implicitHCount - charge);
                atom.setCharge(0);
                continue;
            }
            if (implicitHCount <= 0) continue;
            if (implicitHCount - charge < 0) {
                return;
            }
            atom.setImplicitHcount(implicitHCount - charge);
            atom.setCharge(0);
        }
    }

    private static boolean isSingleAnion(MolAtom a, int chg) {
        return chg < 0 && a.getImplicitHcount() == 0 && a.getBondCount() == 0;
    }
}

