/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.AtomicContributionBasedPredictor;
import chemaxon.calculations.training.AtomicContributionBasedTrainingModel;
import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.Stat;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.calculations.training.logp.LogPDefaultModel;
import chemaxon.calculations.training.logp.LogPDefaults;
import chemaxon.calculations.training.logp.LogPPredictionAlgorithm;
import chemaxon.calculations.training.logp.LogPPredictionPostProcessor;
import chemaxon.calculations.training.logp.LogPPredictionPreProcessor;
import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.calculations.training.logp.LogPUserModel;
import chemaxon.calculations.training.logp.LogPVGModel;
import chemaxon.struc.Molecule;

public class LogPPredictorImpl
extends AtomicContributionBasedPredictor
implements LogPPredictor {
    private static final double ln10 = 2.302585092994046;
    private double weightVG = 0.3333333333333333;
    private double weightKLOP = 0.3333333333333333;
    private double weightPHYS = 0.3333333333333333;
    private double weightUSER = 0.0;
    private SVDTrainingResult userParameters;
    protected double cAnion = 0.1;
    protected double cKation = 0.1;
    protected LogPPredictor.MethodType methodType = LogPPredictor.MethodType.TRUE;
    boolean valid = true;
    protected static final int VG = 0;
    protected static final int KLOP = 1;
    protected static final int PHYS = 2;
    protected static final int USER = 3;
    private Ionizer ionizer = null;
    double[] zwitterionincrements;

    public LogPPredictorImpl() {
        super(new LogPPrediction(new LogPPredictionAlgorithm(), new AtomicContributionBasedTrainingModel()));
        this.setPreprocessor(new LogPPredictionPreProcessor());
        this.setPosprocessor(new LogPPredictionPostProcessor());
    }

    public LogPPredictorImpl(LogPPredictor.MethodType mType) {
        this();
        this.methodType = mType;
    }

    @Override
    public void setPH(double pH) {
        if (this.preprocessor != null && this.preprocessor instanceof LogPPredictionPreProcessor) {
            ((LogPPredictionPreProcessor)this.preprocessor).setPH(pH);
        }
    }

    private Molecule getPreprocessedItem(Molecule item) {
        Molecule preProcessedItem = item;
        if (this.preprocessor != null && this.preprocessor instanceof LogPPredictionPreProcessor) {
            ((LogPPredictionPreProcessor)this.preprocessor).setMethodType(this.methodType);
            preProcessedItem = this.preprocessor.preprocess(item);
            ((LogPPredictionPreProcessor)this.preprocessor).setMethodType(LogPPredictor.MethodType.NONE);
        }
        return preProcessedItem;
    }

    private Molecule getPreprocessedUserItem(Molecule item) {
        Molecule preProcessedItem = item;
        if (this.preprocessor != null && this.preprocessor instanceof LogPPredictionPreProcessor) {
            double pH = ((LogPPredictionPreProcessor)this.preprocessor).getPH();
            if (this.methodType.equals((Object)LogPPredictor.MethodType.AMPHOTER)) {
                ((LogPPredictionPreProcessor)this.preprocessor).setPH(6.0);
            }
            ((LogPPredictionPreProcessor)this.preprocessor).setMethodType(this.methodType);
            preProcessedItem = this.preprocessor.preprocess(item);
            ((LogPPredictionPreProcessor)this.preprocessor).setMethodType(LogPPredictor.MethodType.NONE);
            ((LogPPredictionPreProcessor)this.preprocessor).setPH(pH);
        }
        return preProcessedItem;
    }

    private void initPostProcessor(Ionizer ionizer, Molecule mol, double[] HBondCounts) {
        this.initPostProcessor(ionizer, mol, HBondCounts, true);
    }

    private void initPostProcessor(Ionizer ionizer, Molecule mol, double[] HBondCounts, boolean processIons) {
        if (this.postprocessor == null || !(this.postprocessor instanceof LogPPredictionPostProcessor)) {
            return;
        }
        LogPPredictionPostProcessor logPProc = (LogPPredictionPostProcessor)this.postprocessor;
        logPProc.setMethodWeights(new double[]{this.weightVG, this.weightKLOP, this.weightPHYS, this.weightUSER});
        logPProc.setAnionConcentration(this.cAnion);
        logPProc.setKationConcentration(this.cKation);
        logPProc.resetIonizer(mol, HBondCounts, ionizer);
        logPProc.processIons = processIons;
    }

    private void setLogPPredictionMethod(int method) {
        ((LogPPrediction)this.prediction).method = method;
        double[] weights = new double[]{0.0, 0.0, 0.0, 0.0};
        weights[method] = 1.0;
        ((LogPPredictionPostProcessor)this.postprocessor).setMethodWeights(weights);
    }

    private double predict(SVDTrainingResult coeffs, double weight, Ionizer ionizer, Molecule mol, int atomIndex) {
        this.setCoefficients(coeffs);
        ((LogPPrediction)this.prediction).ionizer = ionizer;
        return (atomIndex == -1 ? super.predict(mol) : super.predictAtomicIncrement(mol, ionizer, atomIndex, atomIndex == 0)) * weight;
    }

    @Override
    public double predict(Molecule item) {
        this.valid = true;
        Molecule preProcessedItem = this.getPreprocessedItem(item);
        double[] hBondCounts = new double[2];
        int[] ionCount = new int[]{0};
        Ionizer ionizer = this.createIonizer(preProcessedItem, this.methodType, hBondCounts, ionCount);
        this.initPostProcessor(ionizer, preProcessedItem, hBondCounts);
        ((LogPPrediction)this.prediction).postProcessor = (LogPPredictionPostProcessor)this.postprocessor;
        double result = this.predict(item, ionizer, ionCount[0], -1);
        this.ionizer = null;
        return result;
    }

    @Override
    public double[] predict(Molecule ... items) {
        double[] result = new double[items.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.predict(items[i]);
        }
        return result;
    }

    private boolean isMacropKaCalcRequiredBylogP(Ionizer ionizer, Molecule mol) {
        if (this.methodType.equals((Object)LogPPredictor.MethodType.TRUE) || this.methodType.equals((Object)LogPPredictor.MethodType.AMPHOTER)) {
            ionizer.setpKaPrefixType(1);
            ionizer.setMolecule(mol);
            ionizer.setMspHCalc(false);
            ionizer.setmicropKaCalc(true);
            ionizer.initMsCalculation();
            int ionCount = ionizer.getIonizableAtomCount();
            return ionCount != 0 && ionizer.isTrueZwitterIon();
        }
        return false;
    }

    private double predict(Molecule item, Ionizer ionizer, int ionCount, int atomIndex) {
        return this.predict(item, ionizer, ionCount, atomIndex, true);
    }

    private double predict(Molecule item, Ionizer ionizer, int ionCount, int atomIndex, boolean preprocessNeeded) {
        boolean isTrueZwitterIon;
        if (ionizer.hasCriticalError()) {
            this.valid = false;
            return Double.NaN;
        }
        Molecule preProcessedItem = preprocessNeeded ? this.getPreprocessedItem(item) : item;
        boolean bl = isTrueZwitterIon = (this.methodType.equals((Object)LogPPredictor.MethodType.TRUE) || this.methodType.equals((Object)LogPPredictor.MethodType.AMPHOTER)) && ionCount != 0 && ionizer.isTrueZwitterIon();
        if (isTrueZwitterIon) {
            return this.predictZwitterIonLogP(preProcessedItem, ionizer, atomIndex);
        }
        if (this.methodType.equals((Object)LogPPredictor.MethodType.AMPHOTER)) {
            return Double.NaN;
        }
        return this.predictNonZwitterIonLogP(preProcessedItem, ionizer, atomIndex);
    }

    private double predictZwitterIonLogP(Molecule item, Ionizer ionizer, int atomIndex) {
        if (atomIndex == -1) {
            return this.getZwitterIonLogP(ionizer, item, atomIndex);
        }
        if (atomIndex == 0) {
            this.getZwitterIonLogP(ionizer, item);
            return this.zwitterionincrements[0];
        }
        return this.zwitterionincrements[atomIndex];
    }

    private double predictNonZwitterIonLogP(Molecule item, Ionizer ionizer, int atomIndex) {
        double pred;
        double prediction = 0.0;
        double VGprediction = Double.NaN;
        ((LogPPrediction)this.prediction).reset = true;
        if (this.weightVG > 0.0) {
            this.setLogPPredictionMethod(0);
            ((LogPPredictionPostProcessor)this.postprocessor).setMethodWeights(new double[]{1.0, 0.0, 0.0, 0.0});
            VGprediction = this.predict(LogPDefaults.VG, this.weightVG, ionizer, item, atomIndex);
            prediction += VGprediction;
            VGprediction /= this.weightVG;
        }
        if (this.ionizer == null && this.methodType.equals((Object)LogPPredictor.MethodType.IONIC) && (this.weightKLOP > 0.0 || this.weightPHYS > 0.0 || this.weightUSER > 0.0)) {
            ionizer.calculatepKa(0.0);
        }
        if (this.weightKLOP > 0.0) {
            this.setLogPPredictionMethod(1);
            pred = this.predict(LogPDefaults.KLOPMAN, this.weightKLOP, ionizer, item, atomIndex);
            if (!this.isPredictionSucces()) {
                if (Double.isNaN(VGprediction)) {
                    this.setLogPPredictionMethod(0);
                    ionizer = this.ionizer == null && this.methodType.equals((Object)LogPPredictor.MethodType.IONIC) ? this.createSimpleIonizer(item) : ionizer;
                    VGprediction = this.predict(LogPDefaults.VG, 1.0, ionizer, item, atomIndex);
                }
                pred = VGprediction * this.weightKLOP;
            }
            prediction += pred;
        }
        if (this.weightPHYS > 0.0) {
            this.setLogPPredictionMethod(2);
            pred = this.predict(LogPDefaults.PHYSPROP, this.weightPHYS, ionizer, item, atomIndex);
            if (!this.isPredictionSucces()) {
                if (Double.isNaN(VGprediction)) {
                    this.setLogPPredictionMethod(0);
                    ionizer = this.ionizer == null && this.methodType.equals((Object)LogPPredictor.MethodType.IONIC) ? this.createSimpleIonizer(item) : ionizer;
                    VGprediction = this.predict(LogPDefaults.VG, 1.0, ionizer, item, atomIndex);
                }
                pred = VGprediction * this.weightPHYS;
            }
            prediction += pred;
        }
        if (this.weightUSER > 0.0) {
            this.setLogPPredictionMethod(3);
            Molecule userItem = this.methodType.equals((Object)LogPPredictor.MethodType.AMPHOTER) ? this.getPreprocessedUserItem(item) : item;
            double pred2 = this.predict(this.userParameters, this.weightUSER, ionizer, userItem, atomIndex);
            if (!this.isPredictionSucces() && !this.isPredictOnlyTrainables()) {
                if (Double.isNaN(VGprediction)) {
                    this.setLogPPredictionMethod(0);
                    ionizer = this.ionizer == null && this.methodType.equals((Object)LogPPredictor.MethodType.IONIC) ? this.createSimpleIonizer(item) : ionizer;
                    VGprediction = this.predict(LogPDefaults.VG, 1.0, ionizer, item, atomIndex);
                }
                pred2 = VGprediction * this.weightUSER;
            }
            prediction += pred2;
        }
        return prediction;
    }

    @Override
    public void setWeightOfMethods(double wVG, double wKLOP, double wPHYS, double wUSER) {
        this.weightVG = wVG;
        this.weightKLOP = wKLOP;
        this.weightPHYS = wPHYS;
        this.weightUSER = wUSER;
        this.standardizeMethodWeights();
    }

    @Override
    public void setCloridIonConcentration(double anion) {
        this.cAnion = anion;
    }

    @Override
    public void setNaKIonConcentration(double kation) {
        this.cKation = kation;
    }

    private void standardizeMethodWeights() {
        double sumWeight = this.weightVG + this.weightKLOP + this.weightPHYS + this.weightUSER;
        if (sumWeight == 0.0) {
            this.weightVG = 0.3333333333333333;
            this.weightKLOP = 0.3333333333333333;
            this.weightPHYS = 0.3333333333333333;
        } else {
            this.weightVG /= sumWeight;
            this.weightKLOP /= sumWeight;
            this.weightPHYS /= sumWeight;
            this.weightUSER /= sumWeight;
        }
    }

    private void setCoefficients(SVDTrainingResult coefficients) {
        super.setTrainingResults(coefficients);
    }

    @Override
    public void setTrainingResults(SVDTrainingResult results) {
        this.userParameters = results;
    }

    @Override
    public void setLogPMethod(LogPPredictor.MethodType mtype) {
        this.methodType = mtype;
    }

    private LogPPredictor.MethodType getLogPMethod() {
        return this.methodType;
    }

    private double getZwitterIonLogP(Ionizer ionizer, Molecule mol, int atomIndex) {
        double[] weights = new double[]{this.weightVG, this.weightKLOP, this.weightPHYS, this.weightUSER};
        double userLogP = 0.0;
        if (this.weightUSER > 0.0) {
            this.setWeightOfMethods(0.0, 0.0, 0.0, 1.0);
            userLogP = this.predictNonZwitterIonLogP(mol, ionizer, atomIndex) * weights[3];
            this.setWeightOfMethods(weights[0], weights[1], weights[2], weights[3]);
            if (!Double.isNaN(userLogP)) {
                if (this.weightUSER == 1.0) {
                    return userLogP;
                }
                this.weightUSER = 0.0;
            }
        }
        ionizer.getMspH(0);
        double pI = ionizer.calcpI();
        ionizer.recalcSpeciesOrder(pI);
        ionizer.calcMsDistribution(pI);
        int msCount = ionizer.getMicroSpeciesCount();
        double N = 0.0;
        double D = 0.0;
        for (int i = 0; i < msCount; ++i) {
            Molecule microSpecies = ionizer.getSortedMicroSpecies(i);
            LogPPredictor.MethodType tmp = this.getLogPMethod();
            this.setLogPMethod(LogPPredictor.MethodType.NONE);
            double logP = this.predict(microSpecies, ionizer, 0, atomIndex, false);
            this.setLogPMethod(tmp);
            double msdist = ionizer.getSortedMsDistribution(i);
            N += Math.pow(10.0, logP) * msdist;
            D += msdist;
        }
        this.weightUSER = weights[3];
        return Math.log(N / D) / 2.302585092994046 + (Double.isNaN(userLogP) ? 0.0 : userLogP);
    }

    private void getZwitterIonLogP(Ionizer ionizer, Molecule mol) {
        double[] weights = new double[]{this.weightVG, this.weightKLOP, this.weightPHYS, this.weightUSER};
        double[] userLogP = new double[mol.getAtomCount()];
        this.zwitterionincrements = new double[mol.getAtomCount()];
        ionizer.getMspH(0);
        double pI = ionizer.calcpI();
        ionizer.recalcSpeciesOrder(pI);
        ionizer.calcMsDistribution(pI);
        int msCount = ionizer.getMicroSpeciesCount();
        double[] NN = new double[mol.getAtomCount()];
        double N = 0.0;
        double D = 0.0;
        for (int i = 0; i < msCount; ++i) {
            Molecule microSpecies = ionizer.getSortedMicroSpecies(i);
            LogPPredictor.MethodType tmp = this.getLogPMethod();
            this.setLogPMethod(LogPPredictor.MethodType.NONE);
            double[] logP = new double[mol.getAtomCount()];
            double logPAll = 0.0;
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                if (!(this.weightUSER > 0.0)) continue;
                this.setWeightOfMethods(0.0, 0.0, 0.0, 1.0);
                userLogP[j] = this.predictNonZwitterIonLogP(mol, ionizer, j) * weights[3];
                this.setWeightOfMethods(weights[0], weights[1], weights[2], weights[3]);
                if (!(this.weightUSER < 1.0)) continue;
                this.weightUSER = 0.0;
                logP[j] = this.predict(microSpecies, ionizer, 0, j, false);
                this.weightUSER = weights[3];
            }
            logPAll = this.predict(microSpecies, ionizer, 0, -1, false);
            this.setLogPMethod(tmp);
            double msdist = ionizer.getSortedMsDistribution(i);
            D += msdist;
            N += Math.pow(10.0, logPAll) * msdist;
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                int n = j;
                NN[n] = NN[n] + Math.pow(10.0, logP[j]) * msdist;
            }
        }
        for (int j = 0; j < mol.getAtomCount(); ++j) {
            this.zwitterionincrements[j] = this.weightUSER == 1.0 ? userLogP[j] : Math.log(NN[j] / D) / 2.302585092994046 + userLogP[j];
        }
    }

    private Ionizer createIonizer(Molecule mol, LogPPredictor.MethodType methodType, double[] HBondCounts, int[] ionCount) {
        if (this.ionizer != null) {
            HBondCounts[0] = this.ionizer.getlogPHBondCount();
            HBondCounts[1] = HBondCounts[0];
            return this.ionizer;
        }
        Ionizer ionizer = new Ionizer();
        boolean macroPkaNeed = this.isMacropKaCalcRequiredBylogP(ionizer, mol);
        switch (methodType) {
            case TRUE: 
            case AMPHOTER: {
                if (macroPkaNeed) {
                    ionizer = new Ionizer();
                    ionizer.setpKaPrefixType(1);
                    ionizer.setMolecule(mol);
                    ionizer.setMspHCalc(true);
                    ionizer.calculatepKa(0.0);
                    ionCount[0] = ionizer.getIonizableAtomCount();
                }
                HBondCounts[0] = ionizer.getlogPHBondCount();
                HBondCounts[1] = HBondCounts[0];
                break;
            }
            case NEUTRAL: {
                ionizer.setpKaPrefixType(1);
                ionizer.setMolecule(mol);
                ionizer.micropKaCalc = true;
                ionizer.initMsCalculation();
                HBondCounts[0] = ionizer.getlogPHBondCount();
                HBondCounts[1] = HBondCounts[0];
                break;
            }
            case IONIC: {
                ionizer.setpKaPrefixType(1);
                ionizer.setMolecule(mol);
                ionizer.micropKaCalc = true;
                ionizer.initMsCalculation();
                HBondCounts[0] = ionizer.getlogPHBondCount();
                HBondCounts[1] = HBondCounts[0];
                break;
            }
        }
        return ionizer;
    }

    private Ionizer createSimpleIonizer(Molecule mol) {
        Ionizer ionizer = new Ionizer();
        ionizer.setpKaPrefixType(1);
        ionizer.setMolecule(mol);
        ionizer.micropKaCalc = true;
        ionizer.initMsCalculation();
        return ionizer;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public double[] predictAtomicIncrements(Molecule item) {
        return this.predictAtomicIncrements(item, false);
    }

    @Override
    public double[][] predictAtomicIncrements(Molecule ... items) {
        double[][] result = new double[items.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.predictAtomicIncrements(items[i]);
        }
        return result;
    }

    public double[] predictAtomicIncrements(Molecule item, boolean postProcess) {
        return this.predictAtomicIncrements(item, postProcess, true);
    }

    private double[] predictAtomicIncrements(Molecule item, boolean postProcess, boolean calcAgain) {
        this.valid = true;
        Molecule preProcessedItem = this.getPreprocessedItem(item);
        double[] HBondCounts = new double[2];
        int[] ionCount = new int[]{0};
        Ionizer ionizer = this.createIonizer(preProcessedItem, this.methodType, HBondCounts, ionCount);
        this.initPostProcessor(ionizer, preProcessedItem, HBondCounts, postProcess);
        double[] result = new double[item.getAtomCount()];
        boolean isNaN = false;
        for (int i = 0; i < result.length && !isNaN; isNaN |= Double.isNaN(result[i]), ++i) {
            result[i] = this.predict(item, ionizer, ionCount[0], i);
        }
        return isNaN && calcAgain ? this.calcVG(item) : result;
    }

    private boolean isPredictionSucces() {
        return ((LogPPrediction)this.prediction).hasDataForMethod;
    }

    private double[] calcVG(Molecule item) {
        double VG = this.weightVG;
        double klop = this.weightKLOP;
        double phys = this.weightPHYS;
        double user = this.weightUSER;
        this.setWeightOfMethods(1.0, 0.0, 0.0, 0.0);
        double[] result = this.predictAtomicIncrements(item, false, false);
        this.setWeightOfMethods(VG, klop, phys, user);
        return result;
    }

    @Override
    public int getThreadCount() {
        return 1;
    }

    @Override
    public double[] predictStructuralIncrement(Molecule ... molecules) {
        double[] increments = new double[molecules.length];
        for (int i = 0; i < increments.length; ++i) {
            increments[i] = this.predictStructuralIncrement(molecules[i]);
        }
        return increments;
    }

    protected double predictStructuralIncrement(Molecule molecule) {
        double sInc = 0.0;
        Molecule preProcessedItem = this.getPreprocessedItem(molecule);
        if (this.weightUSER > 0.0) {
            LogPUserModel uModel = new LogPUserModel();
            double[] descList = uModel.getDescriptors(preProcessedItem, true);
            double[] strucList = new double[300];
            System.arraycopy(descList, 140, strucList, 140, 9);
            sInc += this.weightUSER * Stat.multiply(this.userParameters.getCoefficient(), strucList, true);
        }
        if (this.weightUSER < 1.0) {
            double[] hBondCounts = new double[2];
            Ionizer ionizer = this.createIonizer(preProcessedItem, this.methodType, hBondCounts, new int[1]);
            this.initPostProcessor(ionizer, preProcessedItem, hBondCounts);
            sInc += (1.0 - this.weightUSER) * ((LogPPredictionPostProcessor)this.postprocessor).getStructuralIncrement(molecule);
        }
        return sInc;
    }

    protected Ionizer getIonizer() {
        return this.ionizer;
    }

    protected void setIonizer(Ionizer ionizer) {
        this.ionizer = ionizer;
    }

    @Override
    public void setOnlyZwitterIonsConvertToMajorForm(boolean onlyZwitterIons) {
        if (this.preprocessor != null && this.preprocessor instanceof LogPPredictionPreProcessor) {
            ((LogPPredictionPreProcessor)this.preprocessor).setOnlyZwitterIonsConvertToMajorForm(onlyZwitterIons);
        }
    }

    @Override
    public double[] predictWithError(Molecule item) {
        double[] result = super.predictWithError(item);
        if (this.weightKLOP > 0.0 || this.weightPHYS > 0.0 || this.weightVG > 0.0) {
            result[1] = Double.NaN;
        }
        return result;
    }

    protected static class LogPPrediction
    extends AtomicContributionBasedPredictor.AtomicContributionBasedPrediction {
        protected int method = 0;
        protected AtomicContributionBasedTrainingModel VGModel = new LogPVGModel();
        protected AtomicContributionBasedTrainingModel userModel = new LogPUserModel();
        protected AtomicContributionBasedTrainingModel defaultModel = new LogPDefaultModel();
        protected Ionizer ionizer;
        protected boolean hasDataForMethod = true;
        protected double[][] VGDescriptors;
        protected double[][] userDescriptors;
        protected LogPPredictionPostProcessor postProcessor;
        protected boolean reset = true;
        protected double[] descriptorCache;

        public LogPPrediction(PredictionAlgorithm<SVDTrainingResult> algorithm, TrainingModel<Molecule> model) {
            super(algorithm, model);
        }

        @Override
        protected double getIncrementOf(int atomIndex) {
            if (this.getCacheByState() == null) {
                return Double.NaN;
            }
            if (atomIndex >= this.getCacheByState().length) {
                return 0.0;
            }
            this.algorithm.setCoefficients(this.trainingResults);
            return this.algorithm.predict(this.getCacheByState()[atomIndex]);
        }

        @Override
        public Double call() throws Exception {
            this.algorithm.setCoefficients(this.trainingResults);
            this.reset |= this.method == 0;
            double[] descriptors = this.reset ? this.getModelByState().getDescriptors((Molecule)this.item, !this.predictOnlytrainables, this.ionizer) : this.descriptorCache;
            this.postProcessor.setAtomIDs(this.getModelByState().getAtomIDs());
            if (this.method != 0) {
                this.descriptorCache = descriptors;
                this.reset = false;
            }
            this.hasDataForMethod = true;
            if (this.method != 0 && descriptors.length == 0) {
                this.hasDataForMethod = false;
                return Double.NaN;
            }
            ((LogPPredictionAlgorithm)this.algorithm).setIonizer(this.ionizer);
            Double result = this.algorithm.predict(descriptors);
            this.stdError = ((LogPPredictionAlgorithm)this.algorithm).getStandardError();
            ((LogPPredictionAlgorithm)this.algorithm).setIonizer(null);
            this.hasDataForMethod = !Double.isNaN(result);
            return result;
        }

        protected AtomicContributionBasedTrainingModel getModelByState() {
            switch (this.method) {
                case 0: {
                    return this.VGModel;
                }
                case 3: {
                    return this.userModel;
                }
            }
            return this.defaultModel;
        }

        protected double[][] getCacheByState() {
            switch (this.method) {
                case 0: {
                    return this.VGDescriptors;
                }
                case 3: {
                    return this.userDescriptors;
                }
            }
            return this.atomicDescriptors;
        }

        protected void setCacheByState(double[][] descriptors) {
            switch (this.method) {
                case 0: {
                    this.VGDescriptors = descriptors;
                    break;
                }
                case 3: {
                    this.userDescriptors = descriptors;
                    break;
                }
                default: {
                    this.atomicDescriptors = descriptors;
                }
            }
        }

        protected void setItem(Molecule item) {
            this.item = item;
        }

        @Override
        protected void createDescriptors(Molecule molecule, Ionizer ionizer) {
            this.setCacheByState(this.getModelByState().getDescriptorsByAtomId(molecule, true, ionizer));
            if (this.method != 0) {
                for (int i = 0; i < this.getCacheByState().length; ++i) {
                    if (this.getCacheByState()[i] != null) continue;
                    if (this.VGDescriptors != null) {
                        this.atomicDescriptors = this.VGDescriptors;
                    }
                    int tmpMethod = this.method;
                    this.method = 0;
                    this.setCacheByState(this.getModelByState().getDescriptorsByAtomId(molecule, true, ionizer));
                    this.postProcessor.setAtomIDs(this.getModelByState().getAtomIDs());
                    this.atomicDescriptors = this.VGDescriptors;
                    this.method = tmpMethod;
                }
            }
        }
    }
}

