/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.training.AtomicContributionBasedTrainer;
import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.TrainerUtils;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.calculations.training.logp.LogPTrainingPreProcessor;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.DesEncrypter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class LogPTrainer
extends AtomicContributionBasedTrainer {
    private boolean primerDataAdded = false;

    public LogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix descriptorMatrix, TrainingModel<Molecule> ... models) {
        super(algorithm, descriptorMatrix, models);
        this.setPreprocessor(new LogPTrainingPreProcessor());
    }

    public LogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix descriptorMatrix, TrainingModel<Molecule> model) {
        super(algorithm, descriptorMatrix, model);
        this.setPreprocessor(new LogPTrainingPreProcessor());
    }

    @Override
    public void add(Molecule molecule, String logPPropertyName) {
        try {
            this.add(molecule, Double.parseDouble(molecule.getProperty(logPPropertyName)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid logP value");
        }
    }

    public void setPH(double pH) {
        ((LogPTrainingPreProcessor)this.getPreprocessor()).setPh(pH);
    }

    public void setOnlyZwitterIonsConvertToMajorForm(boolean onlyZwitterIons) {
        ((LogPTrainingPreProcessor)this.getPreprocessor()).setOnlyZwitterIonsConvertToMajorForm(onlyZwitterIons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPrimerData() {
        if (!this.primerDataAdded) {
            MolImporter importer = null;
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/chemaxon/calculations/builtInLogPTrainingSet");
                importer = new MolImporter(DesEncrypter.decrypt(inputStream, "moc.noxamehc"));
                Molecule mol = importer.read();
                while (mol != null) {
                    this.add(mol, "logP");
                    mol = importer.read();
                }
                this.primerDataAdded = true;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (importer != null) {
                    try {
                        importer.close();
                    }
                    catch (Exception e) {}
                }
            }
            return true;
        }
        return false;
    }

    public boolean isPrimerDataAdded() {
        return this.primerDataAdded;
    }

    @Override
    public void saveResults(String projectName, String trainingName) throws IOException {
        LogPTrainer.saveParameters(projectName, trainingName, this);
    }

    public void saveResults(String trainingName) throws IOException {
        LogPTrainer.saveParameters(trainingName, this);
    }

    public static final File[] getParameterFiles() {
        return TrainerUtils.getParameterFiles("logp");
    }

    public static final File[] getIJCParameterFiles() {
        return LogPTrainer.getIJCParameterFiles(null);
    }

    public static final File[] getIJCParameterFiles(String projectName) {
        return TrainerUtils.getIJCParameterFiles("logp", projectName);
    }

    public static final File[] getNonIJCParameterFiles() {
        return TrainerUtils.getNonIJCParameterFiles("logp");
    }

    public static final void saveParameters(String projectName, String trainingName, LogPTrainer trainer) throws IOException {
        LogPTrainer.saveParameters(projectName + File.separator + trainingName, trainer);
    }

    public static final void saveParameters(String trainingName, LogPTrainer trainer) throws IOException {
        TrainerUtils.saveParameters("logp", trainingName, trainer);
    }

    public static final void saveParameters(String projectName, String trainingName, double[] parameters) throws IOException {
        LogPTrainer.saveParameters(projectName + File.separator + trainingName, parameters);
    }

    public static final SVDTrainingResult loadParameters(String trainingName) throws IOException {
        return TrainerUtils.loadParameters("logp", trainingName);
    }

    public static final SVDTrainingResult loadParameters(String projectName, String trainingName) throws IOException {
        return LogPTrainer.loadParameters(projectName + File.separator + trainingName);
    }

    public static final void saveParameters(String trainingName, double[] parameters) throws IOException {
        TrainerUtils.saveParameters("logp", trainingName, parameters);
    }
}

