/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.Preprocessor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class LogPTrainingPreProcessor
implements Preprocessor<Molecule> {
    private double pH = -1.0;
    private boolean convertOnlyZwitterIons = false;

    @Override
    public Molecule preprocess(Molecule data) {
        Molecule molecule = this.pH > 0.0 ? this.getMajorForm(data, this.pH, this.convertOnlyZwitterIons) : data.cloneMoleculeWithDocument();
        LogPTrainingPreProcessor.setStandardForm(molecule);
        return molecule;
    }

    protected void setPh(double pH) {
        this.pH = pH;
    }

    protected void setOnlyZwitterIonsConvertToMajorForm(boolean onlyZwitterIons) {
        this.convertOnlyZwitterIons = onlyZwitterIons;
    }

    protected Molecule getMajorForm(Molecule molecule, double pH, boolean convertOnlyZwitterIons) {
        if (Double.isNaN(pH)) {
            return molecule;
        }
        molecule.dearomatize();
        molecule.aromatize();
        Ionizer ionizer = new Ionizer();
        ionizer.setpKaPrefixType(1);
        ionizer.setMolecule(molecule);
        ionizer.setMspHCalc(true);
        ionizer.calculatepKa(pH);
        boolean isTrueZwitterIon = ionizer.isTrueZwitterIon();
        if (!convertOnlyZwitterIons || isTrueZwitterIon) {
            return ionizer.getMajorMicroSpecies(pH, molecule);
        }
        return molecule;
    }

    protected static void neutralizeMolecule(Molecule m) {
        int atomCount = m.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            MolAtom atom = m.getAtom(i);
            int charge = atom.getCharge();
            int pc = atom.getAtno();
            boolean single = LogPTrainingPreProcessor.isSingleAnion(atom, charge);
            if (pc != 8 && pc != 7 && pc != 16 && pc != 15 && !single && (pc != 6 || charge != -1) || charge == 0) continue;
            int implicitHCount = atom.getImplicitHcount();
            if (charge < 0) {
                int v = atom.getBondCount() + (implicitHCount - charge);
                if (pc == 7 && v > 3) {
                    return;
                }
                atom.setImplicitHcount(implicitHCount - charge);
                atom.setCharge(0);
                continue;
            }
            if (implicitHCount <= 0) continue;
            if (implicitHCount - charge < 0) {
                return;
            }
            atom.setImplicitHcount(implicitHCount - charge);
            atom.setCharge(0);
        }
    }

    private static boolean isSingleAnion(MolAtom a, int chg) {
        return chg < 0 && a.getImplicitHcount() == 0 && a.getBondCount() == 0;
    }

    public static void setStandardForm(Molecule m) {
        m.dearomatize();
        LogPTrainingPreProcessor.standardizeIonicGroups(m);
        m.aromatize(1);
    }

    private static void standardizeIonicGroups(Molecule mol) {
        block0: for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 7 && a.getCharge() == 1) {
                int radical = a.getRadical();
                if (radical == 2 || radical == 6 || radical == 10) continue;
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolBond b;
                    MolAtom o = a.getLigand(j);
                    if (o.getAtno() != 8 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != -1) continue;
                    LogPTrainingPreProcessor.transformIonic(mol, a, o, b);
                    continue block0;
                }
                continue;
            }
            if (a.getAtno() != 16 || a.getCharge() != 1) continue;
            int sc = 0;
            MolBond b1 = null;
            MolAtom o1 = null;
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b;
                MolAtom o = a.getLigand(j);
                if (o.getAtno() == 8) {
                    b = a.getBond(j);
                    if (b.getType() != 1 || o.getCharge() != -1) continue;
                    b1 = b;
                    o1 = o;
                    continue;
                }
                if (o.getAtno() != 6 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != 0) continue;
                ++sc;
            }
            if (b1 == null || sc < 2) continue;
            LogPTrainingPreProcessor.transformIonic(mol, a, o1, b1);
        }
    }

    private static void transformIonic(Molecule mol, MolAtom a1, MolAtom a2, MolBond b) {
        MolAtom a = a1.getCharge() > 0 ? a1 : a2;
        int type = 2;
        if (a.getImplicitHcount() > 0) {
            type = 1;
        } else {
            for (int i = a.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = a.getLigand(i);
                if (!ligand.isImplicitizableH(0)) continue;
                mol.removeAtom(ligand);
                type = 1;
                break;
            }
        }
        b.setType(type);
        a1.setCharge(0);
        a2.setCharge(0);
        a1.valenceCheck();
        a2.valenceCheck();
    }
}

