/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.logp.LogPDefaultModel;
import chemaxon.calculations.training.logp.LogPUtil;
import chemaxon.struc.Molecule;
import java.util.List;

public class LogPUserModel
extends LogPDefaultModel {
    public static Descriptor[] descriptors = new Descriptor[300];
    private static final int HBondDescriptor = 140;
    private static final int[] zwitterIonDescriptors = new int[]{141, 142, 143, 144, 145, 146, 147, 148};

    @Override
    protected double setDescriptor(int atomIndex, double[] descriptor) {
        double desc = super.setDescriptor(atomIndex, descriptor);
        if (desc > -1.0 && descriptors[(int)desc] == null) {
            LogPUserModel.descriptors[(int)desc] = new Descriptor(atomIndex, this.mol);
        }
        return desc;
    }

    @Override
    public double[] getDescriptors(Molecule data, boolean forceData, Ionizer ionizer) {
        double[] descriptors = super.getDescriptors(data, forceData, ionizer);
        if (descriptors.length > 0) {
            this.setStructuraldescriptors(descriptors, this.getMolecule(data));
        }
        return descriptors;
    }

    @Override
    protected int getNPlusR4NitrogenID(int atom, List<Integer> atomContributions) {
        boolean isUnkown = this.UNKNOWN;
        int id = super.getNPlusR4NitrogenID(atom, atomContributions);
        if (this.isCharged(this.actualAtom) && !isUnkown) {
            this.UNKNOWN = false;
        }
        return id;
    }

    @Override
    protected int getChargedNPlusR4NitrogenID() {
        switch (this.fragmentId) {
            case 9: {
                return 101;
            }
        }
        return super.getChargedNPlusR4NitrogenID();
    }

    @Override
    protected int getSP3NitrogenID(int atom, List<Integer> atomContributions) {
        boolean isUnkown = this.UNKNOWN;
        int id = super.getSP3NitrogenID(atom, atomContributions);
        if (this.isCharged(this.actualAtom) && !isUnkown) {
            this.UNKNOWN = false;
        }
        return id;
    }

    @Override
    protected int get1OxigenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(atom)) {
            switch (this.fragmentId) {
                case 1: {
                    atomContributions.add(175);
                    return 175;
                }
                case 50: {
                    atomContributions.add(176);
                    return 176;
                }
            }
        }
        return super.get1OxigenID(atom, atomContributions);
    }

    @Override
    protected int get2OxigenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(atom)) {
            switch (this.fragmentId) {
                case 217: 
                case 222: {
                    atomContributions.add(174);
                    return 174;
                }
            }
        }
        return super.get2OxigenID(atom, atomContributions);
    }

    @Override
    protected int get3OxigenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(atom)) {
            switch (this.fragmentId) {
                case 3: {
                    atomContributions.add(172);
                    return 172;
                }
                case 8: 
                case 13: 
                case 18: {
                    atomContributions.add(173);
                    return 173;
                }
            }
        }
        return super.get3OxigenID(atom, atomContributions);
    }

    @Override
    protected boolean isZwitterion(Molecule mol) {
        return false;
    }

    private void setStructuraldescriptors(double[] descriptors, Molecule molecule) {
        descriptors[140] = this.ionizer.getlogPHBondCount();
        this.setZwitterIonDescriptors(molecule, descriptors);
        if (descriptors[140] != 0.0) {
            LogPUserModel.descriptors[140] = new Descriptor(-1, molecule);
        }
    }

    private void setZwitterIonDescriptors(Molecule molecule, double[] descriptors) {
        LogPUtil.IonicDescriptor ions = new LogPUtil.IonicDescriptor(molecule, this.ionizer);
        int descriptorIndex = -1;
        int anionCount = 0;
        int kationCount = 0;
        if (ions.aliKation > 0 && ions.aliAnion_CO > 0) {
            descriptorIndex = 0;
            anionCount = ions.aliAnion_CO;
            kationCount = ions.aliKation;
        } else if (ions.aliAnion_CO > 0 && ions.araKation > 0) {
            descriptorIndex = 1;
            anionCount = ions.aliAnion_CO;
            kationCount = ions.araKation;
        } else if (ions.aliKation > 0 && ions.aliAnion_O > 0) {
            descriptorIndex = 2;
            anionCount = ions.aliAnion_O;
            kationCount = ions.aliKation;
        } else if (ions.araKation > 0 && ions.aliAnion_XOOO > 0) {
            descriptorIndex = 3;
            anionCount = ions.aliAnion_XOOO;
            kationCount = ions.araKation;
        } else if (ions.aliKation > 0 && ions.aliAnion_XOOO > 0) {
            descriptorIndex = 4;
            anionCount = ions.aliAnion_XOOO;
            kationCount = ions.aliKation;
        } else if (ions.aliKation > 0 && ions.aliAnion_S > 0) {
            descriptorIndex = 5;
            anionCount = ions.aliAnion_S;
            kationCount = ions.aliKation;
        } else if (ions.aliKation > 0 && ions.aliAnion_N > 0) {
            descriptorIndex = 6;
            anionCount = ions.aliAnion_N;
            kationCount = ions.aliKation;
        } else if (ions.aliKation > 0 && ions.aliAnion_C > 0) {
            descriptorIndex = 7;
            anionCount = ions.aliAnion_C;
            kationCount = ions.aliKation;
        }
        if (descriptorIndex > -1) {
            descriptors[LogPUserModel.zwitterIonDescriptors[descriptorIndex]] = Math.min(anionCount, kationCount);
            LogPUserModel.descriptors[LogPUserModel.zwitterIonDescriptors[descriptorIndex]] = new Descriptor(-1, molecule);
        }
    }

    public static class Descriptor {
        public int atomIndex;
        public Molecule molecule;

        public Descriptor(int index, Molecule mol) {
            this.atomIndex = index;
            this.molecule = mol;
        }
    }
}

