/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class LogPUtil {
    public static int[] getAtomID(Molecule molecule, int atomIndex) {
        MolAtom atom = molecule.getAtom(atomIndex);
        int hybridState = LogPUtil.getHybridState(atom);
        int fragmentId = 0;
        int hCounter = atom.getImplicitHcount();
        int[] cTabForAtom = molecule.getCtab()[atomIndex];
        for (int i = 0; i < cTabForAtom.length; ++i) {
            fragmentId += LogPUtil.getAtomTypeCounter(atom, molecule.getAtom(cTabForAtom[i]));
        }
        return new int[]{hybridState, fragmentId + hCounter};
    }

    private static int getHybridState(MolAtom atom) {
        return atom.getImplicitHcount() + atom.getBondCount();
    }

    private static int getAtomTypeCounter(MolAtom atom1, MolAtom atom2) {
        int pc = atom2.getAtno();
        int bondorder = atom1.getBondTo(atom2).getType();
        int rCounter = 0;
        int xCounter = 0;
        int dbCCounter = 0;
        int arRCounter = 0;
        int arXCounter = 0;
        int arSingleBond = 0;
        int Ar = 0;
        int xTripBond = 0;
        if (pc == 6) {
            if (bondorder == 4) {
                ++arRCounter;
            } else if (bondorder == 2) {
                ++dbCCounter;
            } else if (atom2.hasAromaticBond()) {
                ++Ar;
            } else {
                ++rCounter;
            }
        } else if (bondorder == 4) {
            int hybridState = LogPUtil.getHybridState(atom2);
            if (hybridState == 3) {
                ++arSingleBond;
            } else if (hybridState == 2) {
                double charge = atom2.getCharge();
                if (charge == 0.0) {
                    if (pc == 7) {
                        ++arXCounter;
                    } else {
                        ++arSingleBond;
                    }
                } else if (charge == -1.0) {
                    ++arSingleBond;
                }
            } else {
                ++arXCounter;
            }
        } else if (bondorder == 3) {
            ++xTripBond;
        } else {
            ++xCounter;
        }
        int fragmentId = rCounter * 6 + xCounter * 36 + dbCCounter * 216 + arRCounter * 1296 + arXCounter * 7776 + arSingleBond * 46656 + Ar * 50 + xTripBond * 150;
        return fragmentId;
    }

    protected static final class IonicDescriptor {
        int araAnion_N = 0;
        int aliAnion_N = 0;
        int araKation = 0;
        int aliKation = 0;
        int aliAnion_CO = 0;
        int aliAnion_O = 0;
        int aliAnion_S = 0;
        int aliAnion_C = 0;
        int aliAnion_XOOO = 0;

        protected IonicDescriptor(Molecule molecule, Ionizer ionizer) {
            this.processMolecule(molecule, ionizer);
        }

        private void processMolecule(Molecule molecule, Ionizer ionizer) {
            for (int i = 0; i < molecule.getAtomCount(); ++i) {
                this.processAtom(molecule, i, ionizer);
            }
        }

        private void processAtom(Molecule molecule, int atomIndex, Ionizer ionizer) {
            int[] ids = LogPUtil.getAtomID(molecule, atomIndex);
            int pc = molecule.getAtom(atomIndex).getAtno();
            int charge = molecule.getAtom(atomIndex).getCharge();
            if (pc == 7 && (ids[0] == 1 || ids[0] == 2) && charge != 0) {
                switch (ids[1]) {
                    case 2592: {
                        ++this.araAnion_N;
                        break;
                    }
                    case 12: {
                        ++this.aliAnion_N;
                        break;
                    }
                    case 200: {
                        ++this.aliKation;
                        break;
                    }
                    case 36: 
                    case 72: 
                    case 156: {
                        break;
                    }
                    default: {
                        if (ionizer.getCarboxy(atomIndex) == 400) {
                            ++this.aliKation;
                            break;
                        }
                        ++this.aliAnion_N;
                    }
                }
            }
            if (pc == 7 && charge != 0 && ids[0] == 3) {
                switch (ids[1]) {
                    case 2593: 
                    case 2598: 
                    case 9078: 
                    case 9108: {
                        ++this.araKation;
                        break;
                    }
                    case 223: 
                    case 228: 
                    case 267: {
                        ++this.aliKation;
                        break;
                    }
                    default: {
                        if (ionizer.getCarboxy(atomIndex) == 1200) break;
                        ++this.aliKation;
                    }
                }
            }
            if (pc == 7 && charge != 0 && ids[0] == 4) {
                ++this.aliKation;
            }
            if (pc == 8 && charge != 0 && ids[0] == 1) {
                switch (ids[1]) {
                    case 6: {
                        ++this.aliAnion_CO;
                        break;
                    }
                    case 50: {
                        ++this.aliAnion_O;
                        break;
                    }
                    case 36: {
                        ++this.aliAnion_XOOO;
                        break;
                    }
                    default: {
                        ++this.aliAnion_O;
                    }
                }
            }
            if (pc == 16 && charge != 0) {
                ++this.aliAnion_S;
            }
            if (pc == 6 && charge != 0 && ids[0] == 3) {
                ++this.aliAnion_C;
            }
        }
    }
}

