/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.training.logp.LogPTrainingModel;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class LogPVGModel
extends LogPTrainingModel {
    @Override
    public double[] getDescriptors(Molecule data, boolean forceData) {
        return super.getDescriptors(data, forceData);
    }

    @Override
    protected boolean validate(int[] aInc) {
        return true;
    }

    @Override
    protected List<Integer> getAlphaKetoHeteroAtoms() {
        ArrayList<Integer> vec = new ArrayList<Integer>();
        vec.add(8);
        vec.add(16);
        return vec;
    }

    @Override
    protected int getSp3CarbonID(int atom, List<Integer> atomContributions) {
        this.structInc = true;
        return super.getSp3CarbonID(atom, atomContributions);
    }

    @Override
    protected int getSp2CarbonID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            this.UNKNOWN = true;
            atomContributions.add(this.fragmentId == 18 ? 140 : 141);
            return atomContributions.get(0);
        }
        super.getSp2CarbonID(atom, atomContributions);
        switch (this.fragmentId) {
            case 267: {
                atomContributions.add(158);
                break;
            }
            case 272: 
            case 316: {
                atomContributions.add(184);
                break;
            }
            case 253: {
                if (this.isSemiAraAtom(this.actualAtom)) break;
                atomContributions.add(0, 159);
                break;
            }
            case 258: {
                if (!this.isSemiAraAtom(this.actualAtom)) break;
                atomContributions.clear();
                atomContributions.add(26);
                break;
            }
            case 49248: {
                atomContributions.add(157);
                break;
            }
            case 87: {
                atomContributions.add(161);
                break;
            }
            case 48: {
                if (!this.isSemiAraAtom(this.actualAtom)) break;
                atomContributions.clear();
                atomContributions.add(28);
                break;
            }
            case 122: {
                if (!this.isAraEstherInc(this.actualAtom)) break;
                atomContributions.add(182);
                break;
            }
            case 78: {
                if (!this.isEtenEstherInc(this.actualAtom)) break;
                atomContributions.add(183);
                break;
            }
            case 47958: {
                if (!this.isAraS(this.actualAtom)) break;
                atomContributions.clear();
                atomContributions.add(28);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    @Override
    protected int getSpCarbonID(int atom, List<Integer> atomContributions) {
        super.getSpCarbonID(atom, atomContributions);
        switch (this.fragmentId) {
            case 186: {
                atomContributions.add(174);
                break;
            }
            case 200: {
                atomContributions.add(164);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    @Override
    protected int getQuaternerNitrogenID(int atom, List<Integer> atomContributions) {
        this.UNKNOWN = true;
        if (this.fragmentId != 60) {
            atomContributions.add(142);
            return 142;
        }
        int ester = this.getEsterAtomInCarbamoylSalt(this.actualAtom);
        if (ester == -1) {
            atomContributions.add(142);
            return 142;
        }
        switch (this.ionizer.getGroupType(ester)) {
            case 19: {
                atomContributions.add(142);
                break;
            }
            case 14: {
                atomContributions.add(144);
                break;
            }
            case 20: {
                atomContributions.add(144);
                break;
            }
            default: {
                if (!atomContributions.isEmpty()) break;
                atomContributions.add(145);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    private int getEsterAtomInCarbamoylSalt(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            if (this.ionizer.getCarboxy(this.cHtab[a][i]) != 2) continue;
            return this.cHtab[a][i];
        }
        return -1;
    }

    @Override
    protected int getNPlusR4NitrogenID(int atom, List<Integer> atomContributions) {
        this.UNKNOWN = true;
        if (this.isCharged(this.actualAtom)) {
            int descIndex = -1;
            switch (this.fragmentId) {
                case 24: {
                    atomContributions.add(197);
                    return 197;
                }
                case 68: {
                    atomContributions.add(198);
                    return 198;
                }
                case 19: {
                    descIndex = 146;
                    break;
                }
                case 14: {
                    descIndex = 147;
                    break;
                }
                case 53: {
                    descIndex = 148;
                    break;
                }
                case 58: {
                    descIndex = 149;
                    break;
                }
                case 63: {
                    descIndex = 150;
                    break;
                }
                case 88: {
                    descIndex = 151;
                    break;
                }
                default: {
                    descIndex = 151;
                }
            }
            atomContributions.add(descIndex);
            return descIndex;
        }
        super.getNPlusR4NitrogenID(atom, atomContributions);
        switch (this.fragmentId) {
            case 54: {
                if (this.ionizer.getCarboxy(this.actualAtom) == 1200) {
                    atomContributions.add(152);
                    return 76;
                }
                atomContributions.add(153);
                break;
            }
            case 2634: {
                atomContributions.add(154);
                break;
            }
            default: {
                if (this.ionizer.getCarboxy(this.actualAtom) != 1) {
                    atomContributions.add(187);
                    break;
                }
                atomContributions.add(76);
                atomContributions.add(152);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    @Override
    protected int getChargedSP3Nitrogen() {
        int descIndex = -1;
        switch (this.fragmentId) {
            case 2593: {
                descIndex = 155;
                break;
            }
            case 9078: {
                descIndex = 156;
                break;
            }
            case 9108: {
                descIndex = 155;
                break;
            }
            case 223: {
                if (this.isAmidineorGuanidine(this.actualAtom)) {
                    return 160;
                }
                descIndex = 156;
                break;
            }
            case 228: {
                descIndex = this.isAmidineorGuanidine(this.actualAtom) ? 196 : 146;
                break;
            }
            case 2598: {
                descIndex = 199;
                break;
            }
            case 267: {
                descIndex = 155;
                break;
            }
            default: {
                descIndex = this.ionizer.getCarboxy(this.actualAtom) == 1200 ? 191 : (this.isAmidineorGuanidine(this.actualAtom) ? 160 : 146);
            }
        }
        return descIndex;
    }

    @Override
    protected int getSP3NitrogenID(int atom, List<Integer> atomContributions) {
        int descIndex = -1;
        if (this.isCharged(this.actualAtom)) {
            descIndex = this.getChargedSP3Nitrogen();
            boolean bl = this.UNKNOWN = descIndex != 196 && descIndex != 199;
            if (descIndex > -1) {
                atomContributions.add(descIndex);
            }
            return descIndex;
        }
        super.getSP3NitrogenID(atom, atomContributions);
        if (this.isAlphaKeto(this.actualAtom)) {
            if (this.fragmentId != 57 && this.ionizer.getPolarGroupProperty(this.actualAtom) != 420) {
                atomContributions.add(162);
            }
            return atomContributions.get(0);
        }
        switch (this.fragmentId) {
            case 48: {
                atomContributions.add(0, 162);
                break;
            }
            case 62: {
                if (this.isSemiAraAtom(this.actualAtom)) break;
                atomContributions.add(0, 163);
                break;
            }
            case 87: {
                if (this.isHydrazine(this.actualAtom)) {
                    atomContributions.add(0, 176);
                    break;
                }
                atomContributions.add(0, 177);
                break;
            }
            case 9122: {
                atomContributions.add(0, 175);
                break;
            }
            case 9078: {
                atomContributions.add(0, 175);
                break;
            }
            case 78: {
                if (this.ionizer.getCarboxy(this.actualAtom) == 100) break;
                atomContributions.clear();
                atomContributions.add(191);
                break;
            }
            case 122: {
                if (this.ionizer.getCarboxy(this.actualAtom) == 1300) break;
                atomContributions.clear();
                atomContributions.add(191);
            }
        }
        return atomContributions.isEmpty() ? -1 : atomContributions.get(0);
    }

    private boolean isAmidineorGuanidine(int atomIndex) {
        return this.ionizer.getpKaBasicType(atomIndex, 0) == 3;
    }

    private boolean isHydrazine(int nitrogen) {
        for (int i = 0; i < this.cHtab[nitrogen].length; ++i) {
            int pc;
            int nb = this.cHtab[nitrogen][i];
            if (nb >= this.atomArray.length || (pc = this.atomArray[nb].getAtno()) != 7) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getSP2NitrogenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            atomContributions.add(this.getChargedSp2NitrogenId());
            return atomContributions.get(0);
        }
        super.getSP2NitrogenID(atom, atomContributions);
        if (this.isAlphaKeto(this.actualAtom)) {
            atomContributions.add(162);
            return 72;
        }
        switch (this.fragmentId) {
            case 9072: {
                if (!this.isArAza(this.actualAtom)) break;
                atomContributions.add(166);
                break;
            }
            case 150: {
                atomContributions.add(173);
                break;
            }
            case 72: 
            case 86: {
                atomContributions.add(167);
                break;
            }
            case 252: {
                if (!this.isDiHydrazono(this.actualAtom)) break;
                atomContributions.add(172);
                break;
            }
            case 266: {
                atomContributions.remove(0);
                if (this.isSemiAraAtom(this.actualAtom)) {
                    atomContributions.add(75);
                    break;
                }
                int descind = this.addArAGuanidineInc(this.actualAtom);
                if (descind > -1) {
                    atomContributions.add(descind);
                }
                atomContributions.add(78);
                atomContributions.add(167);
            }
        }
        return atomContributions.isEmpty() ? -1 : atomContributions.get(0);
    }

    private int getChargedSp2NitrogenId() {
        switch (this.fragmentId) {
            case 2592: {
                return 277;
            }
            case 12: {
                return this.ionizer.getPolarGroupProperty(this.actualAtom) == 410 ? 278 : 279;
            }
            case 200: {
                return 280;
            }
            case 156: {
                return 281;
            }
            case 72: {
                return 281;
            }
            case 36: {
                return 282;
            }
        }
        return this.ionizer.getCarboxy(this.actualAtom) == 400 ? 282 : 279;
    }

    private boolean isArAza(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int pc;
            int nb = this.cHtab[atom][i];
            if (nb > this.atomArray.length || (pc = this.atomArray[nb].getAtno()) != 7) continue;
            return true;
        }
        return false;
    }

    private boolean isDiHydrazono(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int bondOrder;
            int pc;
            int nb = this.cHtab[atom][i];
            if (nb > this.atomArray.length || (pc = this.atomArray[nb].getAtno()) != 7 || (bondOrder = this.mol.getBond(this.bHtab[atom][nb]).getType()) != 1) continue;
            int charge = this.atomArray[nb].getCharge();
            int impH = this.atomArray[nb].getImplicitHcount();
            if (this.cHtab[nb].length + impH != 2 || charge != 0) continue;
            return true;
        }
        return false;
    }

    private int addArAGuanidineInc(int atomIndex) {
        if (this.ionizer.getpKaBasicType(atomIndex, 0) == 3) {
            int t = this.ionizer.getpKaBasicType(atomIndex, 1);
            if (t == 1 || t == 12 || t == 14) {
                if (this.ionizer.isInRing(this.ionizer.getpKaBasicType(atomIndex, 2))) {
                    return 143;
                }
                return 171;
            }
            return 180;
        }
        return -1;
    }

    @Override
    protected int get1OxigenID(int atom, List<Integer> atomContributions) {
        super.get1OxigenID(atom, atomContributions);
        if (this.isCharged(this.actualAtom)) {
            switch (this.fragmentId) {
                case 6: {
                    atomContributions.clear();
                    atomContributions.add(this.isArOHVinil(this.actualAtom) ? 186 : 187);
                    break;
                }
                case 50: {
                    atomContributions.clear();
                    atomContributions.add(this.isHeteroRing(this.actualAtom) ? 188 : 189);
                    break;
                }
                case 36: {
                    break;
                }
                default: {
                    if (!atomContributions.isEmpty() && atomContributions.get(0) != 0) break;
                    atomContributions.clear();
                    atomContributions.add(151);
                    this.UNKNOWN = true;
                    return -1;
                }
            }
        }
        return atomContributions.isEmpty() ? -1 : atomContributions.get(0);
    }

    @Override
    protected int get2OxigenID(int atom, List<Integer> atomContributions) {
        super.get2OxigenID(atom, atomContributions);
        switch (this.fragmentId) {
            case 7: {
                if (this.alphaKeto || this.isEnol(this.actualAtom)) break;
                atomContributions.add(180);
                break;
            }
            case 37: {
                atomContributions.add(168);
                break;
            }
            case 12: {
                if (this.isAlphaKeto(this.actualAtom)) break;
                atomContributions.add(59);
                atomContributions.remove((Object)60);
                break;
            }
            case 56: {
                if (this.ionizer.getPolarGroupProperty(this.actualAtom) != 412) break;
                atomContributions.add(178);
                break;
            }
            default: {
                if (!atomContributions.isEmpty() || !this.isCharged(this.actualAtom)) break;
                this.UNKNOWN = true;
                atomContributions.add(284);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    @Override
    protected int get3OxigenID(int atom, List<Integer> atomContributions) {
        atomContributions.add(179);
        return super.get3OxigenID(atom, atomContributions);
    }

    @Override
    protected int getSulfurID(int atom, List<Integer> atomContributions) {
        int value = super.getSulfurID(atom, atomContributions);
        if (this.isCharged(this.actualAtom)) {
            return value;
        }
        if (this.isIsothioCyanate(this.actualAtom)) {
            atomContributions.clear();
            atomContributions.add(169);
            return 169;
        }
        switch (this.fragmentId) {
            case 100: {
                atomContributions.add(165);
                break;
            }
            case 136: {
                atomContributions.add(185);
                break;
            }
            case 9072: {
                atomContributions.add(115);
                break;
            }
            default: {
                if (!atomContributions.isEmpty()) break;
                atomContributions.add(107);
            }
        }
        return atomContributions.get(0);
    }

    private boolean isIsothioCyanate(int atom) {
        int impH = this.atomArray[atom].getImplicitHcount();
        if (this.cHtab[atom].length == 1 && impH == 0) {
            int pc;
            int nb = this.cHtab[atom][0];
            if (nb > this.atomArray.length) {
                return false;
            }
            impH = this.atomArray[nb].getImplicitHcount();
            if (this.cHtab[nb].length == 2 && impH == 0 && (pc = this.atomArray[nb].getAtno()) == 6) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getMinoricAtomID(int ai, List<Integer> atomContributions) {
        super.getMinoricAtomID(ai, atomContributions);
        int pc = this.atomArray[ai].getAtno();
        switch (pc) {
            case 19: {
                int kaliumId = this.getKaliumId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(kaliumId);
                return kaliumId;
            }
            case 80: {
                int HgId = this.getHgId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(HgId);
                return HgId;
            }
            case 82: {
                int PbId = this.getPbId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(PbId);
                return PbId;
            }
            case 11: {
                int NaId = this.getNaId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(NaId);
                return NaId;
            }
            case 14: {
                int SiId = this.getSiId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(SiId);
                return SiId;
            }
            case 5: {
                int BId = this.getBId(this.fragmentId, ai);
                atomContributions.clear();
                atomContributions.add(BId);
                return BId;
            }
            case 29: {
                int CuId = this.getCuId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(CuId);
                return CuId;
            }
            case 51: {
                int SbId = this.getSbId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(SbId);
                return SbId;
            }
            case 13: {
                int AlId = this.getAlId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(AlId);
                return AlId;
            }
            case 12: {
                int MgId = this.getMgId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(MgId);
                return MgId;
            }
            case 83: {
                int BiId = this.getBiId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(BiId);
                return BiId;
            }
            case 48: {
                int CdId = this.getCdId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(CdId);
                return CdId;
            }
            case 26: {
                int FeId = this.getFeId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(FeId);
                return FeId;
            }
            case 47: {
                int AgId = this.getAgId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(AgId);
                return AgId;
            }
            case 33: {
                int AsId = this.getAsId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(AsId);
                return AsId;
            }
            case 27: {
                int CoId = this.getCoId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(CoId);
                return CoId;
            }
            case 20: {
                int CaId = this.getCaId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(CaId);
                return CaId;
            }
            case 81: {
                int TlId = this.getTlId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(TlId);
                return TlId;
            }
            case 79: {
                int AuId = this.getAuId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(AuId);
                return AuId;
            }
            case 78: {
                int PtId = this.getPtId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(PtId);
                return PtId;
            }
            case 56: {
                int BaId = this.getBaId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(BaId);
                return BaId;
            }
            case 38: {
                int SrId = this.getSrId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(SrId);
                return SrId;
            }
            case 30: {
                int ZnId = this.getZnId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(ZnId);
                return ZnId;
            }
            case 28: {
                int NiId = this.getNiId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(NiId);
                return NiId;
            }
            case 25: {
                int MnId = this.getMnId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(MnId);
                return MnId;
            }
            case 24: {
                int CrId = this.getCrId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(CrId);
                return CrId;
            }
            case 50: {
                int SnId = this.getSnId(this.fragmentId);
                atomContributions.clear();
                atomContributions.add(SnId);
                return SnId;
            }
            case 15: {
                if (atomContributions.isEmpty()) {
                    atomContributions.add(192);
                } else if (this.fragmentId == 18) {
                    atomContributions.clear();
                    atomContributions.add(117);
                }
                return atomContributions.get(0);
            }
        }
        this.UNKNOWN = true;
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    @Override
    protected boolean skipPhosphor() {
        return false;
    }

    private int getKaliumId(int fragmentId) {
        switch (fragmentId) {
            case 36: {
                return this.isOxigenConnect(this.actualAtom) ? 215 : 216;
            }
        }
        return 215;
    }

    private int getHgId(int fragmentId) {
        switch (fragmentId) {
            case 86: {
                return 208;
            }
            case 42: {
                return this.isAraConnect(this.actualAtom) ? 208 : 209;
            }
            case 6: {
                return 210;
            }
            case 12: {
                return 211;
            }
            case 56: {
                return 212;
            }
            case 100: {
                return 213;
            }
            case 0: {
                return 214;
            }
        }
        return 208;
    }

    private int getPbId(int fragmentId) {
        switch (fragmentId) {
            case 86: {
                return 204;
            }
            case 144: {
                return 205;
            }
            case 74: {
                return 206;
            }
        }
        return 207;
    }

    private int getNaId(int fragmentId) {
        switch (fragmentId) {
            case 36: {
                return this.isOxigenConnect(this.actualAtom) ? 200 : 201;
            }
            case 0: {
                return 202;
            }
        }
        return 203;
    }

    private int getSiId(int fragmentId) {
        switch (fragmentId) {
            case 114: 
            case 158: {
                return 131;
            }
            case 74: 
            case 84: 
            case 123: 
            case 172: 
            case 186: {
                return 132;
            }
            case 24: 
            case 54: 
            case 68: 
            case 88: 
            case 112: 
            case 142: {
                return 133;
            }
            case 144: {
                return 134;
            }
            case 109: {
                return 135;
            }
        }
        return 136;
    }

    private int getBId(int fragmentId, int atomIndex) {
        int valencState = this.ionizer.getValenceState(atomIndex);
        switch (valencState) {
            case 3: {
                switch (fragmentId) {
                    case 122: {
                        return 119;
                    }
                    case 108: {
                        return 126;
                    }
                    case 48: {
                        return 127;
                    }
                    case 78: {
                        return 126;
                    }
                }
                return 126;
            }
            case 5: {
                switch (fragmentId) {
                    case 180: {
                        return 128;
                    }
                }
                return 129;
            }
            case 4: {
                switch (fragmentId) {
                    case 144: {
                        return 128;
                    }
                }
                return 129;
            }
            case 9: {
                return 130;
            }
        }
        return 118;
    }

    private int getCuId(int fragmentId) {
        switch (fragmentId) {
            case 12: 
            case 56: 
            case 100: {
                return 121;
            }
            case 72: {
                return this.ionizer.isInRing(this.actualAtom) ? 122 : 123;
            }
            case 42: 
            case 86: {
                return 124;
            }
            case 36: {
                return 123;
            }
        }
        return 125;
    }

    private int getSbId(int fragmentId) {
        switch (fragmentId) {
            case 18: 
            case 122: {
                return 217;
            }
        }
        return 217;
    }

    private int getAlId(int fragmentId) {
        switch (fragmentId) {
            case 48: {
                return 218;
            }
            case 108: {
                return this.isHalogenConnected(this.actualAtom) ? 219 : 220;
            }
            case 78: 
            case 122: {
                return 221;
            }
            case 150: {
                return 222;
            }
        }
        return 223;
    }

    private boolean isHalogenConnected(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            if (this.ionizer.getCarboxy(this.cHtab[a][i]) != 1400) continue;
            return true;
        }
        return false;
    }

    private int getMgId(int fragmentId) {
        switch (fragmentId) {
            case 42: {
                return 224;
            }
            case 86: {
                return 225;
            }
            case 72: {
                return this.ionizer.isInRing(this.actualAtom) ? 226 : 227;
            }
            case 12: 
            case 100: {
                return 228;
            }
            case 0: {
                return 229;
            }
        }
        return 225;
    }

    private int getBiId(int fragmentId) {
        switch (fragmentId) {
            case 86: 
            case 108: {
                return 230;
            }
        }
        return 230;
    }

    private int getCdId(int fragmentId) {
        switch (fragmentId) {
            case 12: {
                return 231;
            }
            case 42: 
            case 72: {
                return this.ionizer.isInRing(this.actualAtom) ? 232 : 233;
            }
            case 86: {
                return 234;
            }
            case 0: {
                return 235;
            }
        }
        return 236;
    }

    private int getFeId(int fragmentId) {
        switch (fragmentId) {
            case 86: {
                return 237;
            }
            case 0: {
                return 238;
            }
        }
        return 237;
    }

    private int getAgId(int fragmentId) {
        switch (fragmentId) {
            case 86: {
                return 239;
            }
            case 36: {
                return 240;
            }
        }
        return 239;
    }

    private int getAsId(int fragmentId) {
        switch (fragmentId) {
            case 114: 
            case 136: {
                return 241;
            }
            case 84: {
                return 242;
            }
            case 78: 
            case 122: {
                return 243;
            }
            case 86: {
                return 244;
            }
            case 48: {
                return 245;
            }
            case 108: {
                return 246;
            }
        }
        return 246;
    }

    private int getCoId(int fragmentId) {
        switch (fragmentId) {
            case 72: {
                return 247;
            }
            case 108: {
                return 248;
            }
            case 0: {
                return 249;
            }
        }
        return 247;
    }

    private int getCaId(int fragmentId) {
        switch (fragmentId) {
            case 12: {
                return 250;
            }
            case 0: {
                return 251;
            }
        }
        return 250;
    }

    private int getTlId(int fragmentId) {
        switch (fragmentId) {
            case 86: {
                return 252;
            }
            case 144: {
                return 253;
            }
            case 36: {
                return 254;
            }
        }
        return 252;
    }

    private int getAuId(int fragmentId) {
        return this.getTlId(fragmentId);
    }

    private int getPtId(int fragmentId) {
        return this.getTlId(fragmentId);
    }

    private int getBaId(int fragmentId) {
        return 255;
    }

    private int getSrId(int fragmentId) {
        return 256;
    }

    private int getZnId(int fragmentId) {
        switch (fragmentId) {
            case 12: 
            case 56: 
            case 100: {
                return 257;
            }
            case 72: {
                return 258;
            }
            case 42: 
            case 86: {
                return 259;
            }
        }
        return 260;
    }

    private int getNiId(int fragmentId) {
        switch (fragmentId) {
            case 12: 
            case 56: 
            case 100: {
                return 257;
            }
            case 72: {
                return 258;
            }
            case 42: 
            case 86: {
                return 259;
            }
            case 36: {
                return 258;
            }
        }
        return 260;
    }

    private int getMnId(int fragmentId) {
        switch (fragmentId) {
            case 12: 
            case 56: 
            case 100: {
                return 257;
            }
            case 72: {
                return 261;
            }
            case 42: 
            case 86: {
                return 262;
            }
            case 36: {
                return 261;
            }
            case 108: 
            case 114: 
            case 144: 
            case 158: {
                return 258;
            }
        }
        return 283;
    }

    private int getCrId(int fragmentId) {
        return this.getMnId(fragmentId);
    }

    private int getSnId(int fragmentId) {
        int SSnInc = this.getSulfurSnCount(this.actualAtom);
        switch (fragmentId) {
            case 186: {
                this.SulfurSnInc = SSnInc;
                return 264;
            }
            case 156: {
                return 265;
            }
            case 112: {
                return 266;
            }
            case 114: {
                this.SulfurSnInc = SSnInc;
                return 267;
            }
            case 158: {
                this.SulfurSnInc = SSnInc;
                return 268;
            }
            case 172: {
                this.SulfurSnInc = SSnInc;
                return 268;
            }
            case 74: {
                this.SulfurSnInc = SSnInc;
                return 269;
            }
            case 84: {
                this.SulfurSnInc = SSnInc;
                return 270;
            }
            case 24: {
                return 271;
            }
            case 14: {
                return 272;
            }
            case 54: {
                this.SulfurSnInc = SSnInc;
                return 273;
            }
            case 200: {
                return 274;
            }
            case 144: {
                this.SulfurSnInc = SSnInc;
                return 275;
            }
        }
        this.SulfurSnInc = SSnInc;
        return 276;
    }

    private int getSulfurSnCount(int actualAtom) {
        int scount = 0;
        for (int i = 0; i < this.cHtab[actualAtom].length; ++i) {
            int pc;
            int nb = this.cHtab[actualAtom][i];
            if (nb >= this.atomArray.length || (pc = this.atomArray[nb].getAtno()) != 16) continue;
            ++scount;
        }
        return scount;
    }

    @Override
    protected int getStrucInc(int nb) {
        return this.ionizer.getCarboxy(nb) == 400 ? 1 : 0;
    }

    protected boolean isHeteroRing(int ai) {
        int ri;
        int nb = this.cHtab[ai][0];
        if (nb != -1 && (ri = this.ionizer.findSmallestAraRing(nb)) != -1) {
            for (int i = 0; i < this.ionizer.getAraAtoms()[ri].length; ++i) {
                int ra = this.ionizer.getAraAtoms()[ri][i];
                int protonCount = this.atomArray[ra].getAtno();
                if (protonCount == 6) continue;
                return true;
            }
        }
        return false;
    }
}

