/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.training.ParallelPredictor;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.calculations.training.logp.LogPPredictorImpl;
import chemaxon.struc.Molecule;

public class ParallelLogPPredictor
extends ParallelPredictor<Molecule, SVDTrainingResult>
implements LogPPredictor {
    public ParallelLogPPredictor() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ParallelLogPPredictor(int threads) {
        this(LogPPredictor.MethodType.TRUE, threads);
    }

    public ParallelLogPPredictor(LogPPredictor.MethodType method, int threads) {
        this(ParallelLogPPredictor.createPredictors(method, threads));
    }

    public ParallelLogPPredictor(LogPPredictor[] predictors) {
        super(predictors);
    }

    @Override
    public void setPH(double pH) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            ((LogPPredictor)this.predictors.get(i)).setPH(pH);
        }
    }

    @Override
    public void setWeightOfMethods(double wVG, double wKLOP, double wPHYS, double wUSER) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            ((LogPPredictor)this.predictors.get(i)).setWeightOfMethods(wVG, wKLOP, wPHYS, wUSER);
        }
    }

    @Override
    public void setCloridIonConcentration(double anion) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            ((LogPPredictor)this.predictors.get(i)).setCloridIonConcentration(anion);
        }
    }

    @Override
    public void setNaKIonConcentration(double kation) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            ((LogPPredictor)this.predictors.get(i)).setNaKIonConcentration(kation);
        }
    }

    @Override
    public void setLogPMethod(LogPPredictor.MethodType mtype) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            ((LogPPredictor)this.predictors.get(i)).setLogPMethod(mtype);
        }
    }

    private static LogPPredictor[] createPredictors(LogPPredictor.MethodType type, int threads) {
        LogPPredictor[] predictors = new LogPPredictor[threads];
        for (int i = 0; i < predictors.length; ++i) {
            predictors[i] = new LogPPredictorImpl(type);
        }
        return predictors;
    }

    @Override
    public double[] predictAtomicIncrements(Molecule item) {
        return ((LogPPredictor)this.predictors.get(0)).predictAtomicIncrements(item);
    }

    @Override
    public double[][] predictAtomicIncrements(final Molecule ... item) {
        final double[][] result = new double[item.length][];
        int count = 0;
        while (count < result.length) {
            int i;
            int threadCount = Math.min(this.predictors.size(), result.length - count);
            Thread[] threads = new Thread[threadCount];
            for (i = 0; i < threads.length; ++i) {
                final int innerIndex = i;
                final int outerIndex = count++;
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        result[outerIndex] = ((LogPPredictor)ParallelLogPPredictor.this.predictors.get(innerIndex)).predictAtomicIncrements(item[outerIndex]);
                    }
                });
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public int getThreadCount() {
        return this.predictors.size();
    }

    @Override
    public double[] predictStructuralIncrement(final Molecule ... molecules) {
        final double[] result = new double[molecules.length];
        int count = 0;
        while (count < result.length) {
            int i;
            int threadCount = Math.min(this.predictors.size(), result.length - count);
            Thread[] threads = new Thread[threadCount];
            for (i = 0; i < threads.length; ++i) {
                final int innerIndex = i;
                final int outerIndex = count++;
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        result[outerIndex] = ((LogPPredictorImpl)ParallelLogPPredictor.this.predictors.get(innerIndex)).predictStructuralIncrement(molecules[outerIndex]);
                    }
                });
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public void setOnlyZwitterIonsConvertToMajorForm(boolean onlyZwitterIons) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            if (!(this.predictors.get(i) instanceof LogPPredictor)) continue;
            ((LogPPredictor)this.predictors.get(i)).setOnlyZwitterIonsConvertToMajorForm(onlyZwitterIons);
        }
    }

    @Override
    public double[] predictWithError(Molecule item) {
        return ((LogPPredictor)this.predictors.get(0)).predictWithError(item);
    }
}

