/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pflr;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.Stat;
import chemaxon.calculations.training.pflr.PFLRResult;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.PFLRInterpolation;
import chemaxon.marvin.modelling.util.Stopper;
import java.util.BitSet;

public class PFLR
implements FittingAlgorithm<PFLRResult> {
    private double[][] descriptors;
    private double[] expValues;
    private float prog;
    private int descriptorNum;
    private int verbose;

    public PFLR() {
        this.prog = 0.0f;
        this.descriptorNum = 0;
        this.verbose = 0;
    }

    public PFLR(DescriptorMatrix m, double[] values) {
        this.setDescriptorMatrix(m);
        this.setExperimentalValues(values);
        this.prog = 0.0f;
        this.descriptorNum = m.getColumnCount();
        this.verbose = 0;
    }

    public void setVerboseLevel(int v) {
        this.verbose = v;
    }

    @Override
    public void setDescriptorMatrix(DescriptorMatrix matrix) {
        if (this.descriptors != null) {
            this.descriptorNum = 0;
        }
        this.descriptors = new double[matrix.getRowCount()][];
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i] = new double[matrix.getColumnCount()];
            System.arraycopy(matrix.getRow(i), 0, this.descriptors[i], 0, matrix.getColumnCount());
            this.prog = (float)i / (float)this.descriptors.length;
        }
        if (this.descriptorNum == 0) {
            this.descriptorNum = matrix.getColumnCount();
        }
    }

    @Override
    public void setExperimentalValues(double[] values) {
        this.expValues = new double[values.length];
        System.arraycopy(values, 0, this.expValues, 0, values.length);
    }

    public boolean setDescriptorNum(int descNum) {
        if (this.descriptors == null) {
            this.descriptorNum = descNum;
            return true;
        }
        if (descNum > this.descriptors[0].length || descNum <= 0) {
            return false;
        }
        this.descriptorNum = descNum;
        return true;
    }

    @Override
    public PFLRResult getResult() {
        if (this.descriptorNum == 0 || this.descriptorNum == this.descriptors[0].length) {
            return new PFLRResult(this.descriptors, this.expValues);
        }
        BitSet selected = this.selectDescriptors();
        return new PFLRResult(this.descriptors, this.expValues, selected);
    }

    private BitSet selectDescriptors() {
        double q2 = Double.NEGATIVE_INFINITY;
        double newQ2 = 0.0;
        BitSet bs = new BitSet();
        bs.set(0, this.descriptors[0].length, true);
        Stopper stopper = new Stopper();
        while (bs.cardinality() > this.descriptorNum) {
            double d;
            newQ2 = this.removeOneDescriptor(this.descriptors, this.expValues, bs, q2);
            if (!(q2 + 1.0E-4 < d)) break;
            long time = stopper.stop();
            stopper.start();
            if (this.verbose > 0) {
                System.err.println("Current Q2 is: " + newQ2 + " in " + time / 1000L + " seconds.");
            }
            q2 = newQ2;
        }
        return bs;
    }

    private double removeOneDescriptor(double[][] trainX, double[] trainY, BitSet selected, double prevQ2) {
        int nDepth = Math.min(trainX.length - 1, 14);
        int nDesc = selected.cardinality();
        double[] q2 = new double[trainX[0].length];
        for (int i = 0; i < q2.length; ++i) {
            q2[i] = Double.NEGATIVE_INFINITY;
        }
        int ibestQ2 = 0;
        double bestQ2 = Double.NEGATIVE_INFINITY;
        double[] bestpred = null;
        int i = selected.nextSetBit(0);
        while (i > -1) {
            double[][] closeDVs = new double[nDepth][nDesc - 1];
            double[] c = new double[nDepth];
            double[] pred = new double[trainX.length];
            selected.set(i, false);
            for (int ii = 0; ii < trainX.length; ++ii) {
                double[] ds = trainX[ii];
                int[] indx = new int[14];
                this.findClosestVectors(ds, closeDVs, indx, trainX, true, selected);
                PFLRInterpolation pflr = new PFLRInterpolation(closeDVs);
                pflr.setSelection(selected);
                c = pflr.getCoefficients(ds);
                double y = 0.0;
                for (int j = 0; j < c.length; ++j) {
                    double d = c[j];
                    y += d * trainY[indx[j]];
                }
                pred[ii] = y;
            }
            selected.set(i);
            q2[i] = Stat.pearsonR2(pred, trainY);
            if (i == 0) {
                bestQ2 = q2[ibestQ2];
            }
            if (q2[i] > bestQ2) {
                ibestQ2 = i;
                bestQ2 = q2[i];
                bestpred = pred;
            }
            i = selected.nextSetBit(i + 1);
        }
        if (this.verbose > 2) {
            System.err.println("q2 predicted vaules");
            ErrPrint.errPrint("orig", trainY);
            ErrPrint.errPrint("pred", bestpred);
        }
        if (bestQ2 > prevQ2) {
            selected.set(ibestQ2, false);
        }
        return bestQ2;
    }

    private void findClosestVectors(double[] currentTestX, double[][] closestTrainVectors, int[] closestTrainVectorsIndex, double[][] trainX, boolean LOO, BitSet selected) {
        int i;
        double[] distances = new double[trainX.length];
        int[] indexes = new int[trainX.length];
        for (i = 0; i < trainX.length; ++i) {
            double[] distVect = JLinAlg.vectSubtract(currentTestX, trainX[i], selected);
            distances[i] = JLinAlg.VDot(distVect, distVect, selected);
            indexes[i] = i;
        }
        for (i = 0; i < closestTrainVectors.length + 1; ++i) {
            int index_of_min = i;
            for (int y = i; y < distances.length; ++y) {
                if (!(distances[index_of_min] > distances[y])) continue;
                index_of_min = y;
            }
            double temp = distances[i];
            distances[i] = distances[index_of_min];
            distances[index_of_min] = temp;
            int ttmp = indexes[i];
            indexes[i] = indexes[index_of_min];
            indexes[index_of_min] = ttmp;
        }
        int shift = 0;
        for (int i2 = 0; i2 < closestTrainVectors.length; ++i2) {
            if (LOO && distances[i2] == 0.0) {
                ++shift;
            }
            closestTrainVectors[i2] = trainX[indexes[i2 + shift]];
            closestTrainVectorsIndex[i2] = indexes[i2 + shift];
        }
    }

    @Override
    public float getProgress() {
        return this.prog;
    }
}

