/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pflr;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.Stat;
import chemaxon.calculations.training.pflr.PFLRResult;
import chemaxon.calculations.training.pflr.PFLRUtil;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.linalg.PFLRInterpolation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;

public class PFLRDescriptorSelector
implements FittingAlgorithm<PFLRResult> {
    double[][] descriptorVectors;
    double[] expValues;
    private int verbose = 0;
    private int debug = 0;
    private float prog = 0.0f;
    private FileWriter q2s;
    private File outDir;
    int selectedD = 0;

    public static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public void setDebugLevel(int i) {
        this.debug = i;
    }

    public void setVerbose(int verbose) {
        this.verbose = verbose;
    }

    private void initDebug() {
        if (this.debug > 0) {
            this.outDir = new File(PFLRDescriptorSelector.getDateTime() + "_selection");
            this.outDir.mkdirs();
            File q2r2 = new File(this.outDir, "q2.txt");
            try {
                this.q2s = new FileWriter(q2r2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PFLRDescriptorSelector() {
    }

    public PFLRDescriptorSelector(DescriptorMatrix matrix, double[] values) {
        this.setDescriptorMatrix(matrix);
        this.setExperimentalValues(values);
    }

    private BitSet selectDescriptors() {
        int selectedDescriptor;
        BitSet bs = new BitSet();
        bs.set(0, this.descriptorVectors[0].length, true);
        double[] q2_temparray = new double[this.descriptorVectors[0].length];
        double[] pred_temparray = new double[this.descriptorVectors.length];
        double[] bestPredictedValues = new double[this.descriptorVectors.length];
        double lastBestq2 = Double.NEGATIVE_INFINITY;
        while (lastBestq2 < q2_temparray[selectedDescriptor = this.selectOneDescriptor(bs, q2_temparray, pred_temparray, bestPredictedValues)]) {
            bs.set(selectedDescriptor, false);
            lastBestq2 = q2_temparray[selectedDescriptor];
        }
        return bs;
    }

    private PFLRResult[] selectDescriptors(int numberOfDescriptors) {
        BitSet b;
        PFLRResult[] result = new PFLRResult[this.descriptorVectors[0].length - numberOfDescriptors + 1];
        BitSet bs = new BitSet();
        bs.set(0, this.descriptorVectors[0].length, true);
        double[] q2_temparray = new double[this.descriptorVectors[0].length];
        double[] pred_temparray = new double[this.descriptorVectors.length];
        double[] bestPredictedValues = new double[this.descriptorVectors.length];
        int i = 0;
        while (bs.cardinality() > numberOfDescriptors) {
            int selectedDescriptor = this.selectOneDescriptor(bs, q2_temparray, pred_temparray, bestPredictedValues);
            bs.set(selectedDescriptor, false);
            b = new BitSet();
            b.or(bs);
            result[i] = new PFLRResult(this.descriptorVectors, this.expValues, b);
            if (this.debug > 0) {
                try {
                    this.q2s.append(" PFLR Removed descriptor: " + selectedDescriptor + " q2: " + q2_temparray[selectedDescriptor] + "\n");
                    this.q2s.flush();
                    File plot = new File(this.outDir, "pflr_q2plot_" + i);
                    this.writePlotFile(plot, this.expValues, bestPredictedValues);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.debug > 0) {
            try {
                this.q2s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        b = new BitSet();
        b.or(bs);
        result[i] = new PFLRResult(this.descriptorVectors, this.expValues, b);
        return result;
    }

    private void writePlotFile(File plot, double[] experimentalValues, double[] predictedValues) throws IOException {
        FileWriter fw = new FileWriter(plot);
        for (int i = 0; i < predictedValues.length; ++i) {
            fw.append(experimentalValues[i] + " " + predictedValues[i] + "\n");
        }
        fw.close();
    }

    private int selectOneDescriptor(BitSet bs, double[] q2_temparray, double[] pred_temparray, double[] bestPredictedValues) {
        ++this.selectedD;
        int bestQ2Index = -1;
        double newBestQ2 = Double.NEGATIVE_INFINITY;
        int ithDescriptor = bs.nextSetBit(0);
        while (ithDescriptor > -1) {
            bs.set(ithDescriptor, false);
            this.createPrediction(bs, pred_temparray);
            bs.set(ithDescriptor, true);
            q2_temparray[ithDescriptor] = Stat.pearsonR2(pred_temparray, this.expValues);
            if (q2_temparray[ithDescriptor] > newBestQ2) {
                bestQ2Index = ithDescriptor;
                newBestQ2 = q2_temparray[ithDescriptor];
                System.arraycopy(pred_temparray, 0, bestPredictedValues, 0, pred_temparray.length);
            }
            ithDescriptor = bs.nextSetBit(ithDescriptor + 1);
        }
        if (this.verbose > 2) {
            System.err.println(this.selectedD + "th PFLR q2 predicted vaules" + Stat.pearsonR2(bestPredictedValues, this.expValues));
            ErrPrint.errPrint("orig", this.expValues);
            ErrPrint.errPrint("pred", bestPredictedValues);
        }
        if (bs.cardinality() == 1) {
            return bs.nextSetBit(0);
        }
        return bestQ2Index;
    }

    private void createPrediction(BitSet bs, double[] arrayToPredict) {
        int numberOfCloseVectors = Math.min(Math.min(this.descriptorVectors.length - 1, 14), bs.cardinality());
        double[][] closeVectors = new double[numberOfCloseVectors][];
        int[] closeVectorsIndexes = new int[numberOfCloseVectors];
        for (int ithMolecule = 0; ithMolecule < this.descriptorVectors.length; ++ithMolecule) {
            double y;
            arrayToPredict[ithMolecule] = y = this.predictForIthArray(ithMolecule, this.descriptorVectors, this.expValues, bs, closeVectors, closeVectorsIndexes);
        }
    }

    private double predictForIthArray(int i, double[][] descriptorMatrix, double[] experimentalValues, BitSet bs, double[][] closeVectors, int[] closeVectorsIndexes) {
        PFLRUtil.findClosestVectors(descriptorMatrix, descriptorMatrix[i], closeVectors, closeVectorsIndexes, true, bs);
        PFLRInterpolation pflr = new PFLRInterpolation(closeVectors);
        pflr.setSelection(bs);
        double[] c = pflr.getCoefficients(descriptorMatrix[i]);
        double y = 0.0;
        for (int j = 0; j < c.length; ++j) {
            double d = c[j];
            y += d * experimentalValues[closeVectorsIndexes[j]];
        }
        return y;
    }

    @Override
    public void setDescriptorMatrix(DescriptorMatrix matrix) {
        this.descriptorVectors = new double[matrix.getRowCount()][];
        for (int i = 0; i < this.descriptorVectors.length; ++i) {
            this.descriptorVectors[i] = new double[matrix.getColumnCount()];
            System.arraycopy(matrix.getRow(i), 0, this.descriptorVectors[i], 0, matrix.getColumnCount());
            this.prog = (float)i / (float)this.descriptorVectors.length;
        }
        for (int col = 0; col < this.descriptorVectors[0].length; ++col) {
            int row;
            double[] v = new double[this.descriptorVectors.length];
            for (row = 0; row < this.descriptorVectors.length; ++row) {
                v[row] = this.descriptorVectors[row][col];
            }
            Stat.autoScale(v);
            for (row = 0; row < this.descriptorVectors.length; ++row) {
                this.descriptorVectors[row][col] = v[row];
            }
        }
    }

    @Override
    public void setExperimentalValues(double[] values) {
        this.expValues = new double[values.length];
        System.arraycopy(values, 0, this.expValues, 0, values.length);
    }

    @Override
    public PFLRResult getResult() {
        this.initDebug();
        return new PFLRResult(this.descriptorVectors, this.expValues, this.selectDescriptors());
    }

    public PFLRResult[] getResult(int numberOfDescriptors) {
        this.initDebug();
        return this.selectDescriptors(numberOfDescriptors);
    }

    @Override
    public float getProgress() {
        return this.prog;
    }
}

