/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pflr;

import chemaxon.calculations.training.Stat;
import chemaxon.calculations.training.pflr.PFLRUtil;
import chemaxon.marvin.modelling.linalg.PFLRInterpolation;
import chemaxon.marvin.modelling.util.StringConversionUtility;
import java.security.GuardedObject;
import java.util.BitSet;

public class PFLRResult {
    private double[][] trainX;
    private double[] trainY;
    private boolean useCenter = false;
    private BitSet selected;

    public PFLRResult(double[][] descriptors, double[] expValues) {
        this.trainX = new double[descriptors.length][];
        for (int i = 0; i < this.trainX.length; ++i) {
            this.trainX[i] = new double[descriptors[0].length];
            System.arraycopy(descriptors[i], 0, this.trainX[i], 0, descriptors[i].length);
        }
        this.trainY = new double[expValues.length];
        System.arraycopy(expValues, 0, this.trainY, 0, expValues.length);
        this.selected = null;
    }

    public PFLRResult(double[][] descriptors, double[] expValues, BitSet selected) {
        this.trainX = new double[descriptors.length][];
        for (int i = 0; i < this.trainX.length; ++i) {
            this.trainX[i] = new double[descriptors[0].length];
            System.arraycopy(descriptors[i], 0, this.trainX[i], 0, descriptors[i].length);
        }
        this.trainY = new double[expValues.length];
        System.arraycopy(expValues, 0, this.trainY, 0, expValues.length);
        this.selected = selected;
    }

    private double predict(double[] descriptors, int closeVectNum, boolean q2) {
        PFLRInterpolation pflr = new PFLRInterpolation();
        pflr.setSelection(this.selected);
        double[][] closestTrainVectors = new double[closeVectNum][];
        int[] closestTrainVectorsIndex = new int[closeVectNum];
        double predictedY = 0.0;
        pflr.setUseCenter(this.useCenter);
        PFLRUtil.findClosestVectors(this.trainX, descriptors, closestTrainVectors, closestTrainVectorsIndex, q2, this.selected);
        pflr.setSubspaceVectors(closestTrainVectors);
        double[] coeff = pflr.getCoefficients(descriptors);
        for (int j = 0; j < closeVectNum; ++j) {
            predictedY += coeff[j] * this.trainY[closestTrainVectorsIndex[j]];
        }
        return predictedY;
    }

    public double predict(double[] descriptors) {
        return this.predict(descriptors, Math.min(Math.min(this.trainX.length - 1, 14), descriptors.length), false);
    }

    public void setUseCenter(boolean useCenter) {
        this.useCenter = useCenter;
    }

    public double[][] getTraningXData() {
        double[][] v = new double[this.trainX.length][];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new double[this.trainX[i].length];
            System.arraycopy(this.trainX[i], 0, v[i], 0, v[i].length);
        }
        return v;
    }

    public double[] getTrainingYData() {
        double[] v = new double[this.trainY.length];
        System.arraycopy(this.trainY, 0, v, 0, v.length);
        return v;
    }

    public double calcQ2() {
        double[] pred = new double[this.trainY.length];
        for (int i = 0; i < this.trainX.length; ++i) {
            pred[i] = this.predict(this.trainX[i], Math.min(Math.min(this.trainX.length - 1, 14), this.trainX[i].length), true);
        }
        return Stat.pearsonR2(this.trainY, pred);
    }

    public BitSet getSelection() {
        if (this.selected == null) {
            return null;
        }
        return (BitSet)this.selected.clone();
    }

    public String toString() {
        return StringConversionUtility.itemToString(new GuardedObject(this, null));
    }

    public static PFLRResult fromString(String s) {
        return (PFLRResult)StringConversionUtility.fromString(s);
    }
}

