/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.solubility;

public class SpiralOnSphere {
    private double[][] pt = null;

    public SpiralOnSphere(int N) {
        this.pt = new double[N][];
        double dl = Math.PI * (3.0 - Math.sqrt(5.0));
        double l = 0.0;
        double dz = 2.0 / (double)N;
        double z = 1.0 - dz / 2.0;
        for (int k = 0; k < N; ++k) {
            double r = Math.sqrt(1.0 - z * z);
            this.pt[k] = new double[]{Math.cos(l) * r, Math.sin(l) * r, z};
            z -= dz;
            l += dl;
        }
    }

    public double[][] getPoints() {
        return this.pt;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.pt.length; ++i) {
            sb.append(this.pt[i][0] + " " + this.pt[i][1] + " " + this.pt[i][2] + "\n ");
        }
        return sb.toString();
    }
}

