/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr;

import chemaxon.calculations.nmr.MeasuredNMRSpectrum;
import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.nmr.Spectrum;
import chemaxon.calculations.nmr.io.NMRExporter;
import chemaxon.calculations.nmr.io.NMRImporter;
import chemaxon.calculations.ui.nmr.NMRDataSource;
import chemaxon.chart.dataset.AbstractFunction;
import chemaxon.chart.dataset.DataSource;
import chemaxon.chart.dataset.DataSourceFactory;
import chemaxon.chart.dataset.Interval;
import chemaxon.chart.model.ChartEntry;
import chemaxon.formats.MolExporter;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;

public final class SpectrumUtility {
    public static DecimalFormat FORMATTER = new DecimalFormat("#,##0.00");

    private SpectrumUtility() {
    }

    public static DataSource createAtomIndexChart(NMRSpectrum spectrum) {
        int maxIndex;
        Multiplet[] pletts = spectrum.getMultiplets();
        double[] maxLocations = spectrum.getLocalMaximumPlaces();
        Arrays.sort(maxLocations);
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        double[] values = new double[pletts.length];
        Object[] labels = new String[pletts.length];
        for (maxIndex = 0; maxIndex < maxLocations.length && pletts[0].getDomainMin() > maxLocations[maxIndex]; ++maxIndex) {
        }
        for (int i = 0; i < pletts.length; ++i) {
            double value = 0.0;
            if (maxIndex < maxLocations.length && pletts[i].getDomainMin() <= maxLocations[maxIndex] && pletts[i].getDomainMax() > maxLocations[maxIndex]) {
                value = spectrum.getValueAt(maxLocations[maxIndex]);
                while (maxIndex < maxLocations.length && pletts[i].getDomainMax() > maxLocations[maxIndex]) {
                    if (value < spectrum.getValueAt(maxLocations[maxIndex])) {
                        value = spectrum.getValueAt(maxLocations[maxIndex]);
                    }
                    ++maxIndex;
                }
            }
            intervals.add(new Interval((Comparable)Double.valueOf(pletts[i].getDomainMin()), (Comparable)Double.valueOf(pletts[i].getDomainMax())));
            values[i] = value;
            labels[i] = SpectrumUtility.arrayToString(pletts[i].getAtomIndices());
        }
        return DataSourceFactory.createInfoSource(intervals, (double[])values, (Object[])labels);
    }

    public static DataSource createShiftChart(NMRSpectrum spectrum) {
        Multiplet[] pletts = spectrum.getMultiplets();
        double[] maxLocations = spectrum.getLocalMaximumPlaces();
        Arrays.sort(maxLocations);
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        double[] values = new double[pletts.length];
        Object[] labels = new String[pletts.length];
        for (int i = 0; i < pletts.length; ++i) {
            int maxIndex;
            double value = 0.0;
            for (maxIndex = 0; maxIndex < maxLocations.length && pletts[i].getDomainMin() > maxLocations[maxIndex]; ++maxIndex) {
            }
            if (maxIndex < maxLocations.length && pletts[i].getDomainMin() <= maxLocations[maxIndex] && pletts[i].getDomainMax() > maxLocations[maxIndex]) {
                value = spectrum.getValueAt(maxLocations[maxIndex]);
                while (maxIndex < maxLocations.length && pletts[i].getDomainMax() > maxLocations[maxIndex]) {
                    if (value < spectrum.getValueAt(maxLocations[maxIndex])) {
                        value = spectrum.getValueAt(maxLocations[maxIndex]);
                    }
                    ++maxIndex;
                }
            }
            intervals.add(new Interval((Comparable)Double.valueOf(pletts[i].getDomainMin()), (Comparable)Double.valueOf(pletts[i].getDomainMax())));
            values[i] = value;
            labels[i] = FORMATTER.format(pletts[i].getShift());
        }
        return DataSourceFactory.createInfoSource(intervals, (double[])values, (Object[])labels);
    }

    public static String arrayToString(int[] array) {
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i] + 1);
            if (i + 1 >= array.length) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String intensityArrayToString(int[] array) {
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
            if (i + 1 >= array.length) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String createMultipletInformation(Multiplet multiplet, Molecule molecule, String unit) {
        StringBuilder text = new StringBuilder("Multiplet information:\n\r");
        text.append("\n\r Chemical shift: ");
        text.append(FORMATTER.format(multiplet.getShift()));
        text.append(" ");
        text.append(unit);
        text.append("\n\r Net intensity: ");
        text.append(multiplet.getNetIntensity());
        text.append("\n\r Intensity pattern: ");
        text.append(SpectrumUtility.arrayToString(multiplet.getIntesityPattern()));
        text.append("\n\r NMR line numbers: ");
        text.append(multiplet.getNumberOfLines());
        return text.toString();
    }

    public static void setFormatter(int decimals) {
        StringBuilder builder = new StringBuilder("#,##0");
        if (decimals > 0) {
            builder.append(".");
        }
        for (int i = 0; i < decimals; ++i) {
            builder.append("0");
        }
        FORMATTER = new DecimalFormat(builder.toString());
    }

    public static Multiplet getMultipletAt(Interval<Double> target, Multiplet[] multiplets) {
        Multiplet result = null;
        if (multiplets != null) {
            for (Multiplet multiplet : multiplets) {
                if (!((Double)target.getMin()).equals(multiplet.getDomainMin()) && !((Double)target.getMax()).equals(multiplet.getDomainMax())) continue;
                result = multiplet;
                break;
            }
        }
        return result;
    }

    public static boolean containsAtomIndex(Multiplet multiplet, int index) {
        boolean result = false;
        int[] atomIndexes = multiplet.getAtomIndices();
        for (int i = 0; i < atomIndexes.length; ++i) {
            if (atomIndexes[i] != index) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Multiplet getMultipletFor(int index, Spectrum spectrum) {
        Multiplet result = null;
        Multiplet[] multiplets = spectrum.getMultiplets();
        if (multiplets != null) {
            for (int i = 0; i < multiplets.length; ++i) {
                if (!SpectrumUtility.containsAtomIndex(multiplets[i], index)) continue;
                result = multiplets[i];
                break;
            }
        }
        return result;
    }

    public static DataSource createIntegralDatasource(final NMRDataSource spectrum) {
        AbstractFunction result = new AbstractFunction(){

            public Interval<Double> getRange() {
                return spectrum.getRange();
            }

            public Interval<Double> getDomain() {
                return spectrum.getDomain();
            }

            public double getValueAt(double location) {
                return spectrum.getSpectrum().getIntegralValueAt(location);
            }
        };
        return result;
    }

    public static void export(NMRSpectrum spectrum, String path, String format2, String propertyName) throws IOException {
        Molecule result = NMRExporter.exportToMol(spectrum, propertyName);
        MolExporter exporter = new MolExporter(path, format2);
        exporter.write(result);
        exporter.close();
    }

    public static void exportJCAMP(NMRSpectrum spectrum, String path) throws IOException {
        String result = NMRExporter.exportToJcampDX(spectrum);
        PrintStream out = new PrintStream(new FileOutputStream(new File(path)));
        out.print(result);
        out.close();
    }

    public static MeasuredNMRSpectrum importJCAMP(String path) throws IOException {
        FileReader reader = new FileReader(path);
        MeasuredNMRSpectrum spectrum = NMRImporter.importFromJcampDX(reader);
        reader.close();
        return spectrum;
    }

    public static MeasuredNMRSpectrum importJCAMP(String path, double max) throws IOException {
        FileReader reader = new FileReader(path);
        MeasuredNMRSpectrum spectrum = NMRImporter.importFromJcampDX(reader, max);
        reader.close();
        return spectrum;
    }

    public static ChartEntry createLocalMaxChart(MeasuredNMRSpectrum spectrum) {
        double[] locations = spectrum.getLocalMaximumPlaces();
        if (locations == null || locations.length == 0) {
            return null;
        }
        double[] values = new double[locations.length];
        Object[] labels = new String[locations.length];
        block0: for (int i = 0; i < locations.length; ++i) {
            labels[i] = FORMATTER.format(locations[i]);
            if (spectrum.getLocalMaximumValues() != null) {
                values[i] = spectrum.getLocalMaximumValues()[i];
                continue;
            }
            for (int j = 0; j < spectrum.getNumberOfPoints(); ++j) {
                if (!(spectrum.getXValues()[j] > locations[i])) continue;
                values[i] = (spectrum.getXValues()[j] - spectrum.getXValues()[j - 1]) / (locations[i] - spectrum.getXValues()[j - 1]) * (spectrum.getYValues()[j] - spectrum.getYValues()[j - 1]);
                continue block0;
            }
        }
        DataSource source = DataSourceFactory.createInfoSource((double[])locations, (double[])values, (Object[])labels);
        return new ChartEntry(source, false, Color.black);
    }
}

