/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRCoefficient;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.SpectrumUtility;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class NMRAtomInfo
extends JTable {
    public static final String PROPERTY_KEY_SELECTION = "selection";
    private HashMap<Integer, Multiplet> multipletOfindex = new HashMap();
    private Multiplet selected;
    private AtomTableCellRenderer renderer;

    public NMRAtomInfo() {
        this.setAutoCreateRowSorter(true);
        this.renderer = new AtomTableCellRenderer(this.getBackground(), this.getSelectionBackground());
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (NMRAtomInfo.this.getSelectedRow() >= 0) {
                    Multiplet newSelection = (Multiplet)NMRAtomInfo.this.multipletOfindex.get((Integer)NMRAtomInfo.this.getModel().getValueAt(NMRAtomInfo.this.getRowSorter().convertRowIndexToModel(NMRAtomInfo.this.getSelectedRow()), 0) - 1);
                    NMRAtomInfo.this.select(newSelection);
                } else {
                    NMRAtomInfo.this.select(null);
                }
            }
        });
        this.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                NMRAtomInfo.this.select(null);
                NMRAtomInfo.this.select(NMRAtomInfo.this.selected);
            }
        });
    }

    public void select(Multiplet multiplet) {
        Multiplet old = this.selected;
        if (multiplet == null) {
            this.selected = null;
            this.renderer.select(null);
            this.firePropertyChange(PROPERTY_KEY_SELECTION, old, this.selected);
            this.repaint();
        } else if (this.selected == null || !this.selected.equals(multiplet)) {
            this.selected = multiplet;
            ArrayList<Integer> selection = new ArrayList<Integer>();
            for (int atomNumber : multiplet.getAtomIndices()) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (atomNumber != (Integer)this.getModel().getValueAt(this.getRowSorter().convertRowIndexToModel(i), 0) - 1) continue;
                    selection.add(i);
                }
            }
            this.renderer.select(selection);
            this.firePropertyChange(PROPERTY_KEY_SELECTION, old, this.selected);
            this.repaint();
        }
    }

    public void setSpectrum(NMRSpectrum spectrum, Multiplet[] multiplets) {
        this.setModel(new NotEditableModel(new String[]{"Atom number", "Chemical shift", "Net intensity", "Multiplet information", "Quality"}, spectrum.getNumberOfNMRActiveNuclei()));
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(this.renderer);
        }
        for (Multiplet multiplet : multiplets) {
            for (int j = 0; j < multiplet.getAtomCount(); ++j) {
                this.multipletOfindex.put(multiplet.getAtomIndex(j), multiplet);
            }
        }
        List<Integer> indexes = spectrum.getAtomIndexes();
        for (int i = 0; i < indexes.size(); ++i) {
            this.getModel().setValueAt(indexes.get(i) + 1, i, 0);
            Multiplet plet = this.multipletOfindex.get(indexes.get(i));
            this.getModel().setValueAt(SpectrumUtility.FORMATTER.format(plet.getShift()) + " " + spectrum.getUnit().toString(), i, 1);
            this.getModel().setValueAt(plet.getNetIntensity(), i, 2);
            this.getModel().setValueAt(plet.toString(), i, 3);
            this.getModel().setValueAt((Object)plet.getShiftErrorClassification(), i, 4);
        }
    }

    @Override
    public void clearSelection() {
        this.selected = null;
        if (this.renderer != null) {
            this.renderer.select(null);
        }
        this.repaint();
    }

    private class AtomTableCellRenderer
    extends DefaultTableCellRenderer {
        private List<Integer> selection;
        private Color selectionColor = Color.red;
        private Color defaultColor = Color.white;
        private final Color GOOD_COLOR = new Color(0, 150, 50);
        private final Color MEDIUM_COLOR = new Color(200, 150, 50);
        private final Color BAD_COLOR = new Color(200, 50, 50);

        public AtomTableCellRenderer(Color defaultColor, Color selectionColor) {
            this.defaultColor = defaultColor;
            this.selectionColor = selectionColor;
            this.setFont(this.getFont().deriveFont(0));
        }

        public void select(List<Integer> selection) {
            this.selection = selection;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.selection != null && this.selection.contains(row)) {
                this.setBackground(this.selectionColor);
            } else {
                this.setBackground(this.defaultColor);
            }
            if (column == 4) {
                switch ((NMRCoefficient.ErrorClassification)((Object)value)) {
                    case good: {
                        this.setForeground(this.GOOD_COLOR);
                        break;
                    }
                    case medium: {
                        this.setForeground(this.MEDIUM_COLOR);
                        break;
                    }
                    case poor: {
                        this.setForeground(this.BAD_COLOR);
                        break;
                    }
                    default: {
                        this.setForeground(Color.black);
                        break;
                    }
                }
            } else {
                this.setForeground(Color.black);
            }
            this.setText(value != null ? value.toString() : "");
            return this;
        }
    }

    private class NotEditableModel
    extends DefaultTableModel {
        public NotEditableModel(Object[] headers, int rowcount) {
            super(headers, rowcount);
        }

        @Override
        public boolean isCellEditable(int a, int b) {
            return false;
        }
    }
}

