/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.MeasuredNMRSpectrum;
import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.MultipletDataSource;
import chemaxon.calculations.ui.nmr.NMRDataSource;
import chemaxon.calculations.ui.nmr.SpectrumUtility;
import chemaxon.calculations.ui.nmr.prediction.Drawable;
import chemaxon.chart.dataset.DataSet;
import chemaxon.chart.dataset.DataSource;
import chemaxon.chart.dataset.DataSourceFactory;
import chemaxon.chart.dataset.Function;
import chemaxon.chart.dataset.Interval;
import chemaxon.chart.gui.DefaultChartComponent;
import chemaxon.chart.gui.GuidelineChartComponent;
import chemaxon.chart.gui.ZoomableChartComponent;
import chemaxon.chart.model.Chart;
import chemaxon.chart.model.ChartEntry;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;

public class NMRChartComponent
extends JPanel {
    public static final String PROPERTY_KEY_MOUSE_LOCATION = "mouseLocation";
    public static final String PROPERTY_KEY_SELECTION = "selection";
    private GuidelineChartComponent chartPreview;
    private ZoomableChartComponent chartDisplay;
    private JSplitPane chartPane;
    private DataSet.ValueType renderMode = DataSet.ValueType.LINE;
    private GuidelineChartComponent.ZoomType zoomType = GuidelineChartComponent.ZoomType.DOMAIN;
    private Color highlightColor = Color.red;
    private Color integralColor = Color.pink;
    private Color referenceColor = Color.blue;
    private Color spectrumColor = Color.darkGray;
    private boolean integralDisplayed = true;
    private InformationType infoType = InformationType.SHIFT;
    private InformationType referenceInfoType = InformationType.NONE;
    private boolean highlightFollowing = true;
    private double highlightFollowingSize = 0.1;
    private NMRDataSource source;
    private MeasuredNMRSpectrum referenceSpectrum;
    private Multiplet[] multiplets;
    private Multiplet selected;
    private boolean selectionModeMultiplet = false;

    public NMRChartComponent() {
        super(new BorderLayout());
        this.add((Component)this.getChartPane(), "Center");
    }

    private JSplitPane getChartPane() {
        if (this.chartPane == null) {
            this.chartPane = new JSplitPane(0, true, (Component)this.getGuidelineChart(), (Component)this.getPredictionChart());
            this.chartPane.setResizeWeight(0.1);
            this.chartPane.setDoubleBuffered(true);
            this.chartPane.setContinuousLayout(true);
        }
        return this.chartPane;
    }

    private GuidelineChartComponent getGuidelineChart() {
        if (this.chartPreview == null) {
            this.chartPreview = new GuidelineChartComponent();
            this.chartPreview.setDoubleBuffered(true);
            this.chartPreview.setType(this.zoomType);
            this.chartPreview.getTransformer().setReverseDomain(true);
            this.chartPreview.getOptions().setHighlightColor(this.highlightColor);
            this.chartPreview.setMinimumDomain(0.01);
            this.chartPreview.setMinimumRange(0.01);
            this.chartPreview.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        NMRChartComponent.this.getPopUpMenu((JComponent)NMRChartComponent.this.chartPreview).show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
            this.chartPreview.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("highlight")) {
                        Multiplet multiplet;
                        Interval target = NMRChartComponent.this.getPredictionChart().getHighlightedInterval();
                        if (target != null && (multiplet = SpectrumUtility.getMultipletAt((Interval<Double>)target, NMRChartComponent.this.multiplets)) != null) {
                            NMRChartComponent.this.select(multiplet);
                        }
                    } else {
                        NMRChartComponent.this.getPredictionChart().setVisibleArea(NMRChartComponent.this.getGuidelineChart().getDomain(), NMRChartComponent.this.getGuidelineChart().getRange());
                    }
                }
            });
        }
        return this.chartPreview;
    }

    private ZoomableChartComponent getPredictionChart() {
        if (this.chartDisplay == null) {
            this.chartDisplay = new ZoomableChartComponent();
            this.chartDisplay.setDoubleBuffered(true);
            this.chartDisplay.setMinimumSize(new Dimension(200, 200));
            this.chartDisplay.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Interval target;
                    Multiplet multiplet;
                    if (evt.getPropertyName().equals("domain") || evt.getPropertyName().equals("range")) {
                        NMRChartComponent.this.getGuidelineChart().setArea(NMRChartComponent.this.getPredictionChart().getVisibleDomain(), NMRChartComponent.this.getPredictionChart().getVisibleRange());
                    } else if (evt.getPropertyName().equals("highlight") && (multiplet = SpectrumUtility.getMultipletAt((Interval<Double>)(target = NMRChartComponent.this.getPredictionChart().getHighlightedInterval()), NMRChartComponent.this.multiplets)) != null) {
                        NMRChartComponent.this.select(multiplet);
                    }
                }
            });
            this.chartDisplay.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        NMRChartComponent.this.getPopUpMenu((JComponent)NMRChartComponent.this.chartDisplay).show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
            this.chartDisplay.setType(this.zoomType);
            this.chartDisplay.setMinimumDomain(0.01);
            this.chartDisplay.setMinimumRange(0.01);
            this.chartDisplay.getTransformer().setReverseDomain(true);
            this.chartDisplay.getOptions().setHighlightColor(this.highlightColor);
            this.chartDisplay.getOptions().setGridlineColor(new Color(220, 220, 220));
            this.chartDisplay.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent event) {
                    if (NMRChartComponent.this.chartDisplay.getOptions().isValid()) {
                        NMRChartComponent.this.firePropertyChange(NMRChartComponent.PROPERTY_KEY_MOUSE_LOCATION, null, new Point2D.Double(NMRChartComponent.this.getPredictionChart().getTransformer().getDomainElement(event.getPoint().x), NMRChartComponent.this.getPredictionChart().getTransformer().getRangeElement(event.getPoint().y)));
                    }
                }
            });
        }
        return this.chartDisplay;
    }

    private DataSource getCurrentDatasource() {
        NMRDataSource result = null;
        result = DataSet.ValueType.LINEPEAKS == this.renderMode ? DataSourceFactory.createSource((Function)this.source, (double[])this.source.getSpectrum().getLocalMaximumPlaces(), (DataSet.ValueType)DataSet.ValueType.LINEPEAKS) : this.source;
        return result;
    }

    private DataSource getReferenceDatasource() {
        DataSource result = DataSourceFactory.createSource((double[])this.referenceSpectrum.getXValues(), (double[])this.referenceSpectrum.getYValues(), (DataSet.ValueType)this.renderMode);
        return result;
    }

    public void setSource(NMRSpectrum spectrum, Multiplet[] multiplets) {
        this.source = new NMRDataSource(spectrum);
        this.multiplets = multiplets;
        this.reload();
    }

    public void setReferenceSpectrum(MeasuredNMRSpectrum spectrum) {
        this.referenceSpectrum = spectrum;
        this.reload(false);
    }

    public void select(Multiplet multiplet) {
        Multiplet oldValue = this.selected;
        this.selected = multiplet;
        if (multiplet != null || oldValue != null) {
            this.firePropertyChange(PROPERTY_KEY_SELECTION, oldValue, multiplet);
        }
        if (multiplet != null) {
            Object selectionSource = null;
            if (this.selectionModeMultiplet) {
                MultipletDataSource multipletSource = new MultipletDataSource(multiplet);
                selectionSource = this.renderMode == DataSet.ValueType.LINE ? multipletSource : DataSourceFactory.createSource((Function)multipletSource, (double[])multiplet.getLocalMaximumPlaces(), (DataSet.ValueType)DataSet.ValueType.LINEPEAKS);
            } else {
                selectionSource = this.getCurrentDatasource();
            }
            this.getPredictionChart().setHighlight(selectionSource, new Interval((Comparable)Double.valueOf(multiplet.getDomainMin()), (Comparable)Double.valueOf(multiplet.getDomainMax())));
            this.getGuidelineChart().setHighlight(selectionSource, new Interval((Comparable)Double.valueOf(multiplet.getDomainMin()), (Comparable)Double.valueOf(multiplet.getDomainMax())));
            if (this.highlightFollowing) {
                Interval domain = this.getPredictionChart().getVisibleDomain();
                double domainSize = (Double)this.getGuidelineChart().getOptions().getDomain().getMax() - (Double)this.getGuidelineChart().getOptions().getDomain().getMin();
                if (this.getGuidelineChart().getType() != GuidelineChartComponent.ZoomType.RANGE) {
                    domain = new Interval((Comparable)Double.valueOf(multiplet.getDomainMin()), (Comparable)Double.valueOf(multiplet.getDomainMax()));
                }
                if ((Double)domain.getMax() - (Double)domain.getMin() < this.highlightFollowingSize * domainSize) {
                    double center = ((Double)domain.getMax() + (Double)domain.getMin()) / 2.0;
                    domain.setMax((Comparable)Double.valueOf(center + this.highlightFollowingSize / 2.0 * domainSize));
                    domain.setMin((Comparable)Double.valueOf(center - this.highlightFollowingSize / 2.0 * domainSize));
                }
                this.getPredictionChart().setVisibleArea(domain, this.getPredictionChart().getVisibleRange());
            }
        } else {
            this.getPredictionChart().setHighlight(null, null);
            this.getGuidelineChart().setHighlight(null, null);
        }
    }

    public void reload() {
        DataSource result = this.getCurrentDatasource();
        Chart full = new Chart();
        Chart guide = new Chart();
        full.setAxisXName(this.source.getSpectrum().getUnit().toString());
        full.setAxisYName("Intensity");
        if (this.referenceSpectrum != null) {
            ChartEntry referenceEntry = new ChartEntry(this.getReferenceDatasource(), false, this.referenceColor);
            guide.add(referenceEntry);
            full.add(referenceEntry);
        }
        full.add(new ChartEntry(result, true, this.spectrumColor));
        guide.add(new ChartEntry(result, true, this.spectrumColor));
        switch (this.infoType) {
            case ATOM_NUMBER: {
                full.add(new ChartEntry(SpectrumUtility.createAtomIndexChart(this.source.getSpectrum()), false, Color.red));
                break;
            }
            case SHIFT: {
                full.add(new ChartEntry(SpectrumUtility.createShiftChart(this.source.getSpectrum()), false, Color.red));
                break;
            }
        }
        switch (this.referenceInfoType) {
            case REFERENCE_MAXIMUMS: {
                if (this.referenceSpectrum == null || this.referenceSpectrum.getLocalMaximumPlaces() == null || this.referenceSpectrum.getLocalMaximumPlaces().length <= 0) break;
                full.add(SpectrumUtility.createLocalMaxChart(this.referenceSpectrum));
                break;
            }
        }
        if (this.integralDisplayed) {
            full.add(new ChartEntry(SpectrumUtility.createIntegralDatasource(this.source), false, this.integralColor));
        }
        this.getGuidelineChart().setChart(guide);
        this.getPredictionChart().setChart(full);
        this.revalidate();
        this.repaint();
    }

    public void reload(boolean clearSettings) {
        Interval domain = null;
        Interval range = null;
        if (!clearSettings) {
            domain = this.getPredictionChart().getVisibleDomain();
            range = this.getPredictionChart().getVisibleRange();
        }
        this.reload();
        if (!clearSettings) {
            this.getPredictionChart().setVisibleArea(domain, range);
        }
    }

    public void setIntegralFunctionVisible(boolean visible) {
        this.integralDisplayed = visible;
        this.reload(false);
    }

    public void setInformationType(InformationType type) {
        this.infoType = type;
        this.reload(false);
    }

    public void setRenderMode(DataSet.ValueType type) {
        if (type == DataSet.ValueType.LINE || type == DataSet.ValueType.LINEPEAKS) {
            this.renderMode = type;
            this.reload(false);
        }
    }

    public void setHighlightFollowing(boolean following) {
        this.highlightFollowing = following;
    }

    public void setZoomType(GuidelineChartComponent.ZoomType type) {
        this.zoomType = type;
        this.getPredictionChart().setType(type);
        this.getGuidelineChart().setType(type);
    }

    public void zoomOut() {
        this.getPredictionChart().zoomOut();
    }

    public void zoomIn() {
        this.getPredictionChart().zoomIn();
    }

    public void resetZoom() {
        Chart chart = this.getPredictionChart().getChart();
        this.getPredictionChart().setVisibleArea(chart.getDomain(), chart.getRange());
    }

    public MeasuredNMRSpectrum getReferenceSpectrum() {
        return this.referenceSpectrum;
    }

    public void setMultipletSelection(boolean multipletBased) {
        Multiplet tempSelected = this.selected;
        this.select(null);
        this.selectionModeMultiplet = multipletBased;
        this.select(tempSelected);
    }

    public void setReferenceInformationType(InformationType type) {
        this.referenceInfoType = type;
        this.reload(false);
    }

    public void setSpectrumColor(Color color) {
        this.spectrumColor = color;
        this.reload(false);
        this.select(this.selected);
    }

    public void setHighlightColor(Color color) {
        this.getPredictionChart().getOptions().setHighlightColor(color);
        this.getGuidelineChart().getOptions().setHighlightColor(color);
        this.highlightColor = color;
        this.reload(false);
        this.select(this.selected);
    }

    public void setReferenceColor(Color color) {
        this.referenceColor = color;
        this.reload(false);
        this.select(this.selected);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getReferenceColor() {
        return this.referenceColor;
    }

    public Color getSpectrumColor() {
        return this.spectrumColor;
    }

    public void setDecimalCount(int count) {
        this.getPredictionChart().setDecimalCount(count, count);
    }

    @Override
    public void print(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.chartPreview.print((Graphics)g2d);
        g2d.translate(0, 10 + this.chartPreview.getHeight());
        this.chartDisplay.print((Graphics)g2d);
        g2d.dispose();
    }

    public Drawable getDisplay() {
        return new Drawable(){

            @Override
            public Image getImage() {
                return NMRChartComponent.this.getImage((JComponent)NMRChartComponent.this.chartDisplay);
            }
        };
    }

    public Drawable getPreview() {
        return new Drawable(){

            @Override
            public Image getImage() {
                return NMRChartComponent.this.getImage((JComponent)NMRChartComponent.this.chartPreview);
            }
        };
    }

    public DefaultChartComponent getPreviewComponent() {
        return this.chartPreview;
    }

    public DefaultChartComponent getDisplayComponent() {
        return this.chartDisplay;
    }

    private BufferedImage getImage(JComponent component) {
        BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        component.paint(image.getGraphics());
        return image;
    }

    private JPopupMenu getPopUpMenu(final JComponent target) {
        JPopupMenu menu = new JPopupMenu("Menu");
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardHandler.putImageToClipboard(NMRChartComponent.this.getImage(target));
            }
        };
        copyAction.putValue("Name", "Copy to clipboard");
        menu.add(new JMenuItem(copyAction));
        return menu;
    }

    public static enum InformationType {
        SHIFT,
        ATOM_NUMBER,
        REFERENCE_MAXIMUMS,
        NONE;

    }
}

