/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRCoefficient;
import chemaxon.calculations.nmr.NMRSpectrum;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class NMRCouplingInfo
extends JTable {
    private QualityCellRenderer renderer = new QualityCellRenderer();
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,##0.0000");

    public NMRCouplingInfo() {
        this.setAutoCreateRowSorter(true);
        this.getSelectionModel().setSelectionMode(0);
    }

    public void setSpectrum(NMRSpectrum spectrum, Multiplet[] multiplets) {
        int count = 0;
        for (int i = 0; i < multiplets.length; ++i) {
            for (int j = 0; j < multiplets[i].getAtomCount(); ++j) {
                for (int k = 0; k < spectrum.getMolecule().getAtomCount(); ++k) {
                    if (multiplets[i].getCouplingConstants(j)[k] == 0.0) continue;
                    ++count;
                }
            }
        }
        this.setModel(new NotEditableModel(new String[]{"Atom 1", "Atom 2", "Value", "Quality"}, count));
        this.getColumnModel().getColumn(3).setCellRenderer(this.renderer);
        int index = 0;
        for (int i = 0; i < multiplets.length; ++i) {
            for (int j = 0; j < multiplets[i].getAtomCount(); ++j) {
                for (int k = 0; k < spectrum.getMolecule().getAtomCount(); ++k) {
                    if (multiplets[i].getCouplingConstants(j)[k] == 0.0) continue;
                    this.getModel().setValueAt(multiplets[i].getAtomIndex(j) + 1, index, 0);
                    this.getModel().setValueAt(k + 1, index, 1);
                    this.getModel().setValueAt(FORMATTER.format(multiplets[i].getCouplingConstants(j)[k]) + " " + spectrum.getUnit().toString(), index, 2);
                    this.getModel().setValueAt((Object)multiplets[i].getShiftErrorClassification(), index, 3);
                    ++index;
                }
            }
        }
    }

    private class QualityCellRenderer
    extends DefaultTableCellRenderer {
        private final Color DEFAULT_COLOR = Color.black;
        private final Color DEFAULT_BACKGROUND = Color.white;
        private final Color GOOD_COLOR = new Color(0, 150, 50);
        private final Color MEDIUM_COLOR = new Color(200, 150, 50);
        private final Color BAD_COLOR = new Color(200, 50, 50);

        public QualityCellRenderer() {
            this.setFont(this.getFont().deriveFont(0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(NMRCouplingInfo.this.getSelectionBackground());
            } else {
                this.setBackground(this.DEFAULT_BACKGROUND);
            }
            if (value != null) {
                switch ((NMRCoefficient.ErrorClassification)((Object)value)) {
                    case good: {
                        this.setForeground(this.GOOD_COLOR);
                        break;
                    }
                    case medium: {
                        this.setForeground(this.MEDIUM_COLOR);
                        break;
                    }
                    case poor: {
                        this.setForeground(this.BAD_COLOR);
                        break;
                    }
                    default: {
                        this.setForeground(this.DEFAULT_COLOR);
                    }
                }
            }
            this.setText(value != null ? value.toString() : "");
            return this;
        }
    }

    private class NotEditableModel
    extends DefaultTableModel {
        public NotEditableModel(Object[] headers, int rowcount) {
            super(headers, rowcount);
        }

        @Override
        public boolean isCellEditable(int a, int b) {
            return false;
        }
    }
}

