/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.prediction.NMRAtomInfo;
import chemaxon.calculations.ui.nmr.prediction.NMRCouplingInfo;
import chemaxon.calculations.ui.nmr.prediction.NMRMultipletInfo;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class NMRInfoPane
extends JTabbedPane {
    public static final String PROPERTY_KEY_SELECTION = "selection";
    private NMRAtomInfo atomInfo;
    private NMRMultipletInfo multipletInfo;
    private NMRCouplingInfo couplingInfo;
    private Multiplet[] multiplets;
    private Multiplet selection;
    private int selectedAtomIndex = -1;

    public NMRInfoPane() {
        this.setTabPlacement(3);
        this.addTab("Multiplet information", new JScrollPane(this.getMultipletInfo()));
        this.addTab("Atom information", new JScrollPane(this.getAtomInfo()));
        this.addTab("Coupling information", new JScrollPane(this.getCouplingInfo()));
    }

    private NMRAtomInfo getAtomInfo() {
        if (this.atomInfo == null) {
            this.atomInfo = new NMRAtomInfo();
            this.atomInfo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (NMRInfoPane.PROPERTY_KEY_SELECTION.equals(evt.getPropertyName())) {
                        NMRInfoPane.this.select((Multiplet)evt.getNewValue());
                    }
                }
            });
            this.atomInfo.setDropMode(DropMode.ON);
            this.atomInfo.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        NMRInfoPane.this.getPopUpMenu(NMRInfoPane.this.atomInfo).show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
        }
        return this.atomInfo;
    }

    private NMRMultipletInfo getMultipletInfo() {
        if (this.multipletInfo == null) {
            this.multipletInfo = new NMRMultipletInfo();
            this.multipletInfo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (NMRInfoPane.PROPERTY_KEY_SELECTION.equals(evt.getPropertyName())) {
                        NMRInfoPane.this.select((Multiplet)evt.getNewValue());
                    }
                }
            });
            this.multipletInfo.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        NMRInfoPane.this.getPopUpMenu(NMRInfoPane.this.multipletInfo).show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
        }
        return this.multipletInfo;
    }

    private NMRCouplingInfo getCouplingInfo() {
        if (this.couplingInfo == null) {
            this.couplingInfo = new NMRCouplingInfo();
            this.couplingInfo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (NMRInfoPane.PROPERTY_KEY_SELECTION.equals(evt.getPropertyName())) {
                        NMRInfoPane.this.select((Multiplet)evt.getNewValue());
                    }
                }
            });
            this.couplingInfo.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        NMRInfoPane.this.getPopUpMenu(NMRInfoPane.this.couplingInfo).show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
        }
        return this.couplingInfo;
    }

    public void setSpectrum(NMRSpectrum spectrum, Multiplet[] multiplets) {
        this.multiplets = multiplets;
        this.getAtomInfo().setSpectrum(spectrum, multiplets);
        this.getMultipletInfo().setSpectrum(spectrum, multiplets);
        this.getCouplingInfo().setSpectrum(spectrum, multiplets);
    }

    public void select(Multiplet multiplet) {
        if (multiplet == null) {
            this.clearSelection();
        } else if (this.selection == null || !this.selection.equals(multiplet)) {
            int old = this.selectedAtomIndex;
            this.getAtomInfo().select(multiplet);
            this.getMultipletInfo().select(multiplet);
            this.selection = multiplet;
            this.selectedAtomIndex = multiplet.getAtomIndex(0);
            this.firePropertyChange(PROPERTY_KEY_SELECTION, old, this.selectedAtomIndex);
        }
    }

    public void select(int atomIndex) {
        if (atomIndex < 0) {
            this.clearSelection();
        } else {
            for (Multiplet plet : this.multiplets) {
                int[] indexes = plet.getAtomIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    if (indexes[i] != atomIndex) continue;
                    this.select(plet);
                }
            }
        }
    }

    private void clearSelection() {
        this.selection = null;
        this.getAtomInfo().clearSelection();
        this.getMultipletInfo().clearSelection();
    }

    @Override
    public void print(Graphics graphics) {
        if (this.getSelectedComponent().equals(this.getAtomInfo())) {
            new NMRAtomInfo().print(graphics);
        } else if (this.getSelectedComponent().equals(this.getCouplingInfo())) {
            new NMRCouplingInfo().print(graphics);
        } else {
            new NMRMultipletInfo().print(graphics);
        }
    }

    private JPopupMenu getPopUpMenu(final JTable target) {
        JPopupMenu menu = new JPopupMenu("Menu");
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRInfoPane.this.copyToClipBoard(target);
            }
        };
        copyAction.putValue("Name", "Copy to clipboard");
        menu.add(new JMenuItem(copyAction));
        return menu;
    }

    private void copyToClipBoard(JTable target) {
        FullTableTransferHandler th = new FullTableTransferHandler();
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        th.exportToClipboard(target, cb, 1);
    }

    public void copyAtomInfoToClipBoard() {
        this.copyToClipBoard(this.getAtomInfo());
    }

    public void copyCouplingInfoToClipBoard() {
        this.copyToClipBoard(this.getCouplingInfo());
    }

    public void copyMultipletInfoToClipBoard() {
        this.copyToClipBoard(this.getMultipletInfo());
    }

    static class FullTableTransferHandler
    extends TransferHandler {
        FullTableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                JTable table = (JTable)c;
                StringBuffer plainBuf = new StringBuffer();
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    String obj = table.getModel().getColumnName(col);
                    String val = obj == null ? "" : obj.toString();
                    plainBuf.append(val + "\t");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                for (int row = 0; row < table.getRowCount(); ++row) {
                    for (int col = 0; col < table.getColumnCount(); ++col) {
                        Object obj = table.getValueAt(row, col);
                        String val = obj == null ? "" : obj.toString();
                        plainBuf.append(val + "\t");
                    }
                    plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                return new StringSelection(plainBuf.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }
}

