/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRCoefficient;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.SpectrumUtility;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class NMRMultipletInfo
extends JTable {
    public static final String PROPERTY_KEY_SELECTION = "selection";
    private Multiplet selected;
    private ColoredCellRenderer renderer = new ColoredCellRenderer();

    public NMRMultipletInfo() {
        this.setAutoCreateRowSorter(true);
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (NMRMultipletInfo.this.getSelectedRow() >= 0) {
                    NMRMultipletInfo.this.select((Multiplet)NMRMultipletInfo.this.getModel().getValueAt(NMRMultipletInfo.this.getRowSorter().convertRowIndexToModel(NMRMultipletInfo.this.getSelectedRow()), 4));
                }
            }
        });
        this.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                NMRMultipletInfo.this.select(null);
                NMRMultipletInfo.this.select(NMRMultipletInfo.this.selected);
            }
        });
    }

    public void setSpectrum(NMRSpectrum spectrum, Multiplet[] multiplets) {
        int i;
        this.setModel(new NotEditableModel(new String[]{"Atom numbers", "Chemical shift", "Net intensity", "Intensity pattern", "Multiplet information", "Quality"}, spectrum.getMultiplets().length));
        for (i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(this.renderer);
        }
        for (i = 0; i < multiplets.length; ++i) {
            this.getModel().setValueAt(SpectrumUtility.arrayToString(multiplets[i].getAtomIndices()), i, 0);
            this.getModel().setValueAt(SpectrumUtility.FORMATTER.format(multiplets[i].getShift()) + " " + spectrum.getUnit().toString(), i, 1);
            this.getModel().setValueAt(multiplets[i].getNetIntensity(), i, 2);
            this.getModel().setValueAt(SpectrumUtility.intensityArrayToString(multiplets[i].getIntesityPattern()), i, 3);
            this.getModel().setValueAt(multiplets[i], i, 4);
            this.getModel().setValueAt((Object)multiplets[i].getShiftErrorClassification(), i, 5);
        }
    }

    public void select(Multiplet multiplet) {
        if (multiplet == null) {
            this.clearSelection();
        } else if (this.selected == null || !this.selected.equals(multiplet)) {
            Multiplet old = this.selected;
            this.selected = multiplet;
            for (int i = 0; i < this.getModel().getRowCount(); ++i) {
                if (this.getModel().getValueAt(this.getRowSorter().convertRowIndexToModel(i), 4) != multiplet) continue;
                this.getSelectionModel().setSelectionInterval(i, i);
            }
            this.firePropertyChange(PROPERTY_KEY_SELECTION, old, this.selected);
        }
        this.repaint();
    }

    @Override
    public void clearSelection() {
        this.selected = null;
        this.getSelectionModel().clearSelection();
    }

    private class NotEditableModel
    extends DefaultTableModel {
        public NotEditableModel(Object[] headers, int rowcount) {
            super(headers, rowcount);
        }

        @Override
        public boolean isCellEditable(int a, int b) {
            return false;
        }
    }

    private class ColoredCellRenderer
    extends DefaultTableCellRenderer {
        private final Color DEFAULT_COLOR = Color.black;
        private final Color GOOD_COLOR = new Color(0, 150, 50);
        private final Color MEDIUM_COLOR = new Color(200, 150, 50);
        private final Color BAD_COLOR = new Color(200, 50, 50);
        private final Color selectionBgColor;
        private final Color defaultBgColor;

        public ColoredCellRenderer() {
            this.setFont(this.getFont().deriveFont(0));
            this.selectionBgColor = NMRMultipletInfo.this.getSelectionBackground();
            this.defaultBgColor = this.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (NMRMultipletInfo.this.selected != null && (isSelected || hasFocus)) {
                this.setBackground(this.selectionBgColor);
            } else {
                this.setBackground(this.defaultBgColor);
            }
            if (column == 5) {
                switch ((NMRCoefficient.ErrorClassification)((Object)value)) {
                    case good: {
                        this.setForeground(this.GOOD_COLOR);
                        break;
                    }
                    case medium: {
                        this.setForeground(this.MEDIUM_COLOR);
                        break;
                    }
                    case poor: {
                        this.setForeground(this.BAD_COLOR);
                        break;
                    }
                    default: {
                        this.setForeground(this.DEFAULT_COLOR);
                        break;
                    }
                }
            } else {
                this.setForeground(this.DEFAULT_COLOR);
            }
            this.setText(value != null ? value.toString() : "");
            return this;
        }
    }
}

