/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.MeasuredNMRSpectrum;
import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRCalculator;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.SpectrumUtility;
import chemaxon.calculations.ui.nmr.TextStatusBar;
import chemaxon.calculations.ui.nmr.prediction.DefaultNMRMoleculeViewer;
import chemaxon.calculations.ui.nmr.prediction.NMRChartComponent;
import chemaxon.calculations.ui.nmr.prediction.NMRInfoPane;
import chemaxon.calculations.ui.nmr.report.PDFReporter;
import chemaxon.chart.dataset.DataSet;
import chemaxon.chart.gui.GuidelineChartComponent;
import chemaxon.license.LicenseException;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.struc.Molecule;
import com.lowagie.text.Rectangle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class NMRResultView
extends JPanel
implements Printable {
    public static final String PROPERTY_KEY_MOLECULE = "molecule";
    private DefaultNMRMoleculeViewer moleculeViewer;
    private JSplitPane mainSplitPane;
    private JSplitPane moleculePane;
    private NMRChartComponent chart;
    private NMRInfoPane infoArea;
    private TextStatusBar statusBar;
    private Molecule molecule;
    private final Color highlightColor = Color.red;
    private final Color hoverColor = Color.pink;
    private boolean coupling = true;
    private NMRSpectrum.Nucleus predictionType = NMRSpectrum.Nucleus.C13;
    private NMRSpectrum spectrum;
    private Multiplet[] multiplets;
    private boolean implicitHmode = false;
    private Multiplet selected;

    public NMRResultView() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(400, 300));
        this.add((Component)this.getMainSplitPane(), "Center");
        this.add((Component)this.getStatusBar(), "South");
    }

    public NMRResultView(DefaultNMRMoleculeViewer viewer) {
        this.setLayout(new BorderLayout());
        this.moleculeViewer = viewer;
        this.initMoleculeViewer();
        this.add((Component)this.getMainSplitPane(), "Center");
        this.add((Component)this.getStatusBar(), "South");
    }

    private TextStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new TextStatusBar(new int[]{10, 20, 20, -1, 10});
        }
        return this.statusBar;
    }

    private DefaultNMRMoleculeViewer getMoleculeViewer() {
        if (this.moleculeViewer == null) {
            this.moleculeViewer = new DefaultNMRMoleculeViewer();
            this.initMoleculeViewer();
        }
        return this.moleculeViewer;
    }

    private void initMoleculeViewer() {
        this.getMoleculeViewer().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("atomHovered")) {
                    int index = (Integer)evt.getNewValue();
                    if (index == -1) {
                        NMRResultView.this.getMoleculeViewer().removeColorMark(NMRResultView.this.hoverColor);
                    } else {
                        NMRResultView.this.setHighlight(index);
                    }
                } else if (evt.getPropertyName().equals("atomClicked")) {
                    int markIndex = (Integer)evt.getNewValue();
                    NMRResultView.this.setSelection(SpectrumUtility.getMultipletFor(markIndex, NMRResultView.this.spectrum));
                } else if (evt.getPropertyName().equals(NMRResultView.PROPERTY_KEY_MOLECULE) && NMRResultView.this.molecule != (Molecule)evt.getNewValue()) {
                    NMRResultView.this.setUpPrediction((Molecule)evt.getNewValue(), NMRResultView.this.predictionType);
                }
                NMRResultView.this.getStatusBar().setComponentAt(0, "Nucleus: " + (NMRResultView.this.predictionType == NMRSpectrum.Nucleus.H1 ? "1H" : "13C"));
            }
        });
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.getChart().setPreferredSize(new Dimension(700, 300));
            this.mainSplitPane = new JSplitPane(1, true, this.getMoleculePane(), this.getChart());
            this.mainSplitPane.setResizeWeight(0.3);
            this.mainSplitPane.setDoubleBuffered(true);
            this.mainSplitPane.setContinuousLayout(true);
        }
        return this.mainSplitPane;
    }

    private NMRChartComponent getChart() {
        if (this.chart == null) {
            this.chart = new NMRChartComponent();
            this.chart.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("mouseLocation".equals(evt.getPropertyName())) {
                        Point2D.Double point = (Point2D.Double)evt.getNewValue();
                        StringBuilder builder = new StringBuilder("X = ");
                        builder.append(SpectrumUtility.FORMATTER.format(point.getX()));
                        builder.append(" ");
                        builder.append(NMRResultView.this.spectrum.getUnit().toString());
                        builder.append("; Y = ");
                        builder.append(SpectrumUtility.FORMATTER.format(point.getY()));
                        NMRResultView.this.getStatusBar().setComponentAt(3, builder.toString());
                    } else if ("selection".equals(evt.getPropertyName())) {
                        NMRResultView.this.setSelection((Multiplet)evt.getNewValue());
                    }
                }
            });
        }
        return this.chart;
    }

    private JSplitPane getMoleculePane() {
        if (this.moleculePane == null) {
            this.getMoleculeViewer().setPreferredSize(new Dimension(300, 300));
            this.moleculePane = new JSplitPane(0, true, this.getMoleculeViewer(), this.getInfoArea());
            this.moleculePane.setResizeWeight(0.5);
            this.moleculePane.setDoubleBuffered(true);
            this.moleculePane.setContinuousLayout(true);
        }
        return this.moleculePane;
    }

    private NMRInfoPane getInfoArea() {
        if (this.infoArea == null) {
            this.infoArea = new NMRInfoPane();
            this.infoArea.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selection".equals(evt.getPropertyName())) {
                        int atomIndex = (Integer)evt.getNewValue();
                        NMRResultView.this.setSelection(SpectrumUtility.getMultipletFor(atomIndex, NMRResultView.this.spectrum));
                    }
                }
            });
        }
        return this.infoArea;
    }

    public void setMolecule(Molecule molecule) {
        this.setMolecule(molecule, this.predictionType);
    }

    public boolean setMolecule(Molecule molecule, NMRSpectrum.Nucleus type) {
        if (molecule != null) {
            Molecule result = this.setUpPrediction(molecule, type);
            if (result == null) {
                return false;
            }
            this.getMoleculeViewer().setMolecule(result);
        }
        return true;
    }

    private Molecule setUpPrediction(Molecule molecule, NMRSpectrum.Nucleus type) {
        this.predictionType = type;
        Molecule last = this.molecule;
        this.molecule = molecule;
        try {
            NMRCalculator calculator = new NMRCalculator();
            calculator.setNucleus(type);
            calculator.setMolecule(molecule);
            calculator.setCoupled(this.coupling);
            this.spectrum = calculator.calculate();
            this.spectrum.setImplicitHydrogenMode(this.implicitHmode);
            if (this.spectrum.getAtomIndexes() == null || this.spectrum.getAtomIndexes().isEmpty()) {
                return null;
            }
            this.multiplets = this.spectrum.getMultiplets();
            this.getChart().setSource(this.spectrum, this.multiplets);
            this.getInfoArea().setSpectrum(this.spectrum, this.multiplets);
            molecule = this.spectrum.getMolecule();
            this.firePropertyChange(PROPERTY_KEY_MOLECULE, last, molecule);
            this.getStatusBar().setComponentAt(1, "Unit: " + this.spectrum.getUnit().toString());
            this.getStatusBar().setComponentAt(2, "Frequency: " + this.spectrum.getFrequency());
        }
        catch (LicenseException exception) {
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "License error", 0);
        }
        return molecule;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    private void setSelection(Multiplet multiplet) {
        this.getInfoArea().select(multiplet);
        this.getMoleculeViewer().removeColorMarks();
        this.getMoleculeViewer().markAtoms(multiplet, this.highlightColor);
        this.chart.select(multiplet);
        this.selected = multiplet;
    }

    private void setHighlight(int atomIndex) {
        Multiplet multiplet = SpectrumUtility.getMultipletFor(atomIndex, this.spectrum);
        if (multiplet != null) {
            this.getMoleculeViewer().markAtoms(multiplet, this.hoverColor);
        }
    }

    public void setCoupling(boolean coupling) {
        this.coupling = coupling;
        if (this.molecule != null && this.molecule.getAtomCount() > 0) {
            this.spectrum.setCouplingNeeded(coupling);
            this.getChart().reload();
            this.setSelection(this.selected);
        }
    }

    public void setMeasurementUnit(NMRSpectrum.Unit type) {
        if (type != this.spectrum.getUnit()) {
            if (type == NMRSpectrum.Unit.Hz) {
                this.setDecimalCount(0);
            } else {
                this.setDecimalCount(2);
            }
            this.spectrum.setUnit(type);
            if (this.getReferenceSpectrum() != null) {
                this.getReferenceSpectrum().setUnit(type);
            }
            this.getInfoArea().setSpectrum(this.spectrum, this.multiplets);
            this.getChart().reload();
            this.setSelection(this.selected);
            this.getStatusBar().setComponentAt(1, "Unit: " + this.spectrum.getUnit().toString());
        }
    }

    public void setImplicitHMode(boolean mode) {
        if (mode != this.implicitHmode) {
            this.spectrum.setImplicitHydrogenMode(mode);
            this.implicitHmode = mode;
            this.setMolecule(this.molecule);
        }
    }

    public void setFrequency(double frequency) {
        this.spectrum.setFrequency(frequency);
        this.getChart().reload();
        this.setSelection(this.selected);
        this.getStatusBar().setComponentAt(2, "Frequency: " + frequency);
    }

    public double getFrequency() {
        return this.spectrum.getFrequency();
    }

    public void exportJCAMP(String path) {
        try {
            SpectrumUtility.exportJCAMP(this.spectrum, path);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "The selected file could not be exported!", "Export error", 0);
        }
    }

    public void importJCAMP(String path) {
        try {
            MeasuredNMRSpectrum reference = SpectrumUtility.importJCAMP(path);
            if (this.spectrum.getUnit() != reference.getUnit()) {
                reference.setUnit(this.spectrum.getUnit());
            }
            this.getChart().setReferenceSpectrum(reference);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "The selected file could not be imported!", "Import error", 0);
        }
    }

    public void export(String path, String format2, String propertyName) {
        try {
            SpectrumUtility.export(this.spectrum, path, format2, propertyName);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "The selected file could not be exported!", "Export error", 0);
        }
    }

    public void removeReferenceSpectrum() {
        this.getChart().setReferenceSpectrum(null);
    }

    public void setInformationType(NMRChartComponent.InformationType type) {
        switch (type) {
            case ATOM_NUMBER: {
                this.getMoleculeViewer().setAtomNumbersVisible(true);
                break;
            }
            default: {
                this.getMoleculeViewer().setAtomNumbersVisible(false);
            }
        }
        this.getChart().setInformationType(type);
    }

    public void setIntegralFunctionVisible(boolean visible) {
        this.getChart().setIntegralFunctionVisible(visible);
        this.setSelection(this.selected);
    }

    public void setHighlightFollowing(boolean following) {
        this.getChart().setHighlightFollowing(following);
        this.setSelection(this.selected);
    }

    public void zoomIn() {
        this.getChart().zoomIn();
    }

    public void zoomOut() {
        this.getChart().zoomOut();
    }

    public void resetZoom() {
        this.getChart().resetZoom();
    }

    public void setRenderMode(DataSet.ValueType mode) {
        this.getChart().setRenderMode(mode);
        this.setSelection(this.selected);
    }

    public void setZoomType(GuidelineChartComponent.ZoomType type) {
        this.getChart().setZoomType(type);
    }

    public MeasuredNMRSpectrum getReferenceSpectrum() {
        return this.chart.getReferenceSpectrum();
    }

    public void setMultipletSelection(boolean multipletBased) {
        this.chart.setMultipletSelection(multipletBased);
    }

    public NMRSpectrum.Nucleus getNucleusType() {
        return this.predictionType;
    }

    public void setReferenceInformationType(NMRChartComponent.InformationType type) {
        this.getChart().setReferenceInformationType(type);
    }

    public void setSpectrumColor(Color color) {
        this.getChart().setSpectrumColor(color);
    }

    public void setHighlightColor(Color color) {
        this.getChart().setHighlightColor(color);
    }

    public void setReferenceColor(Color color) {
        this.getChart().setReferenceColor(color);
    }

    public Color getHighlightColor() {
        return this.getChart().getHighlightColor();
    }

    public Color getReferenceColor() {
        return this.getChart().getReferenceColor();
    }

    public Color getSpectrumColor() {
        return this.getChart().getSpectrumColor();
    }

    public void setDecimalCount(int count) {
        SpectrumUtility.setFormatter(count);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        switch (pageIndex) {
            case 0: {
                double locationY = pageFormat.getImageableY();
                Graphics2D g2d = (Graphics2D)graphics.create();
                String title = "NMR Prediction report";
                g2d.setFont(g2d.getFont().deriveFont(14));
                g2d.drawString(title, (int)((pageFormat.getImageableWidth() - (double)g2d.getFontMetrics().stringWidth(title)) / 2.0), (int)locationY + g2d.getFontMetrics().getMaxAscent());
                g2d.setFont(g2d.getFont().deriveFont(10));
                g2d.setFont(g2d.getFont().deriveFont(0));
                g2d.drawString("Nucleus: " + this.getNucleusType().toString(), 10, (int)(locationY += (double)(g2d.getFontMetrics().getHeight() + 10)) + g2d.getFontMetrics().getMaxAscent());
                g2d.drawString("Frequency: " + this.getFrequency(), 10, (int)(locationY += (double)(g2d.getFontMetrics().getHeight() + 10)) + g2d.getFontMetrics().getMaxAscent());
                g2d.drawString("Unit: " + this.spectrum.getUnit().toString(), 10, (int)(locationY += (double)(g2d.getFontMetrics().getHeight() + 10)) + g2d.getFontMetrics().getMaxAscent());
                g2d.translate((pageFormat.getImageableWidth() - (double)this.getMoleculeViewer().getWidth()) / 2.0, locationY += (double)(g2d.getFontMetrics().getHeight() + 10));
                this.getMoleculeViewer().setDoubleBuffered(false);
                this.getMoleculeViewer().print(g2d);
                this.getMoleculeViewer().setDoubleBuffered(true);
                g2d.dispose();
                break;
            }
            case 1: {
                Graphics2D g2d = (Graphics2D)graphics.create();
                g2d.translate((pageFormat.getImageableWidth() - (double)this.getChart().getWidth()) / 2.0, pageFormat.getImageableY());
                this.getChart().setDoubleBuffered(false);
                this.getChart().print(g2d);
                this.getChart().setDoubleBuffered(true);
                g2d.dispose();
                break;
            }
            case 2: {
                Graphics2D g2d = (Graphics2D)graphics.create();
                g2d.translate((pageFormat.getImageableWidth() - (double)this.getInfoArea().getWidth()) / 2.0, pageFormat.getImageableY());
                this.getInfoArea().setDoubleBuffered(false);
                this.getInfoArea().print(g2d);
                this.getInfoArea().setDoubleBuffered(true);
                g2d.dispose();
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    public void exportPDF(String path, Rectangle pageSize, boolean keepViewSettings) {
        try {
            PDFReporter reporter = keepViewSettings ? new PDFReporter(this.moleculeViewer, this.chart.getPreview(), this.chart.getDisplay(), this.spectrum, pageSize) : new PDFReporter(this.spectrum, pageSize);
            reporter.report(path, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyToClipBoard(ComponentType couplinginfo) {
        switch (couplinginfo) {
            case ATOMINFO: {
                this.getInfoArea().copyAtomInfoToClipBoard();
                break;
            }
            case COUPLINGINFO: {
                this.getInfoArea().copyCouplingInfoToClipBoard();
                break;
            }
            case MULTIPLET: {
                this.getInfoArea().copyMultipletInfoToClipBoard();
                break;
            }
            case MOLECULE: {
                ClipboardHandler.putImageToClipboard(this.getMoleculeViewer().getImage());
                break;
            }
            case GUIDE: {
                ClipboardHandler.putImageToClipboard(this.getChart().getPreview().getImage());
                break;
            }
            case SPECTRUM: {
                ClipboardHandler.putImageToClipboard(this.getChart().getDisplay().getImage());
                break;
            }
        }
    }

    public static enum ComponentType {
        SPECTRUM,
        MOLECULE,
        COUPLINGINFO,
        ATOMINFO,
        MULTIPLET,
        GUIDE;

    }
}

