/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.report;

import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.NMRDataSource;
import chemaxon.calculations.ui.nmr.SpectrumUtility;
import chemaxon.calculations.ui.nmr.prediction.Drawable;
import chemaxon.calculations.ui.nmr.prediction.NMRAtomInfo;
import chemaxon.calculations.ui.nmr.prediction.NMRCouplingInfo;
import chemaxon.calculations.ui.nmr.prediction.NMRMultipletInfo;
import chemaxon.chart.dataset.DataSource;
import chemaxon.chart.dataset.Interval;
import chemaxon.chart.gui.DefaultChartPainter;
import chemaxon.chart.model.Chart;
import chemaxon.chart.model.ChartEntry;
import chemaxon.chart.model.Transformer;
import chemaxon.chart.renderer.ChartRenderer;
import chemaxon.chart.renderer.RenderOptions;
import chemaxon.marvin.MolPrinter;
import chemaxon.marvin.version.VersionInfo;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class PDFReporter {
    private Color integralColor = Color.pink;
    private Color spectrumColor = Color.darkGray;
    private String title = "NMR Prediction report";
    private Drawable molecule;
    private Drawable spectrumDisplay;
    private Drawable spectrumPreview;
    private NMRSpectrum spectrum;
    private Document document;
    private PdfWriter writer;
    private static final String LOGO_PATH = "chemaxon/icons/marvin/calculations/nmr/chemaxon_logo.png";
    private static final Font BASE_FONT = new Font(1, 12.0f, 0);
    private static final int IMAGE_DISTANCE = 4;
    private static final int PAGE_END = 20;
    private java.awt.Image logo;
    private Rectangle pageSize = PageSize.A4;
    private int pageCount = 0;
    private Chart chartDisplay;
    private Chart chartPreview;
    private static final double DISPLAY_RATIO = 0.75;
    private static final int IMAGE_WIDTH = 1200;
    private static final double PREVIEW_RATIO = 0.1;

    public PDFReporter(NMRSpectrum spectrum, Rectangle pageSize) {
        this.pageSize = pageSize;
        URL sourceimage = ClassLoader.getSystemResource(LOGO_PATH);
        try {
            this.logo = ImageIO.read(sourceimage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.spectrum = spectrum;
        NMRDataSource dataSource = new NMRDataSource(spectrum);
        this.chartPreview = new Chart();
        this.chartPreview.add(new ChartEntry((DataSource)dataSource, true, this.spectrumColor));
        this.chartDisplay = new Chart();
        this.chartDisplay.setAxisXName(spectrum.getUnit().toString());
        this.chartDisplay.setAxisYName("Intensity");
        this.chartDisplay.add(new ChartEntry((DataSource)dataSource, true, this.spectrumColor));
        this.chartDisplay.add(new ChartEntry(SpectrumUtility.createAtomIndexChart(spectrum), false, Color.red));
        this.chartDisplay.add(new ChartEntry(SpectrumUtility.createIntegralDatasource(dataSource), false, this.integralColor));
    }

    public PDFReporter(Drawable molecule, Drawable preview, Drawable display, NMRSpectrum spectrum, Rectangle pageSize) {
        this.pageSize = pageSize;
        URL sourceimage = ClassLoader.getSystemResource(LOGO_PATH);
        try {
            this.logo = ImageIO.read(sourceimage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.spectrum = spectrum;
        this.molecule = molecule;
        this.spectrumDisplay = display;
        this.spectrumPreview = preview;
    }

    public void report(final String path, final boolean openWhenReady) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DataOutputStream output = new DataOutputStream(outputStream);
                    PDFReporter.this.document = new Document();
                    PDFReporter.this.document.setPageSize(PDFReporter.this.pageSize);
                    PDFReporter.this.document.setMargins(PDFReporter.this.document.leftMargin(), PDFReporter.this.document.rightMargin(), PDFReporter.this.document.topMargin() + 10.0f, PDFReporter.this.document.bottomMargin());
                    PDFReporter.this.writer = PdfWriter.getInstance((Document)PDFReporter.this.document, (OutputStream)output);
                    PDFReporter.this.writer.setStrictImageSequence(true);
                    PDFReporter.this.writer.setViewerPreferences(256);
                    PDFReporter.this.document.addAuthor("ChemAxon NMR Predictor");
                    PDFReporter.this.document.addCreationDate();
                    PDFReporter.this.document.addTitle(PDFReporter.this.title);
                    PDFReporter.this.writer.setPageEvent((PdfPageEvent)new ReportEvent());
                    PDFReporter.this.writer.open();
                    PDFReporter.this.document.open();
                    if (PDFReporter.this.spectrum != null) {
                        float width = PDFReporter.this.document.getPageSize().getWidth() - PDFReporter.this.document.leftMargin() - PDFReporter.this.document.rightMargin();
                        PDFReporter.this.document.add((Element)PDFReporter.this.getMolecule(width * 0.6f));
                        PDFReporter.this.document.add((Element)PDFReporter.this.getSpectrum(width));
                        PDFReporter.this.document.add((Element)PDFReporter.this.getMultipletTable());
                        PDFReporter.this.document.add((Element)PDFReporter.this.getAtomTable());
                        PDFReporter.this.document.add((Element)PDFReporter.this.getCouplingTable());
                    }
                    PDFReporter.this.pageCount = PDFReporter.this.writer.getPageNumber();
                    PDFReporter.this.document.close();
                    PDFReporter.this.writer.close();
                    this.addPageCounts(path, outputStream, new FileOutputStream(path));
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (openWhenReady) {
                    try {
                        Desktop.getDesktop().open(new File(path));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            private void addPageCounts(String path2, ByteArrayOutputStream input, FileOutputStream output) throws IOException, DocumentException {
                byte[] content = input.toByteArray();
                PdfReader reader = new PdfReader(content);
                PDFReporter.this.document = new Document();
                PDFReporter.this.writer = PdfWriter.getInstance((Document)PDFReporter.this.document, (OutputStream)output);
                PDFReporter.this.document.open();
                PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
                for (int i = 1; i <= PDFReporter.this.pageCount; ++i) {
                    PdfContentByte contentByte = stamper.getOverContent(i);
                    ColumnText.showTextAligned((PdfContentByte)contentByte, (int)1, (Phrase)PDFReporter.this.getFooter(i), (float)((PDFReporter.this.document.right() - PDFReporter.this.document.left()) / 2.0f + PDFReporter.this.document.leftMargin()), (float)(PDFReporter.this.document.bottom() - 20.0f), (float)0.0f);
                }
                stamper.close();
            }
        });
    }

    private Paragraph getMultipletTable() {
        Paragraph result = new Paragraph();
        NMRMultipletInfo pane = new NMRMultipletInfo();
        pane.setSpectrum(this.spectrum, this.spectrum.getMultiplets());
        Paragraph text = new Paragraph("Shift list", BASE_FONT);
        text.setAlignment(0);
        result.add((Object)text);
        result.add((Object)this.getTable(pane));
        return result;
    }

    private Paragraph getCouplingTable() {
        Paragraph result = new Paragraph();
        NMRCouplingInfo pane = new NMRCouplingInfo();
        pane.setSpectrum(this.spectrum, this.spectrum.getMultiplets());
        Paragraph text = new Paragraph("Coupling constants", BASE_FONT);
        text.setAlignment(0);
        result.add((Object)text);
        result.add((Object)this.getTable(pane));
        return result;
    }

    private Paragraph getAtomTable() {
        Paragraph result = new Paragraph();
        NMRAtomInfo pane = new NMRAtomInfo();
        pane.setSpectrum(this.spectrum, this.spectrum.getMultiplets());
        Paragraph text = new Paragraph("Atom list", BASE_FONT);
        text.setAlignment(0);
        result.add((Object)text);
        result.add((Object)this.getTable(pane));
        return result;
    }

    private PdfPTable getTable(JTable pane) {
        int i;
        TableModel model = pane.getModel();
        PdfPTable table = new PdfPTable(model.getColumnCount());
        table.setHeaderRows(1);
        for (i = 0; i < model.getColumnCount(); ++i) {
            PdfPCell h1 = new PdfPCell((Phrase)new Paragraph(model.getColumnName(i)));
            h1.setGrayFill(0.7f);
            table.addCell(h1);
        }
        for (i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                table.addCell(model.getValueAt(i, j).toString());
            }
        }
        return table;
    }

    private Paragraph getMolecule(float width) {
        Paragraph result = new Paragraph();
        Paragraph text = new Paragraph("Compound structure", BASE_FONT);
        Image moleculeImage = null;
        moleculeImage = this.molecule == null ? this.getImage(this.createMolecule(), width) : this.getImage(this.molecule, width);
        moleculeImage.setAlignment(1);
        result.add((Object)text);
        result.add((Object)moleculeImage);
        return result;
    }

    private Image getImage(Drawable drawable, float width) {
        return this.getImage(drawable.getImage(), width);
    }

    private Image getImage(java.awt.Image image, float width) {
        Image result = null;
        try {
            result = Image.getInstance((java.awt.Image)image, null);
            result.scaleToFit(width, width);
            result.setBorder(15);
            result.setBorderWidth(0.75f);
            result.setBorderColor(Color.black);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void drawBaseLines() {
        PdfContentByte hcb = this.writer.getDirectContent();
        hcb.setLineWidth(1.0f);
        hcb.setGrayStroke(0.0f);
        hcb.moveTo(this.document.left(), this.document.top() + 4.0f);
        hcb.lineTo(this.document.right(), this.document.top() + 4.0f);
        hcb.stroke();
        hcb.moveTo(this.document.left(), this.document.bottom());
        hcb.lineTo(this.document.right(), this.document.bottom());
        hcb.stroke();
    }

    private Phrase getFooter(int current) {
        Phrase footer = new Phrase("Page " + current + " of " + this.pageCount);
        return footer;
    }

    private void printHeader(PdfContentByte contentByte) {
        try {
            Image logoImage = Image.getInstance((java.awt.Image)this.logo, null);
            contentByte.addImage(logoImage, 26.0f, 0.0f, 0.0f, 24.0f, this.document.left(), this.document.top() + 8.0f);
            ColumnText.showTextAligned((PdfContentByte)contentByte, (int)0, (Phrase)new Phrase("ChemAxon NMR Predictor - Version " + VersionInfo.MARVIN_VERSION), (float)(this.document.left() + 26.0f + 4.0f), (float)(this.document.top() + 16.0f + 8.0f), (float)0.0f);
            ColumnText.showTextAligned((PdfContentByte)contentByte, (int)0, (Phrase)new Phrase("Date: " + new Date().toString()), (float)(this.document.left() + 26.0f + 4.0f), (float)(this.document.top() + 8.0f), (float)0.0f);
            Paragraph base = new Paragraph("Spectrum type: ", BASE_FONT);
            base.add((Object)this.getValueOf(this.spectrum.getNucleusType()));
            ColumnText.showTextAligned((PdfContentByte)contentByte, (int)2, (Phrase)base, (float)this.document.right(), (float)(this.document.top() + 16.0f + 8.0f), (float)0.0f);
            ColumnText.showTextAligned((PdfContentByte)contentByte, (int)2, (Phrase)new Phrase("Measurement frequency: " + this.spectrum.getFrequency() + " MHz", BASE_FONT), (float)this.document.right(), (float)(this.document.top() + 8.0f), (float)0.0f);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private Paragraph getSpectrum(float width) {
        Paragraph result = new Paragraph();
        Paragraph text = new Paragraph("Spectrum", BASE_FONT);
        result.add((Object)text);
        if (this.spectrumPreview == null) {
            this.createPreview((int)width);
        }
        Image previewImage = this.getImage(this.spectrumPreview, width);
        previewImage.setAlignment(1);
        result.add((Object)previewImage);
        if (this.spectrumDisplay == null) {
            this.createDisplay((int)width);
        }
        Image displayImage = this.getImage(this.spectrumDisplay, width);
        displayImage.setAlignment(1);
        result.add((Object)displayImage);
        return result;
    }

    private Phrase getValueOf(NMRSpectrum.Nucleus nucleus) {
        Phrase result = new Phrase();
        float textrise = 6.0f;
        switch (nucleus) {
            case C13: {
                Chunk number = new Chunk("13");
                number.setTextRise(textrise);
                number.getFont().setSize(8.0f);
                result.add((Object)number);
                result.add((Object)new Chunk("C"));
                break;
            }
            case H1: {
                Chunk number = new Chunk("1");
                number.setTextRise(textrise);
                number.getFont().setSize(8.0f);
                result.add((Object)number);
                result.add((Object)new Chunk("H"));
                break;
            }
            default: {
                result.add((Object)new Chunk(nucleus.name()));
            }
        }
        return result;
    }

    private void createDisplay(int width) {
        Chart chart = this.chartDisplay;
        final BufferedImage image = new BufferedImage(1200, 900, 1);
        RenderOptions options = new RenderOptions(chart.getRange(), chart.getDomain());
        options.setVerticalPixels(new Interval((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(900)));
        options.setHorizontalPixels(new Interval((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1200)));
        options.setHorizontalGridlineVisible(true);
        options.setVerticalGridlineVisible(true);
        options.setVerticalScalingVisible(true);
        options.setHorizontalScalingVisible(true);
        options.setGridlineColor(new Color(220, 220, 220));
        Transformer transformer = new Transformer(options);
        transformer.setReverseDomain(true);
        ChartRenderer renderer = new ChartRenderer(options, transformer);
        DefaultChartPainter painter = new DefaultChartPainter();
        painter.paintChart(image.getGraphics(), options, chart, renderer, transformer);
        this.spectrumDisplay = new Drawable(){

            @Override
            public java.awt.Image getImage() {
                return image;
            }
        };
    }

    private void createPreview(int width) {
        Chart chart = this.chartPreview;
        final BufferedImage image = new BufferedImage(1200, 120, 2);
        RenderOptions options = new RenderOptions(chart.getRange(), chart.getDomain());
        options.setVerticalPixels(new Interval((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(120)));
        options.setHorizontalPixels(new Interval((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1200)));
        options.setHorizontalGridlineVisible(false);
        options.setVerticalGridlineVisible(false);
        options.setVerticalScalingVisible(false);
        options.setHorizontalScalingVisible(false);
        options.setGridlineColor(new Color(220, 220, 220));
        Transformer transformer = new Transformer(options);
        transformer.setReverseDomain(true);
        ChartRenderer renderer = new ChartRenderer(options, transformer);
        DefaultChartPainter painter = new DefaultChartPainter();
        painter.paintChart(image.getGraphics(), options, chart, renderer, transformer);
        this.spectrumPreview = new Drawable(){

            @Override
            public java.awt.Image getImage() {
                return image;
            }
        };
    }

    private java.awt.Image createMolecule() {
        BufferedImage target = new BufferedImage(1200, 900, 3);
        MolPrinter printer = new MolPrinter();
        printer.setBackgroundColor(Color.white);
        printer.setDisplayQuality(1);
        printer.setAtomNumbersVisible(true);
        Dimension size = new Dimension(target.getWidth(), target.getHeight());
        printer.setMol(this.spectrum.getMolecule());
        printer.setScale(printer.maxScale(size));
        printer.setTransparent(true);
        printer.paint(target.getGraphics(), new java.awt.Rectangle(size));
        return target;
    }

    private class ReportEvent
    implements PdfPageEvent {
        private ReportEvent() {
        }

        public void onStartPage(PdfWriter arg0, Document arg1) {
        }

        public void onSectionEnd(PdfWriter arg0, Document arg1, float arg2) {
        }

        public void onSection(PdfWriter arg0, Document arg1, float arg2, int arg3, Paragraph arg4) {
        }

        public void onParagraphEnd(PdfWriter arg0, Document arg1, float arg2) {
        }

        public void onParagraph(PdfWriter arg0, Document arg1, float arg2) {
        }

        public void onOpenDocument(PdfWriter arg0, Document arg1) {
        }

        public void onGenericTag(PdfWriter arg0, Document arg1, Rectangle arg2, String arg3) {
        }

        public void onEndPage(PdfWriter arg0, Document arg1) {
            PdfContentByte hcb = PDFReporter.this.writer.getDirectContent();
            PDFReporter.this.printHeader(hcb);
            PDFReporter.this.drawBaseLines();
        }

        public void onCloseDocument(PdfWriter arg0, Document document) {
        }

        public void onChapterEnd(PdfWriter arg0, Document arg1, float arg2) {
        }

        public void onChapter(PdfWriter arg0, Document arg1, float arg2, Paragraph arg3) {
        }
    }
}

