/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculator;

import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CalculatorInputValidator {
    private static List<Result> defaultCheckList = Arrays.asList(Result.QUERY, Result.SRUSGROUP, Result.PSEUDOATOM, Result.MULTICENTER, Result.COORDINATEBOND);
    private static List<Result> fullCheckList = Arrays.asList(Result.QUERY, Result.VALENCE, Result.SRUSGROUP, Result.PSEUDOATOM, Result.MULTICENTER, Result.COORDINATEBOND, Result.RGROUP, Result.STRUCTURE);

    public static List<Result> getErrorList(Molecule mol) {
        return CalculatorInputValidator.getErrorList(mol, true, CalculatorInputValidator.getFullCheckList());
    }

    public static List<Result> getErrorList(Molecule mol, List<Result> checkList) {
        return CalculatorInputValidator.getErrorList(mol, true, checkList);
    }

    public static Result checkMolecule(Molecule mol) {
        List<Result> errorList = CalculatorInputValidator.getErrorList(mol, false, CalculatorInputValidator.getFullCheckList());
        return errorList.isEmpty() ? Result.VALID : errorList.get(0);
    }

    public static Result checkMolecule(Molecule mol, List<Result> checkList) {
        List<Result> errorList = CalculatorInputValidator.getErrorList(mol, false, checkList);
        return errorList.isEmpty() ? Result.VALID : errorList.get(0);
    }

    public static List<Result> getDefaultCheckList() {
        return defaultCheckList;
    }

    public static List<Result> getFullCheckList() {
        return fullCheckList;
    }

    private static List<Result> getErrorList(Molecule mol, boolean getAll, List<Result> checkList) {
        ArrayList<Result> errorList = new ArrayList<Result>();
        if (CalculatorInputValidator.isQuery(mol) && checkList.contains((Object)Result.QUERY)) {
            errorList.add(Result.QUERY);
            if (!getAll) {
                return errorList;
            }
        }
        if (CalculatorInputValidator.isPseudoAtom(mol) && checkList.contains((Object)Result.PSEUDOATOM)) {
            errorList.add(Result.PSEUDOATOM);
            if (!getAll) {
                return errorList;
            }
        }
        if (CalculatorInputValidator.containsSRUSgroup(mol) && checkList.contains((Object)Result.SRUSGROUP)) {
            errorList.add(Result.SRUSGROUP);
            if (!getAll) {
                return errorList;
            }
        }
        if (CalculatorInputValidator.containsMulticenterSgroup(mol) && checkList.contains((Object)Result.MULTICENTER)) {
            errorList.add(Result.MULTICENTER);
            if (!getAll) {
                return errorList;
            }
        }
        if (CalculatorInputValidator.containsCoordinateBond(mol) && checkList.contains((Object)Result.MULTICENTER)) {
            errorList.add(Result.COORDINATEBOND);
            if (!getAll) {
                return errorList;
            }
        }
        if (CalculatorInputValidator.isRgrouped(mol) && checkList.contains((Object)Result.RGROUP)) {
            errorList.add(Result.RGROUP);
            if (!getAll) {
                return errorList;
            }
        }
        if (CalculatorInputValidator.hasValenceError(mol) && checkList.contains((Object)Result.VALENCE)) {
            errorList.add(Result.VALENCE);
            if (!getAll) {
                return errorList;
            }
        }
        return errorList;
    }

    protected static boolean isQuery(Molecule mol) {
        return mol.isQuery();
    }

    protected static boolean isPseudoAtom(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (!mol.getAtom(i).isPseudo()) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsMulticenterSgroup(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            if (mol.getSgroup(i).getType() != 14) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsSRUSgroup(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            if (mol.getSgroup(i).getType() != 2) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsCoordinateBond(MoleculeGraph mol) {
        for (int i = 0; i < mol.getBondCount(); ++i) {
            if (mol.getBond(i).getType() != 9) continue;
            return true;
        }
        return false;
    }

    protected static boolean isRgrouped(Molecule mol) {
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            if (rgmol.getRgroupCount() > 0) {
                return true;
            }
            for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                if (rgmol.getAtom(i).getAtno() != 134) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean hasValenceError(Molecule mol) {
        mol.valenceCheck();
        return mol.hasValenceError() || CriticalErrorCalculation.calculate(mol);
    }

    public static enum Result {
        VALID("Molecule is valid for calculation."),
        QUERY("Calculation result is not defined for query molecules."),
        VALENCE("Result cannot be calculated because molecule has valence error."),
        SRUSGROUP("Calculation result is not defined for molecules with SRU S-groups."),
        PSEUDOATOM("Calculation result is not defined for molecules with pseudo atoms."),
        MULTICENTER("Calculation result is not defined for molecules with multicenter S-groups."),
        COORDINATEBOND("Calculation result is not defined for molecules with coordinate bonds."),
        RGROUP("Calculation result is not defined for molecules with R-groups."),
        STRUCTURE("The input molecule is invalid."),
        NOINPUT("No input molecule is set.");

        String msg = "";

        private Result(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

