/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculator;

import chemaxon.calculator.CalculatorException;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class CalculatorLogger {
    private static final NumberFormat format = new DecimalFormat("0.0");
    private static final String cmdParameterKey = "Command";
    private MolExporter exporter;
    private String cmdParameters;
    private double timeLimit = 0.0;
    private String outFile;
    private String formatWithOpts;
    private Level level = Level.ERROR;
    private static final String SMILEFIELDS = ":-T_MOLCOUNT:TIME:WARNING:ERROR";
    private boolean logTime = false;

    public CalculatorLogger() {
        this(System.err, "sdf:-a");
    }

    public CalculatorLogger(String formatWithOpts) {
        this(System.err, formatWithOpts);
    }

    public CalculatorLogger(String logFile, String formatWithOpts) {
        this.outFile = logFile;
        if (formatWithOpts.endsWith("smiles")) {
            formatWithOpts = formatWithOpts + SMILEFIELDS;
        }
        this.formatWithOpts = formatWithOpts;
    }

    public CalculatorLogger(OutputStream out, String formatWithOpts) {
        if (formatWithOpts.endsWith("smiles")) {
            formatWithOpts = formatWithOpts + SMILEFIELDS;
        }
        this.exporter = CalculatorLogger.getExporter(out, formatWithOpts);
    }

    public void setLogLevel(String level) {
        for (Level l : Level.values()) {
            if (!level.equalsIgnoreCase(l.toString())) continue;
            this.level = l;
            return;
        }
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    public void setCommandLineParameters(String[] params) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            builder.append(params[i]);
            if (i >= params.length - 1) continue;
            builder.append(" ");
        }
        this.cmdParameters = builder.toString();
    }

    public void log(Molecule mol, String command, String ... logData) {
        for (int i = 0; i < logData.length; ++i) {
            logData[i] = command + " : " + logData[i];
        }
        this.log(mol, Level.WARNING, command, logData);
    }

    public void log(Molecule mol, String command, Throwable ex) {
        if (ex instanceof PluginException || ex instanceof CalculatorException) {
            this.log(mol, command, ex.getMessage());
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        this.log(mol, Level.ERROR, command, sw.toString());
    }

    public void log(Molecule mol, String command, double time) {
        if (time >= this.timeLimit && this.timeLimit >= 0.0 && this.logTime) {
            this.log(mol, Level.TIME, command, format.format(time));
        }
    }

    protected void log(Molecule molecule, Level logLevel, String command, String ... logData) {
        Molecule mol = molecule.cloneMoleculeWithDocument();
        if (logLevel.getLevel() > this.level.getLevel()) {
            return;
        }
        if (this.cmdParameters != null) {
            mol.setProperty(cmdParameterKey, this.cmdParameters);
        }
        for (int i = 0; i < logData.length; ++i) {
            mol.setProperty(this.getPropertyName(logLevel, i), logData[i]);
        }
        try {
            this.getExporter().write(mol);
            this.getExporter().flush();
        }
        catch (MolExportException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public void close() {
        if (this.exporter != null) {
            try {
                this.exporter.close(this.outFile == null ? 2 : 1);
            }
            catch (MolExportException e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected String getPropertyName(Level level, int index) {
        return index > 0 ? level.toString() + index : level.toString();
    }

    public void setTimeLimit(double limit) {
        this.setTimeLogging(true);
        this.timeLimit = limit;
    }

    public void setTimeLogging(boolean on) {
        this.logTime = on;
    }

    private MolExporter getExporter() {
        if (this.exporter == null) {
            try {
                this.exporter = this.outFile == null ? CalculatorLogger.getExporter(System.err, this.formatWithOpts) : CalculatorLogger.getExporter(new FileOutputStream(this.outFile), this.formatWithOpts);
            }
            catch (FileNotFoundException e) {
                e.getMessage();
            }
        }
        return this.exporter;
    }

    private static MolExporter getExporter(OutputStream out, String formatWithOpts) {
        try {
            return new MolExporter(out, formatWithOpts);
        }
        catch (MolExportException e) {
            System.err.println(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    public static enum Level {
        WARNING(20),
        ERROR(10),
        TIME(-2),
        OFF(0);

        int level;

        private Level(int level) {
            this.level = level;
        }

        int getLevel() {
            return this.level;
        }
    }
}

