/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculator;

import chemaxon.calculator.Calculator;
import chemaxon.calculator.CalculatorFormatter;
import chemaxon.calculator.CalculatorLogger;
import chemaxon.calculator.Command;
import chemaxon.calculator.Parameter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CalculatorRunner {
    private static final String CALCULATORLISTPATH = "/chemaxon/calculator/calculatorlist.properties";
    private HashMap<String, String> parameters = new HashMap();
    private boolean needHeader = true;
    private static Hashtable<String, Class<? extends Calculator>> allCommands;
    private Calculator calculator;
    private static HashMap<String, Method> commandCache;

    public static String getHelpText(Class<? extends Calculator> calcClass, String command) {
        int indent = 25;
        StringBuilder text = new StringBuilder();
        Command c = CalculatorRunner.getCommand(calcClass, command).getAnnotation(Command.class);
        String description = CalculatorRunner.getDescription(c, command);
        Parameter cld = calcClass.getAnnotation(Parameter.class);
        String classDescription = cld == null ? "" : cld.description() + ": ";
        text.append(classDescription).append(command).append("\n\n").append(description).append("\n\n");
        int index = 0;
        for (int i = 0; i < c.name().length; ++i) {
            if (!c.name()[i].equalsIgnoreCase(command)) continue;
            index = i;
            break;
        }
        text.append("Usage:\ncxcalc [general options] [input files/strings] " + command + " [" + command + " options] [input files/strings]\n\n");
        text.append(command + " options: \n");
        Field[] allFields = CalculatorRunner.getAllParameterField(calcClass, c, index);
        text.append(CalculatorRunner.getHelpText(calcClass, indent));
        for (int i = 0; i < allFields.length; ++i) {
            if (!allFields[i].isAnnotationPresent(Parameter.class)) continue;
            int idx = index < c.defaults().length ? index : 0;
            CalculatorParameter param = new CalculatorParameter(allFields[i], calcClass, c.defaults()[idx]);
            text.append(param.getHelpText(indent));
        }
        text.append("\nExample: cxcalc ").append(command).append(" ").append(c.example()).append("\n");
        return text.toString();
    }

    private static String getHelpText(Class<? extends Calculator> calcClass, int indentCount) {
        try {
            CalculatorParameter helpParam = new CalculatorParameter(CalculatorParameter.class.getDeclaredField("help"), calcClass);
            return helpParam.getHelpText(indentCount);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return "";
    }

    private static String getDescription(Command cmd, String name) {
        for (int i = 0; i < cmd.name().length; ++i) {
            if (!cmd.name()[i].equalsIgnoreCase(name)) continue;
            if (cmd.description().length > i) {
                return cmd.description()[i];
            }
            return cmd.description()[0];
        }
        return cmd.description()[0];
    }

    public static CalculatorParameter[] getAllParameter(Class<? extends Calculator> calcClass, String command) {
        Command cmd = CalculatorRunner.getCommand(calcClass, command).getAnnotation(Command.class);
        int index = 0;
        for (int i = 0; i < cmd.name().length; ++i) {
            if (!cmd.name()[i].equalsIgnoreCase(command)) continue;
            index = i;
            break;
        }
        Field[] paramFields = CalculatorRunner.getAllParameterField(calcClass, cmd, index);
        CalculatorParameter[] params = new CalculatorParameter[paramFields.length];
        for (int i = 0; i < paramFields.length; ++i) {
            params[i] = new CalculatorParameter(paramFields[i], calcClass);
        }
        return params;
    }

    private static Field[] getAllParameterField(Class<?> calcClass, Command command, int index) {
        Field[] allFields = CalculatorRunner.getAllFields(calcClass);
        ArrayList<Field> relevants = new ArrayList<Field>();
        index = index < command.options().length ? index : 0;
        Collection<String> fixParameterNames = CalculatorRunner.getParamNames(command.options()[index]);
        List<String> excludeList = Arrays.asList(command.exclude());
        for (int i = 0; i < allFields.length; ++i) {
            Parameter param = allFields[i].getAnnotation(Parameter.class);
            if (param == null || excludeList.contains(param.name()) || excludeList.contains(param.shortName()) || fixParameterNames.contains(param.name()) || fixParameterNames.contains(param.shortName())) continue;
            relevants.add(allFields[i]);
        }
        return relevants.toArray(new Field[0]);
    }

    private static Collection<String> getParamNames(String optionString) {
        HashSet<String> optionNames = new HashSet<String>();
        String[] options = optionString.split(" ");
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0) continue;
            optionNames.add(options[i].substring(0, options[i].indexOf(61)));
        }
        return optionNames;
    }

    public void setParameter(String key, String value) {
        for (int i = 0; i < 2; ++i) {
            if (!key.startsWith("-")) continue;
            key = key.substring(1);
        }
        this.calculator = null;
        this.parameters.put(key, value);
    }

    public CalculatorFormatter.FormattedResult[] runCommand(String command, Class<? extends Calculator> calcClass, CalculatorLogger logger, Molecule ... molecule) {
        Method method;
        CalculatorFormatter.FormattedResult[] result = new CalculatorFormatter.FormattedResult[molecule.length];
        Calculator calculator = this.getCalculator(command, calcClass);
        if (calculator == null) {
            return null;
        }
        if (logger != null) {
            calculator.setLogger(logger);
        }
        if ((method = CalculatorRunner.getCommand(calcClass, command)) == null) {
            return null;
        }
        for (int i = 0; i < result.length; ++i) {
            calculator.setMolecule(molecule[i]);
            try {
                result[i] = calculator.getFormatter().convert(method.invoke((Object)calculator, new Object[0]));
                this.needHeader = calculator.getFormatter().needHeader();
                continue;
            }
            catch (IllegalArgumentException e) {
                return new CalculatorFormatter.FormattedResult[]{new CalculatorFormatter.FormattedResult("")};
            }
            catch (IllegalAccessException e) {
                return new CalculatorFormatter.FormattedResult[]{new CalculatorFormatter.FormattedResult("")};
            }
            catch (InvocationTargetException e) {
                return new CalculatorFormatter.FormattedResult[]{new CalculatorFormatter.FormattedResult("")};
            }
        }
        return result;
    }

    private Calculator getCalculator(String command, Class<? extends Calculator> calcClass) {
        if (this.calculator != null && !this.calculator.getClass().equals(calcClass)) {
            this.calculator = null;
        }
        if (this.calculator != null) {
            return this.calculator;
        }
        try {
            this.calculator = calcClass.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            return null;
        }
        Method method = CalculatorRunner.getCommand(calcClass, command);
        if (method == null) {
            return null;
        }
        this.setParameters(this.calculator, method.getAnnotation(Command.class), command);
        return this.calculator;
    }

    private static Method getCommand(Class<? extends Calculator> calcClass, String commandName) {
        Command command;
        int i;
        Method method = commandCache.get(commandName);
        if (method != null) {
            return method;
        }
        Method[] allMethods = calcClass.getMethods();
        for (i = 0; i < allMethods.length; ++i) {
            command = allMethods[i].getAnnotation(Command.class);
            if (command == null || !CalculatorRunner.contains(command.name(), commandName)) continue;
            commandCache.put(commandName, allMethods[i]);
            return allMethods[i];
        }
        allMethods = calcClass.getDeclaredMethods();
        for (i = 0; i < allMethods.length; ++i) {
            command = allMethods[i].getAnnotation(Command.class);
            if (command == null || !CalculatorRunner.contains(command.name(), commandName)) continue;
            allMethods[i].setAccessible(true);
            commandCache.put(commandName, allMethods[i]);
            return allMethods[i];
        }
        return null;
    }

    public String getHeader(String command, Class<? extends Calculator> calcClass) {
        try {
            Calculator calculator = calcClass.newInstance();
            Method method = CalculatorRunner.getCommand(calcClass, command);
            if (method != null) {
                this.setParameters(calculator, method.getAnnotation(Command.class), command);
            }
            return calculator.getFormatter().getHeader(command);
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        return command;
    }

    public boolean needHeader() {
        return this.needHeader;
    }

    private void setParameters(Calculator calculator, Command command, String cmd) {
        HashMap<String, String> options = CalculatorRunner.getOptionParameters(command, cmd);
        HashMap<String, String> defaults = CalculatorRunner.getDefaultParameters(command, cmd);
        Field[] allFields = CalculatorRunner.getAllFields(calculator.getClass());
        CalculatorRunner.setParamValues(defaults, allFields, calculator);
        CalculatorRunner.setParamValues(this.parameters, allFields, calculator);
        CalculatorRunner.setParamValues(options, allFields, calculator);
    }

    protected static void setParamValues(HashMap<String, String> parameters, Field[] fieldList, Calculator calculator) {
        for (int i = 0; i < fieldList.length; ++i) {
            Parameter annotation = fieldList[i].getAnnotation(Parameter.class);
            String name = null;
            if (annotation == null || !parameters.containsKey(name = annotation.name()) && !parameters.containsKey(name = annotation.shortName())) continue;
            CalculatorParameter param = new CalculatorParameter(fieldList[i], calculator);
            param.setValue(CalculatorRunner.convertFromString(parameters.get(name), fieldList[i].getType()));
        }
    }

    private static HashMap<String, String> getOptionParameters(Command command, String cmd) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (int i = 0; i < command.name().length; ++i) {
            if (!command.name()[i].equalsIgnoreCase(cmd)) continue;
            String[] optionList = command.options()[i < command.options().length ? i : 0].split(" ");
            for (int j = 0; j < optionList.length; ++j) {
                String[] option = optionList[j].split("=", 2);
                if (option.length <= 1) continue;
                defaults.put(option[0], option[1]);
            }
            break;
        }
        return defaults;
    }

    protected static HashMap<String, String> getDefaultParameters(Command command, String cmd) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (int i = 0; i < command.name().length; ++i) {
            if (!command.name()[i].equalsIgnoreCase(cmd)) continue;
            String[] defaultList = command.defaults()[i < command.defaults().length ? i : 0].split(" ");
            for (int j = 0; j < defaultList.length; ++j) {
                String[] option = defaultList[j].split("=", 2);
                if (option.length <= 1) continue;
                defaults.put(option[0], option[1]);
            }
            break;
        }
        return defaults;
    }

    private static boolean contains(String[] list, String node) {
        if (list == null || node == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!node.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    private static Object convertFromString(String value, Class<?> type) {
        if (value != null) {
            if (String.class.equals(type)) {
                return value;
            }
            if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
                Integer i = new Integer(0);
                try {
                    i = Integer.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                return i;
            }
            if (Long.class.equals(type) || Long.TYPE.equals(type)) {
                Long l = new Long(0L);
                try {
                    l = Long.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                return l;
            }
            if (Float.class.equals(type) || Float.TYPE.equals(type)) {
                Float f = new Float(0.0f);
                try {
                    f = Float.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                return f;
            }
            if (Double.class.equals(type) || Double.TYPE.equals(type)) {
                Double d = new Double(0.0);
                try {
                    d = Double.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                return d;
            }
            if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                return Boolean.valueOf(value);
            }
            if (Molecule.class.equals(type)) {
                try {
                    return MolImporter.importMol(value);
                }
                catch (MolFormatException e) {
                    return new Molecule();
                }
            }
            if (type.isEnum()) {
                Field[] allFields = type.getDeclaredFields();
                for (int i = 0; i < allFields.length; ++i) {
                    Parameter param = allFields[i].getAnnotation(Parameter.class);
                    if (param == null || !param.name().equalsIgnoreCase(value)) continue;
                    try {
                        return allFields[i].get(type);
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                    catch (IllegalAccessException e) {
                        break;
                    }
                }
                ?[] constants = type.getEnumConstants();
                for (int i = 0; i < constants.length; ++i) {
                    if (!constants[i].toString().equalsIgnoreCase(value)) continue;
                    return constants[i];
                }
            }
        }
        return null;
    }

    public static Hashtable<String, Class<? extends Calculator>> getAllCommands() {
        if (allCommands == null) {
            allCommands = new Hashtable();
            Properties properties = new Properties();
            try {
                properties.load(CalculatorRunner.class.getResourceAsStream(CALCULATORLISTPATH));
            }
            catch (FileNotFoundException e) {
                return allCommands;
            }
            catch (IOException e) {
                return allCommands;
            }
            Set<Object> commands = properties.keySet();
            for (Object cmd : commands) {
                try {
                    Class<?> calcType = Class.forName((String)properties.get(cmd));
                    allCommands.put((String)cmd, calcType);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        return allCommands;
    }

    public static Hashtable<String, List<String>> getCommandGroups() {
        Hashtable<String, List<String>> commandGroups = new Hashtable<String, List<String>>();
        Hashtable<String, Class<? extends Calculator>> commands = CalculatorRunner.getAllCommands();
        for (String cmd : commands.keySet()) {
            Command annotation = CalculatorRunner.getCommand(commands.get(cmd), cmd).getAnnotation(Command.class);
            List<String> names = Arrays.asList(annotation.name());
            List<String> alreadyAdded = commandGroups.get(annotation.group().toString());
            if (alreadyAdded == null) {
                ArrayList<String> nameList = new ArrayList<String>();
                nameList.addAll(names);
                commandGroups.put(annotation.group().toString(), nameList);
                continue;
            }
            if (alreadyAdded.containsAll(names)) continue;
            alreadyAdded.addAll(names);
        }
        return commandGroups;
    }

    private static Field[] getAllFields(Class<?> calcClass) {
        if (calcClass.equals(Object.class)) {
            return new Field[0];
        }
        Field[] declaredFields = calcClass.getDeclaredFields();
        Field[] inheritedFields = CalculatorRunner.getAllFields(calcClass.getSuperclass());
        Field[] allFields = new Field[declaredFields.length + inheritedFields.length];
        System.arraycopy(inheritedFields, 0, allFields, 0, inheritedFields.length);
        System.arraycopy(declaredFields, 0, allFields, inheritedFields.length, declaredFields.length);
        return allFields;
    }

    private static Method[] getAllMethods(Class<?> calcClass) {
        if (calcClass.equals(Object.class)) {
            return new Method[0];
        }
        Method[] declaredMethods = calcClass.getDeclaredMethods();
        Method[] inheritedMethods = CalculatorRunner.getAllMethods(calcClass.getSuperclass());
        Method[] allMethods = new Method[declaredMethods.length + inheritedMethods.length];
        System.arraycopy(inheritedMethods, 0, allMethods, 0, inheritedMethods.length);
        System.arraycopy(declaredMethods, 0, allMethods, inheritedMethods.length, declaredMethods.length);
        return allMethods;
    }

    private static Method getFittingMethod(Class<? extends Calculator> calcClass, String name) {
        Method[] allMethods = CalculatorRunner.getAllMethods(calcClass);
        for (int i = 0; i < allMethods.length; ++i) {
            if (!allMethods[i].getName().equals(name)) continue;
            return allMethods[i];
        }
        return null;
    }

    static {
        commandCache = new HashMap();
    }

    public static class CalculatorParameter {
        final Field property;
        Parameter annotation;
        Method setter;
        Calculator calculator;
        String defaultValue;
        @Parameter(name="help", shortName="h", description="this help message")
        static String help = "";

        protected CalculatorParameter(Field property, Class<? extends Calculator> calcClass) {
            this.property = property;
            this.annotation = this.property.getAnnotation(Parameter.class);
            try {
                this.calculator = calcClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        protected CalculatorParameter(Field property, Class<? extends Calculator> calcClass, String defaults) {
            this(property, calcClass);
            String[] defValues = defaults.split(" ");
            for (int i = 0; i < defValues.length; ++i) {
                String key;
                int index = defValues[i].indexOf(61);
                String string = key = index > -1 && index < defValues[i].length() - 1 ? defValues[i].substring(0, index) : "";
                if (!key.equalsIgnoreCase(this.annotation.name()) && !key.equalsIgnoreCase(this.annotation.shortName())) continue;
                this.defaultValue = defValues[i].substring(index + 1);
                break;
            }
        }

        protected CalculatorParameter(Field property, Calculator calculator) {
            this.property = property;
            this.annotation = this.property.getAnnotation(Parameter.class);
            this.calculator = calculator;
        }

        protected String getHelpText(int indentCount) {
            StringBuilder shortName = new StringBuilder();
            if (this.getShortname().length() > 0) {
                shortName.append("    -").append(this.getShortname()).append(" ");
            } else {
                shortName.append("       ");
            }
            shortName.append(" ");
            StringBuffer fullName = new StringBuffer();
            fullName.append("--").append(this.getName());
            String description = this.getDescription();
            String defaultValue = this.defaultValue;
            if (defaultValue == null) {
                String string = defaultValue = this.getValue() == null ? "null" : this.getValue().toString();
            }
            if (defaultValue.length() > 0) {
                defaultValue = " (default: " + defaultValue + ")";
            }
            shortName.append(fullName);
            StringBuilder text = new StringBuilder(description);
            text.append(defaultValue);
            return CalculatorParameter.format(shortName, text, indentCount) + "\n";
        }

        private static String format(StringBuilder header, StringBuilder text, int indent) {
            int lineLen = 79;
            header.append(" ");
            while (header.length() < indent) {
                header.append(" ");
            }
            String spaces = " ";
            for (int i = 1; i < indent; ++i) {
                spaces = spaces + " ";
            }
            header.append((CharSequence)text);
            for (int index = lineLen; index < header.length(); index += lineLen + 1) {
                int tmpind = header.lastIndexOf(" ", index);
                if (tmpind > indent) {
                    index = tmpind;
                    header.delete(index, index + 1);
                }
                header.insert(index, "\n" + spaces);
            }
            return header.toString();
        }

        public String getName() {
            return this.annotation.name();
        }

        public String getShortname() {
            return this.annotation.shortName();
        }

        private String getDescription() {
            String description = this.annotation.description();
            if (description.length() > 0) {
                String innerDescription = this.getInnerDescription("  ");
                return description + innerDescription;
            }
            return this.getInnerDescription("");
        }

        private String getInnerDescription(String indent) {
            Class<?> c = this.property.getType();
            Field[] fields = c.getDeclaredFields();
            StringBuilder text = new StringBuilder();
            boolean empty = true;
            for (int i = 0; i < fields.length; ++i) {
                Parameter param = fields[i].getAnnotation(Parameter.class);
                if (param == null) continue;
                if (!empty) {
                    text.append(" | ");
                }
                String name = param.name().length() == 0 ? fields[i].getName() : param.name();
                text.append(name);
                if (param.description().length() > 0) {
                    text.append("(" + param.description() + ")");
                }
                empty = false;
            }
            return empty ? "" : indent + "[" + text.toString() + "]";
        }

        private Object getValue() {
            this.property.setAccessible(true);
            try {
                return this.property.get(this.calculator);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }

        private void setValue(Object value) {
            if (this.setter == null) {
                String name = this.property.getName().substring(0, 1).toUpperCase() + this.property.getName().substring(1);
                try {
                    this.setter = CalculatorRunner.getFittingMethod(this.calculator.getClass(), "set" + name);
                    this.setter.setAccessible(true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.setter.invoke((Object)this.calculator, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.getName() + " " + super.toString();
        }

        public int getParameterCount() {
            if (this.property.getType().equals(Boolean.class) || this.property.getType().equals(Boolean.TYPE)) {
                return 1;
            }
            return 2;
        }
    }
}

