/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.SgroupCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="Abbreviated Group Checker", localMenuName="Abbreviated Group", description="Detects abbreviated groups", noErrorMessage="No abbreviated group found", oneErrorMessage="abbreviated group found", moreErrorMessage="abbreviated groups found", actionStringToken="abbrevgroup", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.AbbreviatedGroupCheckerEditor")
public class AbbreviatedGroupChecker
extends AbstractStructureChecker {
    public static final String PROPERTY_KEY_EXPANDED = "expanded";
    public static final String PROPERTY_KEY_CONTRACTED = "contracted";
    public static final String PROPERTY_KEY_SEARCH_CONTRACTED = "searchContracted";
    public static final String PROPERTY_KEY_SEARCH_EXPANDED = "searchExpanded";
    @Persistent(alias="contracted")
    private boolean searchContracted = true;
    @Persistent(alias="expanded")
    private boolean searchExpanded = true;

    public AbbreviatedGroupChecker() {
        super(StructureCheckerErrorType.ABBREVIATED_GROUP);
    }

    public AbbreviatedGroupChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.ABBREVIATED_GROUP);
        this.searchContracted = Boolean.parseBoolean(params.get(PROPERTY_KEY_CONTRACTED));
        this.searchExpanded = Boolean.parseBoolean(params.get(PROPERTY_KEY_EXPANDED));
    }

    public boolean isSearchContracted() {
        return this.searchContracted;
    }

    public boolean isSearchExpanded() {
        return this.searchExpanded;
    }

    @Override
    protected Molecule expandMolecule(Molecule molecule, Map<MolAtom, MolAtom> atomMap, Map<MolBond, MolBond> bondMap) {
        return molecule;
    }

    @Override
    protected void convertResult(Molecule originalMolecule, Molecule expandedMolecule, StructureCheckerResult result, Map<MolAtom, MolAtom> atomMap, Map<MolBond, MolBond> bondMap) {
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getSgroupCount() == 0) {
            return null;
        }
        ArrayList<Sgroup> expandedGroups = new ArrayList<Sgroup>();
        ArrayList<Sgroup> contractedGroups = new ArrayList<Sgroup>();
        for (int i = 0; i < molecule.getSgroupCount(); ++i) {
            Sgroup sgroup = molecule.getSgroup(i);
            if (this.searchContracted && sgroup instanceof SuperatomSgroup && ((SuperatomSgroup)sgroup).isContracted()) {
                contractedGroups.add(sgroup);
                continue;
            }
            if (!this.searchExpanded || !(sgroup instanceof SuperatomSgroup) || !((SuperatomSgroup)sgroup).isExpanded()) continue;
            expandedGroups.add(sgroup);
        }
        if (expandedGroups.isEmpty() && contractedGroups.isEmpty()) {
            return null;
        }
        ArrayList<Sgroup> allGroups = new ArrayList<Sgroup>(expandedGroups);
        allGroups.addAll(contractedGroups);
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (int i = 0; i < molecule.getAtomArray().length; ++i) {
            if (!(molecule.getAtom(i) instanceof SgroupAtom)) continue;
            atoms.add(molecule.getAtom(i));
        }
        List<MolAtom> molAtoms = Arrays.asList(molecule.getAtomArray());
        for (Sgroup sgroup : expandedGroups) {
            this.addSgroupAtomsToList(atoms, molAtoms, sgroup);
        }
        for (Sgroup sgroup : contractedGroups) {
            this.addSgroupAtomsToList(atoms, molAtoms, sgroup);
        }
        boolean onlyContractedFound = !contractedGroups.isEmpty() && expandedGroups.isEmpty();
        boolean onlyExpandedFound = contractedGroups.isEmpty() && !expandedGroups.isEmpty();
        StructureCheckerErrorType errorType = this.calcErrorType(onlyContractedFound, onlyExpandedFound);
        return atoms.isEmpty() ? null : new SgroupCheckerResult(this, atoms, new ArrayList<MolBond>(), errorType, molecule, this.getErrorDescription(allGroups.size()), allGroups, this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    private StructureCheckerErrorType calcErrorType(boolean onlyContractedFound, boolean onlyExpandedFound) {
        StructureCheckerErrorType errorType = onlyContractedFound ? StructureCheckerErrorType.ABBREVIATED_GROUP_WITH_ONLY_CONTRACTED : (onlyExpandedFound ? StructureCheckerErrorType.ABBREVIATED_GROUP_WITH_ONLY_EXPANDED : this.errorType);
        return errorType;
    }

    private void addSgroupAtomsToList(List<MolAtom> atoms, List<MolAtom> molAtoms, Sgroup sgroup) {
        List<MolAtom> sgroupAtoms = Arrays.asList(sgroup.getAtomArray());
        for (MolAtom molAtom : sgroupAtoms) {
            int i = molAtoms.indexOf(molAtom);
            if (i == -1) continue;
            atoms.add(molAtom);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AbbreviatedGroupChecker other = (AbbreviatedGroupChecker)obj;
        return this.searchContracted == other.searchContracted && this.searchExpanded == other.searchExpanded;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * (this.searchContracted ? 1 : 0) + 31 * (this.searchExpanded ? 2 : 0);
    }

    public void setSearchExpanded(boolean searchExpanded) {
        boolean oldValue = this.searchExpanded;
        this.searchExpanded = searchExpanded;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_EXPANDED, oldValue, searchExpanded);
    }

    public void setSearchContracted(boolean searchContracted) {
        boolean oldValue = this.searchContracted;
        this.searchContracted = searchContracted;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_CONTRACTED, oldValue, searchContracted);
    }
}

