/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="Alias Checker", localMenuName="Atom Alias", description="Detects atom aliases", noErrorMessage="No atom alias found", oneErrorMessage="atom alias found", moreErrorMessage="atom aliases found", actionStringToken="alias")
public class AliasChecker
extends AtomChecker {
    public AliasChecker() {
        super(StructureCheckerErrorType.ALIAS);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        return !atom.isPseudo() && atom.getAliasstr() != null;
    }

    @Override
    protected StructureCheckerResult createResult(Molecule molecule, List<MolAtom> atoms) {
        if (atoms.isEmpty()) {
            return null;
        }
        Map<String, Molecule> defaultAbbrevgroups = null;
        try {
            defaultAbbrevgroups = StructureCheckerHelper.getDefaultAbbrevgroups();
        }
        catch (IOException e) {
            defaultAbbrevgroups = new HashMap<String, Molecule>();
        }
        boolean hasAliasCouldBeConvertedToAtom = false;
        boolean hasAliasCouldBeConvertedToGroup = false;
        for (MolAtom molAtom : atoms) {
            if (molAtom.getAliasstr().equals("*") || PeriodicSystem.getAtomicNumber(molAtom.getAliasstr()) != -1) {
                hasAliasCouldBeConvertedToAtom = true;
            }
            if (!defaultAbbrevgroups.containsKey(molAtom.getAliasstr())) continue;
            hasAliasCouldBeConvertedToGroup = true;
        }
        StructureCheckerErrorType errorType = hasAliasCouldBeConvertedToAtom && !hasAliasCouldBeConvertedToGroup ? StructureCheckerErrorType.ALIAS_ATOM : (hasAliasCouldBeConvertedToGroup && !hasAliasCouldBeConvertedToAtom ? StructureCheckerErrorType.ALIAS_GROUP : (hasAliasCouldBeConvertedToAtom && hasAliasCouldBeConvertedToGroup ? StructureCheckerErrorType.ALIAS : StructureCheckerErrorType.ALIAS_NONE));
        return new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), errorType, molecule, this.getErrorDescription(atoms.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

