/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.AromaticityCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

@CheckerInfo(name="Aromaticity Error Checker", localMenuName="Aromaticity Error", description="Detects incorrect aromaticities", noErrorMessage="No aromaticity error found", oneErrorMessage="invalid aromatic bond found", moreErrorMessage="invalid aromatic bonds found", severity=CheckerSeverity.ERROR, actionStringToken="aromaticity", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.AromaticityErrorCheckerEditor")
public class AromaticityErrorChecker
extends AbstractStructureChecker {
    public static final String PROPERTY_KEY_TYPE = "type";
    public static final String PROPERTY_KEY_AROM_TYPE = "aromType";
    private int type;
    @Persistent(alias="type")
    private String aromType;

    public AromaticityErrorChecker() {
        super(StructureCheckerErrorType.AROMATICITY);
        this.type = 2;
        this.aromType = "general";
    }

    public AromaticityErrorChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.AROMATICITY);
        this.aromType = params.get(PROPERTY_KEY_TYPE);
        this.type = "basic".equals(this.aromType) ? 1 : ("loose".equals(this.aromType) ? 3 : 2);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        Molecule copy1 = molecule.cloneMolecule();
        ArrayList<Integer> bondsToCheck = new ArrayList<Integer>();
        ArrayList<Integer> bondsToSkip = new ArrayList<Integer>();
        for (int i = 0; i < copy1.getBondCount(); ++i) {
            if (copy1.getBond(i).getType() != 4) continue;
            if (this.notPartOfConnectedMulticenter(copy1, copy1.getBond(i))) {
                bondsToCheck.add(i);
                continue;
            }
            bondsToSkip.add(i);
        }
        Molecule copy2 = molecule.cloneMolecule();
        copy1.dearomatize();
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (int i = 0; i < copy1.getBondCount(); ++i) {
            if (bondsToSkip.contains(i) || copy1.getBond(i).getType() != 4) continue;
            bonds.add(molecule.getBond(i));
        }
        copy1.aromatize(this.type);
        int[] grinv1 = new int[copy1.getAtomCount()];
        int[] grinv2 = new int[copy2.getAtomCount()];
        copy1.getGrinv(grinv1);
        copy2.getGrinv(grinv2);
        if (!Arrays.equals(grinv1, grinv2) || copy1.getGrinvCC() != copy2.getGrinvCC()) {
            for (int i = 0; i < copy1.getBondArray().length; ++i) {
                if (bondsToSkip.contains(i) || !bondsToCheck.contains(i) || copy1.getBond(i).getType() == copy2.getBond(i).getType()) continue;
                bonds.add(molecule.getBond(i));
            }
        }
        return bonds.isEmpty() ? null : new AromaticityCheckerResult((StructureChecker)this, new ArrayList<MolAtom>(), bonds, molecule, this.getErrorDescription(bonds.size()), this.type, this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    private boolean notPartOfConnectedMulticenter(Molecule mol, MolBond bond) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            MulticenterSgroup group;
            if (!(mol.getSgroup(i) instanceof MulticenterSgroup) || !Arrays.asList((group = (MulticenterSgroup)mol.getSgroup(i)).getAtomArray()).contains(bond.getAtom1()) || !Arrays.asList(group.getAtomArray()).contains(bond.getAtom2())) continue;
            for (int j = 0; j < group.getCentralAtom().getBondCount(); ++j) {
                if (group.getCentralAtom().getBond(j).getType() != 9) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this.type == ((AromaticityErrorChecker)obj).type;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        int oldValue = this.type;
        this.type = type;
        switch (type) {
            case 1: {
                this.aromType = "basic";
                break;
            }
            case 3: {
                this.aromType = "loose";
                break;
            }
            default: {
                this.aromType = "general";
            }
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_TYPE, oldValue, type);
    }

    public String getAromType() {
        return this.aromType;
    }
}

