/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.BondChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Map;

@CheckerInfo(name="Bond Length Checker", localMenuName="Bond Length", description="Detects unpreferred bond lengths in structural formulas", noErrorMessage="No wrong bond length found", oneErrorMessage="bond found with wrong length", moreErrorMessage="bonds found with wrong length", actionStringToken="bondlength", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.BondLengthCheckerEditor")
public class BondLengthChecker
extends BondChecker {
    public static final String PROPERTY_KEY_SHORT = "short";
    public static final String PROPERTY_KEY_LONG = "long";
    public static final String PROPERTY_KEY_DETECT_TOO_LONG_BONDS = "detectTooLongBonds";
    public static final String PROPERTY_KEY_DETECT_TOO_SHORT_BONDS = "detectTooShortBonds";
    @Persistent(alias="long")
    private boolean detectTooLongBonds;
    @Persistent(alias="short")
    private boolean detectTooShortBonds;

    public void setDetectTooLongBonds(boolean detectTooLongBonds) {
        this.detectTooLongBonds = detectTooLongBonds;
    }

    public void setDetectTooShortBonds(boolean detectTooShortBonds) {
        this.detectTooShortBonds = detectTooShortBonds;
    }

    public boolean isDetectTooLongBonds() {
        return this.detectTooLongBonds;
    }

    public boolean isDetectTooShortBonds() {
        return this.detectTooShortBonds;
    }

    public BondLengthChecker() {
        super(StructureCheckerErrorType.BOND_LENGTH);
        this.detectTooLongBonds = true;
        this.detectTooShortBonds = true;
    }

    public BondLengthChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.BOND_LENGTH);
        this.detectTooShortBonds = Boolean.parseBoolean(params.get(PROPERTY_KEY_SHORT));
        this.detectTooLongBonds = Boolean.parseBoolean(params.get(PROPERTY_KEY_LONG));
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getDim() == 0 || molecule.getDim() == 3) {
            return null;
        }
        return super.check1(molecule);
    }

    @Override
    protected boolean check(Molecule molecule, MolBond bond) {
        if (bond.getType() == 9) {
            return false;
        }
        double length = bond.getLength();
        if (this.detectTooLongBonds && length > 1.8479999999999999) {
            int[][] sssr = molecule.getSSSR();
            boolean containsAtom1 = false;
            int sssrIndexOfAtom1 = -1;
            boolean containsAtom2 = false;
            int sssrIndexOfAtom2 = -1;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            for (int[] is : sssr) {
                MolAtom neighbourAtom2;
                if (is.length != 5) continue;
                for (int i = 0; i < is.length; ++i) {
                    if (molecule.getAtom(is[i]) == atom1) {
                        containsAtom1 = true;
                        sssrIndexOfAtom1 = i;
                        continue;
                    }
                    if (molecule.getAtom(is[i]) != atom2) continue;
                    containsAtom2 = true;
                    sssrIndexOfAtom2 = i;
                }
                if (!containsAtom1 || !containsAtom2) continue;
                MolAtom neighbourAtom1 = molecule.getAtom(sssrIndexOfAtom1 == 0 ? is[is.length - 1] : is[sssrIndexOfAtom1 - 1]);
                if (neighbourAtom1.equals(atom2)) {
                    neighbourAtom1 = molecule.getAtom(sssrIndexOfAtom1 == is.length - 1 ? is[0] : is[sssrIndexOfAtom1 + 1]);
                }
                if ((neighbourAtom2 = molecule.getAtom(sssrIndexOfAtom2 == 0 ? is[is.length - 1] : is[sssrIndexOfAtom2 - 1])).equals(atom1)) {
                    neighbourAtom2 = molecule.getAtom(sssrIndexOfAtom2 == is.length - 1 ? is[0] : is[sssrIndexOfAtom2 + 1]);
                }
                MolBond neighbourBond1 = atom1.getBondTo(neighbourAtom1);
                MolBond neighbourBond2 = atom2.getBondTo(neighbourAtom2);
                if (neighbourBond1 == null || neighbourBond2 == null || !BondLengthChecker.isOrtogonal(bond, neighbourBond1) || !BondLengthChecker.isOrtogonal(bond, neighbourBond2)) continue;
                return false;
            }
        }
        return this.detectTooShortBonds && length < 1.2320000000000002 || this.detectTooLongBonds && length > 1.8479999999999999;
    }

    private static boolean isOrtogonal(MolBond bond, MolBond bond2) {
        return Math.abs(StructureCheckerHelper.calculateCosAFromScalarMul(bond, bond2)) < 0.02;
    }
}

