/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public abstract class ComponentChecker<E>
extends AbstractStructureChecker {
    public ComponentChecker(StructureCheckerErrorType errorType) {
        super(errorType);
    }

    protected abstract int getComponentCount(Molecule var1);

    protected abstract E getComponent(Molecule var1, int var2);

    protected void initialize() {
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        this.initialize();
        ArrayList<E> componentList = new ArrayList<E>();
        for (int i = 0; i < this.getComponentCount(molecule); ++i) {
            E component = this.getComponent(molecule, i);
            if (!this.check(molecule, component) || componentList.contains(component)) continue;
            componentList.add(component);
        }
        return this.createResult(molecule, componentList);
    }

    protected abstract StructureCheckerResult createResult(Molecule var1, List<E> var2);

    protected abstract boolean check(Molecule var1, E var2);
}

