/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.ExplicitHydrogenResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="Explicit Hydrogen Checker", localMenuName="Explicit Hydrogen", description="Detects various explicit hydrogens", noErrorMessage="No explicit hydrogen found", oneErrorMessage="explicit hydrogen found", moreErrorMessage="explicit hydrogens found", actionStringToken="explicith", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.ExplicitHydrogenCheckerEditor")
public class ExplicitHydrogenChecker
extends AtomChecker {
    public static final String PROPERTY_KEY_LONELY = "lonely";
    public static final String PROPERTY_KEY_CHARGED = "charged";
    public static final String PROPERTY_KEY_MAPPED = "mapped";
    public static final String PROPERTY_KEY_ISOTOPIC = "isotopic";
    public static final String PROPERTY_KEY_RADICAL = "radical";
    public static final String PROPERTY_KEY_WEDGED = "wedged";
    public static final String PROPERTY_KEY_SEARCH_CHARGED = "searchCharged";
    public static final String PROPERTY_KEY_SEARCH_ISOTOPIC = "searchIsotopic";
    public static final String PROPERTY_KEY_SEARCH_LONELY = "searchLonely";
    public static final String PROPERTY_KEY_SEARCH_MAPPED = "searchMapped";
    public static final String PROPERTY_KEY_SEARCH_RADICAL = "searchRadical";
    public static final String PROPERTY_KEY_SEARCH_WEDGED = "searchWedged";
    private int implicitizeFlag;
    @Persistent(alias="lonely")
    private boolean searchLonely;
    @Persistent(alias="charged")
    private boolean searchCharged;
    @Persistent(alias="mapped")
    private boolean searchMapped;
    @Persistent(alias="isotopic")
    private boolean searchIsotopic;
    @Persistent(alias="radical")
    private boolean searchRadical;
    @Persistent(alias="wedged")
    private boolean searchWedged;

    public ExplicitHydrogenChecker() {
        this(true, true, true, true, true, true);
    }

    private ExplicitHydrogenChecker(boolean searchLonely, boolean searchCharged, boolean searchMapped, boolean searchIsotopic, boolean searchRadical, boolean searchWedged) {
        super(StructureCheckerErrorType.EXPLICIT_H);
        this.searchLonely = searchLonely;
        this.searchCharged = searchCharged;
        this.searchMapped = searchMapped;
        this.searchIsotopic = searchIsotopic;
        this.searchRadical = searchRadical;
        this.searchWedged = searchWedged;
        this.setImplicitizeFlag();
    }

    private void setImplicitizeFlag() {
        int flag = 0;
        if (this.searchLonely) {
            flag |= 1;
        }
        if (this.searchCharged) {
            flag |= 4;
        }
        if (this.searchMapped) {
            flag |= 0x10;
        }
        if (this.searchIsotopic) {
            flag |= 2;
        }
        if (this.searchRadical) {
            flag |= 8;
        }
        if (this.searchWedged) {
            flag |= 0x20;
        }
        this.implicitizeFlag = flag;
    }

    public ExplicitHydrogenChecker(Map<String, String> params) {
        this(Boolean.parseBoolean(params.get(PROPERTY_KEY_LONELY)), Boolean.parseBoolean(params.get(PROPERTY_KEY_CHARGED)), Boolean.parseBoolean(params.get(PROPERTY_KEY_MAPPED)), Boolean.parseBoolean(params.get(PROPERTY_KEY_ISOTOPIC)), Boolean.parseBoolean(params.get(PROPERTY_KEY_RADICAL)), Boolean.parseBoolean(params.get(PROPERTY_KEY_WEDGED)));
    }

    public boolean isSearchLonely() {
        return this.searchLonely;
    }

    public boolean isSearchCharged() {
        return this.searchCharged;
    }

    public boolean isSearchMapped() {
        return this.searchMapped;
    }

    public boolean isSearchIsotopic() {
        return this.searchIsotopic;
    }

    public boolean isSearchRadical() {
        return this.searchRadical;
    }

    public boolean isSearchWedged() {
        return this.searchWedged;
    }

    public void setSearchLonely(boolean searchLonely) {
        boolean oldValue = this.searchLonely;
        this.searchLonely = searchLonely;
        this.setImplicitizeFlag();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_LONELY, oldValue, searchLonely);
    }

    public void setSearchCharged(boolean searchCharged) {
        boolean oldValue = this.searchCharged;
        this.searchCharged = searchCharged;
        this.setImplicitizeFlag();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_CHARGED, oldValue, searchCharged);
    }

    public void setSearchMapped(boolean searchMapped) {
        boolean oldValue = this.searchMapped;
        this.searchMapped = searchMapped;
        this.setImplicitizeFlag();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_MAPPED, oldValue, searchMapped);
    }

    public void setSearchIsotopic(boolean searchIsotopic) {
        boolean oldValue = this.searchIsotopic;
        this.searchIsotopic = searchIsotopic;
        this.setImplicitizeFlag();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_ISOTOPIC, oldValue, searchIsotopic);
    }

    public void setSearchRadical(boolean searchRadical) {
        boolean oldValue = this.searchRadical;
        this.searchRadical = searchRadical;
        this.setImplicitizeFlag();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_RADICAL, oldValue, searchRadical);
    }

    public void setSearchWedged(boolean searchWedged) {
        boolean oldValue = this.searchWedged;
        this.searchWedged = searchWedged;
        this.setImplicitizeFlag();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_WEDGED, oldValue, searchWedged);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        return atom.isImplicitizableH(this.implicitizeFlag);
    }

    @Override
    protected StructureCheckerResult createResult(Molecule molecule, List<MolAtom> atoms) {
        return atoms.isEmpty() ? null : new ExplicitHydrogenResult((StructureChecker)this, atoms, new ArrayList<MolBond>(), molecule, this.getErrorDescription(atoms.size()), this.implicitizeFlag, this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this.implicitizeFlag == ((ExplicitHydrogenChecker)obj).implicitizeFlag;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.implicitizeFlag;
    }
}

