/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;

@CheckerInfo(name="Molecule Charge Checker", localMenuName="Molecule Charge", description="Detects non-neutral molecules in which the total charge is not zero", noErrorMessage="No charged molecule found", oneErrorMessage="charged molecule found", moreErrorMessage="charged molecules found", actionStringToken="moleculecharge")
public class MoleculeChargeChecker
extends AbstractStructureChecker {
    public MoleculeChargeChecker() {
        super(StructureCheckerErrorType.MOLECULE_CHARGE);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule instanceof RxnMolecule) {
            return null;
        }
        int charge = 0;
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            int atomCharge = molecule.getAtom(i).getCharge();
            if (atomCharge != 0) {
                atoms.add(molecule.getAtom(i));
            }
            charge += atomCharge;
        }
        return charge == 0 ? null : new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), StructureCheckerErrorType.MOLECULE_CHARGE, molecule, this.getErrorDescription(atoms.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

