/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.BondChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.List;

@CheckerInfo(name="Overlapping Bonds Checker", localMenuName="Overlapping Bonds", description="Detects bonds that are too close to each other", noErrorMessage="No overlapping bond found", oneErrorMessage="overlapping bond found", moreErrorMessage="overlapping bonds found", actionStringToken="overlappingbonds")
public class OverlappingBondsChecker
extends BondChecker {
    public OverlappingBondsChecker() {
        super(StructureCheckerErrorType.OVERLAPPING_BONDS);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getDim() == 0 || molecule.getDim() == 3) {
            return null;
        }
        return super.check1(molecule);
    }

    @Override
    protected boolean check(Molecule molecule, MolBond bond) {
        if (bond.getType() == 9) {
            return false;
        }
        List<MolBond> neighbourBonds = StructureCheckerHelper.createNeighbourBonds(molecule, bond, false);
        for (int j = 0; j < molecule.getBondCount(); ++j) {
            MolBond bond2 = molecule.getBond(j);
            if (bond2.getType() == 9 || bond.equals(bond2) || neighbourBonds.contains(bond2) || !this.isBondCrossing(bond, bond2) && !this.isBondOverlapping(bond, bond2)) continue;
            return true;
        }
        return false;
    }

    private boolean isBondCrossing(MolBond bond1, MolBond bond2) {
        double x1 = bond1.getAtom1().getX();
        double x2 = bond1.getAtom2().getX();
        double x3 = bond2.getAtom1().getX();
        double x4 = bond2.getAtom2().getX();
        double y1 = bond1.getAtom1().getY();
        double y2 = bond1.getAtom2().getY();
        double y3 = bond2.getAtom1().getY();
        double y4 = bond2.getAtom2().getY();
        double denominator = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (denominator == 0.0) {
            return false;
        }
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denominator;
        double interSectionX = x1 + ua * (x2 - x1);
        double interSectionY = y1 + ua * (y2 - y1);
        return Math.min(x1, x2) <= interSectionX && Math.max(x1, x2) >= interSectionX && Math.min(y1, y2) <= interSectionY && Math.max(y1, y2) >= interSectionY && Math.min(x3, x4) <= interSectionX && Math.max(x3, x4) >= interSectionX && Math.min(y3, y4) <= interSectionY && Math.max(y3, y4) >= interSectionY;
    }

    private double distanceAtomBond(MolAtom atom, MolBond bond) {
        double dx = bond.getAtom2().getX() - bond.getAtom1().getX();
        double dy = bond.getAtom2().getY() - bond.getAtom1().getY();
        double dpxx1 = atom.getX() - bond.getAtom1().getX();
        double dpyy1 = atom.getY() - bond.getAtom1().getY();
        if (Double.valueOf(dx).equals(0.0) && Double.valueOf(dx).equals(dy)) {
            return Math.hypot(dpxx1, dpyy1);
        }
        double param = (dpxx1 * dx + dpyy1 * dy) / (dx * dx + dy * dy);
        if (param < 0.0) {
            dx = dpxx1;
            dy = dpyy1;
        } else if (param > 1.0) {
            dx = atom.getX() - bond.getAtom2().getX();
            dy = atom.getY() - bond.getAtom2().getY();
        } else {
            dx = atom.getX() - (bond.getAtom1().getX() + param * dx);
            dy = atom.getY() - (bond.getAtom1().getY() + param * dy);
        }
        return Math.hypot(dx, dy);
    }

    private boolean isBondOverlapping(MolBond bond1, MolBond bond2) {
        double distance = 0.8213333333333335;
        distance = Math.min(distance, this.distanceAtomBond(bond1.getAtom1(), bond2));
        distance = Math.min(distance, this.distanceAtomBond(bond1.getAtom2(), bond2));
        distance = Math.min(distance, this.distanceAtomBond(bond2.getAtom1(), bond1));
        return (distance = Math.min(distance, this.distanceAtomBond(bond2.getAtom2(), bond1))) < 0.8213333333333335;
    }
}

