/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="Pseudo Atom Checker", localMenuName="Pseudo Atom", description="Detects pseudo atoms", noErrorMessage="No pseudo atom found", oneErrorMessage="Pseudo atom found", moreErrorMessage="Pseudo atoms found", actionStringToken="pseudoatom")
public class PseudoAtomChecker
extends AtomChecker {
    public PseudoAtomChecker() {
        super(StructureCheckerErrorType.PSEUDO);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        return atom.isPseudo();
    }

    @Override
    protected StructureCheckerResult createResult(Molecule molecule, List<MolAtom> atoms) {
        if (atoms.isEmpty()) {
            return null;
        }
        Map<String, Molecule> defaultAbbrevgroups = null;
        try {
            defaultAbbrevgroups = StructureCheckerHelper.getDefaultAbbrevgroups();
        }
        catch (IOException e) {
            defaultAbbrevgroups = new HashMap<String, Molecule>();
        }
        boolean hasAtomCanBeConvertedToGroup = false;
        for (MolAtom atom : atoms) {
            if (!defaultAbbrevgroups.containsKey(atom.getAliasstr())) continue;
            hasAtomCanBeConvertedToGroup = true;
        }
        StructureCheckerErrorType errorType = hasAtomCanBeConvertedToGroup ? StructureCheckerErrorType.PSEUDO : StructureCheckerErrorType.PSEUDO_NO_GROUP;
        return new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), errorType, molecule, this.getErrorDescription(atoms.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

