/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@CheckerInfo(name="R-group Attachment Count Error Checker", localMenuName="R-group Attachment Count Error", description="Detects molecules containing inconsistent R-group attachment counts", noErrorMessage="No R-group attachment count errors found", oneErrorMessage="R-group definition member has attachment count error", moreErrorMessage="R-group definition members have attachment count errors", severity=CheckerSeverity.ERROR, actionStringToken="rgroupattachmentcounterror")
public class RgroupAttachmentCountErrorChecker
extends AbstractStructureChecker {
    public RgroupAttachmentCountErrorChecker() {
        super(StructureCheckerErrorType.RGROUP_ATTACHMENT_COUNT_ERROR);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (!(molecule instanceof RgMolecule)) {
            return null;
        }
        HashSet<MolAtom> atoms = new HashSet<MolAtom>();
        HashSet<MolBond> bonds = new HashSet<MolBond>();
        int errorCount = 0;
        RgMolecule rgmol = (RgMolecule)molecule;
        MoleculeGraph union = molecule.getGraphUnion();
        int atomCount = union.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            int rid;
            int index;
            MolAtom atom = union.getAtom(i);
            if (atom.getAtno() != 134 || (index = rgmol.findRgroupIndex(rid = atom.getRgroup())) == -1) continue;
            int ratomBondCount = atom.getBondCount();
            int memberCount = rgmol.getRgroupMemberCount(index);
            for (int j = 0; j < memberCount; ++j) {
                Molecule member = rgmol.getRgroupMember(index, j);
                if (member.getAtomCount() == 1) {
                    if (member.getAtom(0).getAtno() != 138) continue;
                    atoms.add(member.getAtom(0));
                    ++errorCount;
                    continue;
                }
                int attachmentCount = MolImportUtil.countAttachments(member);
                if (attachmentCount >= ratomBondCount) continue;
                RgroupAttachmentCountErrorChecker.addAtomWithBonds(atoms, bonds, atom);
                RgroupAttachmentCountErrorChecker.addAttachments(atoms, member);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            return null;
        }
        return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(atoms), new ArrayList<MolBond>(bonds), StructureCheckerErrorType.RGROUP_ATTACHMENT_COUNT_ERROR, molecule, this.getErrorDescription(errorCount), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    private static void addAtomWithBonds(Set<MolAtom> atoms, Set<MolBond> bonds, MolAtom atom) {
        atoms.add(atom);
        int bondCount = atom.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            bonds.add(atom.getBond(i));
        }
    }

    private static void addAttachments(Set<MolAtom> atoms, Molecule member) {
        MolAtom[] attachments;
        for (MolAtom attachment : attachments = MolImportUtil.getAttachments(member)) {
            atoms.add(attachment);
        }
    }
}

