/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.RgroupCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.util.RgroupInfo;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

@CheckerInfo(name="R-group Attachment Error Checker", localMenuName="R-group Attachment Error", description="Detects molecules containing invalid R-group attachments", noErrorMessage="No R-group attachment errors found", oneErrorMessage="R-group has attachment error", moreErrorMessage="R-groups have attachment errors", severity=CheckerSeverity.ERROR, actionStringToken="rgroupattachmenterror")
public class RgroupAttachmentErrorChecker
extends AbstractStructureChecker {
    public RgroupAttachmentErrorChecker() {
        super(StructureCheckerErrorType.RGROUP_ATTACHMENT_ERROR);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        List<RgroupInfo> info = RgroupInfo.collectRgroups(molecule);
        ArrayList<RgroupInfo> rgroups = new ArrayList<RgroupInfo>();
        if (info == null) {
            return null;
        }
        for (int i = 0; i < info.size(); ++i) {
            List<Integer> attachments = null;
            boolean invalid = false;
            List<MolAtom> atoms = info.get(i).getAtoms();
            for (int j = 0; j < atoms.size(); ++j) {
                if (attachments == null) {
                    attachments = RgroupInfo.collectAttachments(atoms.get(j));
                    continue;
                }
                if (RgroupInfo.compare(attachments, RgroupInfo.collectAttachments(atoms.get(j))) == 0) continue;
                invalid = true;
                break;
            }
            RgroupInfo group = new RgroupInfo(info.get(i).getId());
            if (invalid) {
                for (MolAtom atom : atoms) {
                    group.getAtoms().add(atom);
                }
                for (Molecule member : info.get(i).getMembers()) {
                    group.getMembers().add(member);
                }
                rgroups.add(group);
                break;
            }
            List<Integer> att = attachments;
            for (int j = 0; j < info.get(i).getMembers().size(); ++j) {
                Molecule member = info.get(i).getMembers().get(j);
                if (att == null) {
                    att = RgroupInfo.collectAttachments(member);
                    continue;
                }
                if (RgroupInfo.compare(att, RgroupInfo.collectAttachments(member)) == 0) continue;
                if (attachments == null) {
                    group.getMembers().clear();
                    for (Molecule m : info.get(i).getMembers()) {
                        group.getMembers().add(m);
                    }
                    invalid = true;
                    break;
                }
                group.getMembers().add(member);
                invalid = true;
            }
            if (!invalid) continue;
            if (group.getAtoms().isEmpty()) {
                group.getAtoms().addAll(atoms);
            }
            rgroups.add(group);
        }
        if (rgroups.isEmpty()) {
            return null;
        }
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (RgroupInfo group : rgroups) {
            for (MolAtom atom : group.getAtoms()) {
                atoms.add(atom);
            }
            for (Molecule member : group.getMembers()) {
                int i;
                for (i = 0; i < member.getAtomCount(); ++i) {
                    atoms.add(member.getAtom(i));
                }
                for (i = 0; i < member.getBondCount(); ++i) {
                    bonds.add(member.getBond(i));
                }
            }
        }
        return new RgroupCheckerResult(this, atoms, bonds, rgroups, StructureCheckerErrorType.RGROUP_ATTACHMENT_ERROR, molecule, this.getErrorDescription(rgroups.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

