/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.RgroupCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.util.RgroupInfo;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="R-group Reference Error Checker", localMenuName="R-group Reference Error", description="Detects molecules containing R-group reference errors", noErrorMessage="No invalid R-group reference found", oneErrorMessage="R-group has reference error", moreErrorMessage="R-groups have reference errors", severity=CheckerSeverity.ERROR, actionStringToken="rgroupreferenceerror")
public class RgroupReferenceErrorChecker
extends AbstractStructureChecker {
    private static final String PROPERTY_KEY_SELF_REFERENCE = "selfReference";
    private static final String PROPERTY_KEY_MISSING_RGROUP = "missingRgroup";
    private static final String PROPERTY_KEY_MISSING_RATOM = "missingRatom";
    public static final String PROPERTY_KEY_SEARCH_MISSING_RATOM = "searchMissingRatom";
    public static final String PROPERTY_KEY_SEARCH_MISSING_RGROUP = "searchMissingRgroup";
    public static final String PROPERTY_KEY_SEARCH_SELF_REFERENCE = "searchSelfReference";
    @Persistent(alias="missingRatom")
    private boolean searchMissingRatom = true;
    @Persistent(alias="missingRgroup")
    private boolean searchMissingRgroup = true;
    @Persistent(alias="missingReference")
    private boolean searchSelfReference = true;

    public RgroupReferenceErrorChecker() {
        super(StructureCheckerErrorType.RGROUP_REFERENCE_ERROR);
    }

    public RgroupReferenceErrorChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.RGROUP_REFERENCE_ERROR);
        this.searchMissingRatom = Boolean.parseBoolean(params.get(PROPERTY_KEY_MISSING_RATOM));
        this.searchMissingRgroup = Boolean.parseBoolean(params.get(PROPERTY_KEY_MISSING_RGROUP));
        this.searchSelfReference = Boolean.parseBoolean(params.get(PROPERTY_KEY_SELF_REFERENCE));
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (!(this.searchMissingRatom || this.searchMissingRgroup || this.searchSelfReference)) {
            return null;
        }
        List<RgroupInfo> rgroups = RgroupInfo.collectRgroups(molecule);
        if (rgroups == null) {
            return null;
        }
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        if (this.searchMissingRgroup) {
            for (RgroupInfo group : rgroups) {
                if (group.getId() <= 0 || !group.getMembers().isEmpty()) continue;
                for (MolAtom atom : group.getAtoms()) {
                    atoms.add(atom);
                    group.setValid(false);
                }
            }
        }
        if (this.searchMissingRatom) {
            for (RgroupInfo group : rgroups) {
                if (!group.getAtoms().isEmpty()) continue;
                for (Molecule member : group.getMembers()) {
                    for (int i = 0; i < member.getAtomCount(); ++i) {
                        atoms.add(member.getAtom(i));
                        group.setValid(false);
                    }
                }
            }
        }
        if (this.searchSelfReference) {
            for (int i = 0; i < rgroups.size(); ++i) {
                RgroupInfo group;
                group = rgroups.get(i);
                if (group.getId() <= 0) continue;
                for (int j = 0; j < group.getAtoms().size(); ++j) {
                    MolAtom atom;
                    atom = group.getAtoms().get(j);
                    int nest = group.getNests().get(j);
                    if (nest < 0 || !this.findReference(rgroups, i, nest)) continue;
                    atoms.add(atom);
                    group.setValid(false);
                }
            }
        }
        if (!atoms.isEmpty()) {
            int errorCount = 0;
            for (RgroupInfo group : rgroups) {
                if (group.isValid()) continue;
                ++errorCount;
            }
            return new RgroupCheckerResult(this, atoms, bonds, rgroups, StructureCheckerErrorType.RGROUP_REFERENCE_ERROR, molecule, this.getErrorDescription(errorCount), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        return null;
    }

    private boolean findReference(List<RgroupInfo> groups, int from, int to) {
        RgroupInfo group = groups.get(to);
        for (int i = 0; i < group.getAtoms().size(); ++i) {
            int nest = group.getNests().get(i);
            if (nest == -1) continue;
            if (nest == from) {
                return true;
            }
            return this.findReference(groups, nest, to);
        }
        return false;
    }

    public boolean isSearchMissingRatom() {
        return this.searchMissingRatom;
    }

    public boolean isSearchMissingRgroup() {
        return this.searchMissingRgroup;
    }

    public boolean isSearchSelfReference() {
        return this.searchSelfReference;
    }

    public void setSearchMissingRatom(boolean value) {
        boolean oldValue = this.searchMissingRatom;
        this.searchMissingRatom = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_MISSING_RATOM, oldValue, value);
    }

    public void setSearchMissingRgroup(boolean value) {
        boolean oldValue = this.searchMissingRgroup;
        this.searchMissingRgroup = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_MISSING_RGROUP, oldValue, value);
    }

    public void setSearchSelfReference(boolean value) {
        boolean oldValue = this.searchSelfReference;
        this.searchSelfReference = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_SELF_REFERENCE, oldValue, value);
    }
}

