/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Map;

@CheckerInfo(name="Ring Strain Error Checker", localMenuName="Ring Strain Error", description="Detects strained small rings containing trans or cumulated double bonds, or triple bonds", noErrorMessage="No invalid small ring bond found", oneErrorMessage="invalid small ring bond found", moreErrorMessage="invalid small ring bonds found", severity=CheckerSeverity.ERROR, actionStringToken="ringstrainerror,smallringerror", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.RingStrainErrorCheckerEditor")
public class RingStrainErrorChecker
extends AbstractStructureChecker {
    public static final String PROPERTY_KEY_DETECT_TRANS_DOUBLE_BONDS = "detectTransDoubleBonds";
    public static final String PROPERTY_KEY_DETECT_CUMULATED_DOUBLE_BONDS = "detectCumulatedDoubleBonds";
    public static final String PROPERTY_KEY_DETECT_TRIPLE_BONDS = "detectTripleBonds";
    private boolean detectTransDoubleBonds;
    private boolean detectCumulatedDoubleBonds;
    private boolean detectTripleBonds;

    public RingStrainErrorChecker() {
        super(StructureCheckerErrorType.SMALL_RING);
        this.detectCumulatedDoubleBonds = true;
        this.detectTransDoubleBonds = true;
        this.detectTripleBonds = true;
    }

    public RingStrainErrorChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.SMALL_RING);
        this.detectTransDoubleBonds = Boolean.parseBoolean(params.get("transDoubleBond"));
        this.detectCumulatedDoubleBonds = Boolean.parseBoolean(params.get("cumulatedDoubleBond"));
        this.detectTripleBonds = Boolean.parseBoolean(params.get("tripleBond"));
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        int[][] sssr;
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (int[] ringAtomIndices : sssr = molecule.getSSSR()) {
            if (ringAtomIndices.length >= 8) continue;
            for (int j = 0; j < ringAtomIndices.length; ++j) {
                MolAtom atomA = molecule.getAtom(ringAtomIndices[j]);
                MolAtom atomB = molecule.getAtom(ringAtomIndices[j == ringAtomIndices.length - 1 ? 0 : j + 1]);
                MolBond bond = atomA.getBondTo(atomB);
                MolAtom atom1 = j == 0 ? molecule.getAtom(ringAtomIndices[ringAtomIndices.length - 1]) : molecule.getAtom(ringAtomIndices[j - 1]);
                MolAtom atom4 = molecule.getAtom(ringAtomIndices[(j + 2) % ringAtomIndices.length]);
                if (this.detectTransDoubleBonds && bond.getType() == 2 && bond.calcStereo2(atom1, atom4) == 64 && !bonds.contains(bond)) {
                    bonds.add(bond);
                }
                if (this.detectCumulatedDoubleBonds && bond.getType() == 2 && !bonds.contains(bond) && RingStrainErrorChecker.hasDoubleBondNeighbour(bond)) {
                    bonds.add(bond);
                }
                if (!this.detectTripleBonds || bond.getType() != 3 || bonds.contains(bond)) continue;
                bonds.add(bond);
            }
        }
        if (bonds.isEmpty()) {
            return null;
        }
        return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), bonds, this.errorType, molecule, this.getErrorDescription(bonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    private static boolean hasDoubleBondNeighbour(MolBond bond) {
        int i;
        MolAtom atom = bond.getAtom1();
        for (i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i) == bond || atom.getBond(i).getType() != 2) continue;
            return true;
        }
        atom = bond.getAtom2();
        for (i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i) == bond || atom.getBond(i).getType() != 2) continue;
            return true;
        }
        return false;
    }

    public boolean isDetectTransDoubleBonds() {
        return this.detectTransDoubleBonds;
    }

    public boolean isDetectCumulatedDoubleBonds() {
        return this.detectCumulatedDoubleBonds;
    }

    public boolean isDetectTripleBonds() {
        return this.detectTripleBonds;
    }

    public void setDetectTransDoubleBonds(boolean detectTransDoubleBonds) {
        boolean oldValue = this.detectTransDoubleBonds;
        this.detectTransDoubleBonds = detectTransDoubleBonds;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_DETECT_TRANS_DOUBLE_BONDS, oldValue, detectTransDoubleBonds);
    }

    public void setDetectCumulatedDoubleBonds(boolean detectCumulatedDoubleBonds) {
        boolean oldValue = this.detectCumulatedDoubleBonds;
        this.detectCumulatedDoubleBonds = detectCumulatedDoubleBonds;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_DETECT_CUMULATED_DOUBLE_BONDS, oldValue, detectCumulatedDoubleBonds);
    }

    public void setDetectTripleBonds(boolean detectTripleBonds) {
        boolean oldValue = this.detectTripleBonds;
        this.detectTripleBonds = detectTripleBonds;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_DETECT_TRIPLE_BONDS, oldValue, detectTripleBonds);
    }
}

