/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@CheckerInfo(name="Stereo Care Box Checker", localMenuName="Stereo Care Box", description="Detects stereo search markers in the molecule", noErrorMessage="No stereo care box found", oneErrorMessage="stereo care box found", moreErrorMessage="stereo care boxes found", actionStringToken="stereocarebox")
public class StereoCareBoxChecker
extends AbstractStructureChecker {
    public StereoCareBoxChecker() {
        super(StructureCheckerErrorType.STEREO_CARE_BOX);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        ArrayList<MolBond> foundBonds = new ArrayList<MolBond>();
        for (MolBond bond : molecule.getBondArray()) {
            if ((bond.getFlags() & 0x200) == 0) continue;
            foundBonds.add(bond);
        }
        if (foundBonds.isEmpty()) {
            return null;
        }
        return new DefaultStructureCheckerResult(this, null, foundBonds, StructureCheckerErrorType.STEREO_CARE_BOX, molecule, this.getDescription(), this.getName(), this.getLocalMenuName(), this.getLocalMenuName(), this.getIcon());
    }
}

