/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.OCRErrorChecker;
import chemaxon.checkers.StructureCheckOptions;
import chemaxon.checkers.logger.CheckerLogPattern;
import chemaxon.checkers.logger.CheckerLoggerGroup;
import chemaxon.checkers.logger.PropertyCheckerLogger;
import chemaxon.checkers.logger.StructureCheckerLogger;
import chemaxon.checkers.logger.TemplateBasedLogger;
import chemaxon.checkers.runner.AdvancedCheckerRunner;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.checkers.runner.configuration.reader.ActionStringBasedConfigurationReader;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReader;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.Molecule;
import com.beust.jcommander.JCommander;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public final class StructureCheck {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String HELP_STRING = "StructureCheck " + VersionInfo.MARVIN_MAJOR_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + LINE_SEP + "Licenses of additionally used third party programs can be found in license.html" + LINE_SEP + "Online version: http://www.chemaxon.com/marvin/license.html" + LINE_SEP + "Molecule checker." + LINE_SEP + "Usage:" + LINE_SEP + "  structurecheck [input file(s)/string(s)] -c <config file/string> [options]" + LINE_SEP + LINE_SEP + "General options:" + LINE_SEP + "  -h, --help                         this help page" + LINE_SEP + "  -hc, --help-checker-action         help page of valid checker actions" + LINE_SEP + "  -hf, --help-fixer-action           help page of valid fixer actions" + LINE_SEP + "  -m, --mode <operationmode>         [check|fix]" + LINE_SEP + "                                     mode of the operation (default: check)" + LINE_SEP + "          check                      only check is executed," + LINE_SEP + "                                     does not modify molecules" + LINE_SEP + "          fix                        fix molecules containing structure errors" + LINE_SEP + "                                     whenever possible" + LINE_SEP + "  -x                                 fix mode (deprecated, use --mode fix)" + LINE_SEP + "Input options:" + LINE_SEP + "  -c, --config <filepath|string>     action string configuration" + LINE_SEP + "                                     actions separated by \"..\"," + LINE_SEP + "Output options:" + LINE_SEP + "  -t, --output-type <output type>    [single|separated|accepted|discarded]" + LINE_SEP + "                                     set output type(default: single)" + LINE_SEP + "          single                     both accepted and discarded structures are" + LINE_SEP + "                                     written to the <output path>" + LINE_SEP + "          separated                  accepted structures are written to the" + LINE_SEP + "                                     <output path>, discarded structures are" + LINE_SEP + "                                     written to the <discarded path>" + LINE_SEP + "          accepted                   only accepted structures are" + LINE_SEP + "                                     written to the <output path>" + LINE_SEP + "          discarded                  only discarded structures are" + LINE_SEP + "                                     written to the <discarded path>" + LINE_SEP + "  -o, --output <output path>         output file (default: standard output)" + LINE_SEP + "  -d, --discarded <discarded path>   write molecules with structure error to" + LINE_SEP + "                                     a separate file (default:standard output)" + LINE_SEP + "  -f, --format <format>              output file format (default: smiles)" + LINE_SEP + "  -rf, --report-file <filepath>      write report to a file" + LINE_SEP + "  -rp, --report-property             write report to the property of the" + LINE_SEP + "                                     output" + LINE_SEP + "  -rt, --report-pattern <pattern>    generate pattern based report file" + LINE_SEP + "  -re, --report-format <format>      file format of the molecules in report" + LINE_SEP + "  -l, --log <filepath>               write software-error log messages to file" + LINE_SEP + "  -ocr, --discard-scan-errors        discard incorrectly scanned molecules" + LINE_SEP + LINE_SEP + "Examples:" + LINE_SEP + "  structurecheck -c config.xml -t separated -o out.smi -d discarded.smi in.smi" + LINE_SEP + "  structurecheck -c config.xml -m fix -t separated -d discarded.smiles in.smiles" + LINE_SEP + "  structurecheck -c config.xml -m fix -t discarded in.sdf" + LINE_SEP + "  structurecheck -c \"bondLength\" in.sdf" + LINE_SEP + "  structurecheck -c \"isotope->converttoelementalform\" in.sdf" + LINE_SEP + "  structurecheck -c \"aromaticity..valence\" -m fix -f sdf -o out.sdf in.sdf";
    private static final String CHECKER_ACTION_STRING_HELP = "Valid checker actions (strings) are:" + LINE_SEP + "  3d                             detect atoms with 3D coordinates" + LINE_SEP + "  abbrevgroup                    detect all abbreviated groups" + LINE_SEP + "    :expanded=true               detect expanded abbreviated groups" + LINE_SEP + "    :contracted=true             detect contracted abbreviated groups" + LINE_SEP + "  alias                          detect atoms with alias" + LINE_SEP + "  aromaticity                    detect aromaticity errors with the given" + LINE_SEP + "                                 aromatization type (default: general)" + LINE_SEP + "    :basic                       basic aromaticity errors" + LINE_SEP + "    :loose                       loose aromaticity errors" + LINE_SEP + "    :general                     general aromaticity errors" + LINE_SEP + "  atommap                        detect atoms with map number" + LINE_SEP + "  atomqueryproperty              detect all or specified atom query properties" + LINE_SEP + "    :H=[true|false]              hydrogen count" + LINE_SEP + "    :X=[true|false]              connection count" + LINE_SEP + "    :D=[true|false]              explicit connection count" + LINE_SEP + "    :R=[true|false]              ring count" + LINE_SEP + "    :h=[true|false]              implicit hydrogen count" + LINE_SEP + "    :r=[true|false]              smallest ring count" + LINE_SEP + "    :a=[true|false]              aromaticity" + LINE_SEP + "    :s=[true|false]              substitution count" + LINE_SEP + "    :u=[true|false]              unsaturation" + LINE_SEP + "    :rb=[true|false]             ring bond count" + LINE_SEP + "  atomvalue                      detect atoms with atom value" + LINE_SEP + "  attacheddata                   detect atoms with attached data" + LINE_SEP + "  bondangle                      detect unpreferred bond angles in 2d" + LINE_SEP + "  bondlength                     detect bonds that are too long or too short" + LINE_SEP + "  chiralflag                     detect incorrectly set chiral flag" + LINE_SEP + "  coordsystem                    detect invalid coordination systems" + LINE_SEP + "  covalentcounterion             detect covalent counterions" + LINE_SEP + "  crosseddoublenond              detect crossed double bonds" + LINE_SEP + "  empty                          detect items without atoms" + LINE_SEP + "  explicith                      detect all or specified explicit hydrogens" + LINE_SEP + "    :lonely=[true|false]         lonely explicit hydrogens" + LINE_SEP + "    :mapped[true|false]          mapped explicit hydrogens" + LINE_SEP + "    :charged=[true|false]        charged explicit hydrogens" + LINE_SEP + "    :isotopic=[true|false]       isotopic explicit hydrogens" + LINE_SEP + "    :radical=[true|false]        radical explicit hydrogens" + LINE_SEP + "    :wedged=[true|false]         wedged explicit hydrogens" + LINE_SEP + "  explicitlp                     detect explicit lone pairs" + LINE_SEP + "  isotope                        detect isotopes" + LINE_SEP + "  metallocene                    detect incorrect metallocene representations" + LINE_SEP + "  missingatommap                 detect atoms without map numbers" + LINE_SEP + "  multicenter                    detect multicenters" + LINE_SEP + "  multicomponent                 detect molecules containing disconnected parts" + LINE_SEP + "  moleculecharge                 detect non-neutral molecules" + LINE_SEP + "  ocr                            detect drawings that originates from" + LINE_SEP + "                                 incorrect optical structure recognition" + LINE_SEP + "  overlappingAtoms               detect atoms that are too close to each other" + LINE_SEP + "  overlappingBonds               detect bonds that are too close to each other" + LINE_SEP + "  pseudoatom                     detect pseudo atoms" + LINE_SEP + "  queryatom                      detect query atoms" + LINE_SEP + "  querybond                      detect query bonds" + LINE_SEP + "  racemate                       detect asymmetric tetrahedral atoms without" + LINE_SEP + "                                 specific stereo configuration" + LINE_SEP + "  radical                        detect radical atoms" + LINE_SEP + "  ratom                          detect specified type of R-atoms" + LINE_SEP + "    :all=[true|false]            all type of R-atoms" + LINE_SEP + "    :disconnected=[true|false]   disconnected type of R-atoms" + LINE_SEP + "    :generic=[true|false]        generic type of R-atoms" + LINE_SEP + "    :linker=[true|false]         linker type of R-atoms" + LINE_SEP + "    :nested=[true|false]         nested type of R-atoms" + LINE_SEP + "  rare                           detect rare elements" + LINE_SEP + "  reactionmap                    detect reactions with invalid atom mapping" + LINE_SEP + "  rgroupattachmenterror          detect all R-group attachment errors" + LINE_SEP + "  rgroupreferenceerror           detect errors in R-group definitions" + LINE_SEP + "    :missingratom=[true|false]   missing R-atom definition" + LINE_SEP + "    :missingrgroup=[true|false]  missing R-group definition" + LINE_SEP + "    :selfreference=[true|false]  self reference errors in R-group definitions" + LINE_SEP + "  ringstrainerror                detect small rings with trans or cumulative " + LINE_SEP + "                                 double bonds, or triple bond" + LINE_SEP + "  solvent                        detect common solvents appearing" + LINE_SEP + "                                 by a main component" + LINE_SEP + "  staratom                       detect star atoms" + LINE_SEP + "  substructure:[smarts]          detects the given SMARTS structure" + LINE_SEP + "                                 as a substructure in the original molecule" + LINE_SEP + "  unbalancedreaction             detect reactions with orphan atoms" + LINE_SEP + "  valence                        detect valence errors" + LINE_SEP + "  valenceproperty                detect atoms with all or specified" + LINE_SEP + "                                 valence properties" + LINE_SEP + "    :defaultvalence=true         default valence properties" + LINE_SEP + "    :nondefaultvalence=true      non-default valence properties" + LINE_SEP + "  wedge                          detect incorrect wedge bonds" + LINE_SEP + "  wigglydoublebond               detects non_stereo double bonds with wiggly " + LINE_SEP + "                                 representation connected to a double bond";
    private static final String FIXER_ACTION_STRING_HELP = "Valid fixer actions (strings) are:" + LINE_SEP + "  aliastoatom               remove aliases from atoms" + LINE_SEP + "  aliastogroup              convert atoms with aliases to abbreviated groups" + LINE_SEP + "                            if the alias is recognized" + LINE_SEP + "  aliastocarbon             remove alias values from atoms and" + LINE_SEP + "                            convert the atom to a carbon" + LINE_SEP + "  clearabsstereo            remove the chiral flag" + LINE_SEP + "  clean                     calculate 2D coordinates" + LINE_SEP + "  contractgroup             contract all abbreviated groups" + LINE_SEP + "  converttoelementalform    convert isotopes into elemental atoms" + LINE_SEP + "  converttoionicform        convert covalent counterions to ionic form" + LINE_SEP + "  converttometalloceneform  convert non-standard metallocene representations" + LINE_SEP + "                            into coordinated multicenter representation" + LINE_SEP + "  crosseddoublebond         convert non-stereo double bond represented by" + LINE_SEP + "                            wiggly bond to crossed double bond representation" + LINE_SEP + "  crossedtowiggly           convert non-stereo double bond represented by" + LINE_SEP + "                            crossed double bond to wiggly bond representation" + LINE_SEP + "  dearomatize               convert aromatic rings into Kekule form" + LINE_SEP + "  expandgroup               expand all abbreviated groups if it is possible" + LINE_SEP + "  fixrgroupattachment       add missing attachments points to members" + LINE_SEP + "                            with single location" + LINE_SEP + "  fixvalence                correct valence problem by removing hydrogens" + LINE_SEP + "                            or setting charges" + LINE_SEP + "  mapmolecule               add atom maps to each atom of the molecule" + LINE_SEP + "  mapreaction               add atom maps to the reaction" + LINE_SEP + "  neutralize                remove charges from the molecule" + LINE_SEP + "  pseudotogroup             convert pseudo atoms to abbreviated groups" + LINE_SEP + "                            if pseudo label is a known abbreviated group" + LINE_SEP + "  removeexplicith           remove explicit hydrogens" + LINE_SEP + "  rearomatize               dearomatize the molecule and aromatize it again" + LINE_SEP + "  removealias               remove alias values from atoms" + LINE_SEP + "  removeatom                remove the problematic atoms from the molecule" + LINE_SEP + "  removeatommap             remove atom map numbers" + LINE_SEP + "  removeatomqueryproperty   remove atom query properties" + LINE_SEP + "  removeatomvalue           remove atom values" + LINE_SEP + "  removeattacheddata        remove data attached to atoms" + LINE_SEP + "  removebond                remove problematic bonds from the molecule" + LINE_SEP + "  removeradical             convert radicals to non_radical atoms" + LINE_SEP + "  removevalenceproperty     remove valence properties from atoms" + LINE_SEP + "  removezcoordinate         set the z-coordinates of atoms to zero" + LINE_SEP + "  ungroup                   ungroup all abbreviated groups" + LINE_SEP + "  wedgeclean                recalculate the orientation of the wedge bonds";
    private StructureCheckOptions options;
    private boolean isDone = false;
    private boolean isErrorOccured = false;
    private PrintStream logStream;
    private PrintStream reportStream = null;
    private OutputStream outputStream = System.out;
    private OutputStream discardedStream = System.out;
    private MolExporter outputExporter = null;
    private MolExporter discardedExporter = null;
    private TemplateBasedLogger reporter;
    private PropertyCheckerLogger propertyReporter;
    private CheckerLogPattern reportPattern;

    public StructureCheck() {
        this.logStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
    }

    public static void main(String[] args) {
        StructureCheck check = new StructureCheck();
        try {
            check.run(args);
        }
        catch (Exception e) {
            check.printError(e.getMessage());
        }
    }

    public void run(String[] args) {
        InputStream inputStream = System.in;
        this.options = new StructureCheckOptions();
        new JCommander((Object)this.options, args);
        if (this.isCheckerActionHelpPrinting()) {
            this.printCheckerActionHelp();
            return;
        }
        if (this.isFixerActionHelpPrinting()) {
            this.printFixerActionHelp();
            return;
        }
        if (this.isHelpPrinting()) {
            this.printHelp();
            return;
        }
        if (this.options.logPath != null && !this.options.logPath.isEmpty()) {
            File logFile = new File(this.options.logPath);
            try {
                this.logStream = new PrintStream(new FileOutputStream(logFile));
            }
            catch (FileNotFoundException e) {
                this.printError("Log file can not be written.");
                e.printStackTrace(this.logStream);
                throw new IllegalArgumentException(e);
            }
        }
        ConfigurationReader checkerConfigurationReader = new ActionStringBasedConfigurationReader("");
        File configFile = new File(this.options.config);
        if (configFile.exists()) {
            try {
                checkerConfigurationReader = new XMLBasedConfigurationReader(new FileInputStream(configFile));
            }
            catch (FileNotFoundException e) {
                this.printError("Configuration file is not readable!");
                e.printStackTrace(this.logStream);
                throw new IllegalArgumentException(e);
            }
        } else {
            checkerConfigurationReader = new ActionStringBasedConfigurationReader(this.options.config);
        }
        if (this.options.reportPattern != null) {
            this.reportPattern = CheckerLogPattern.parse(this.options.reportPattern);
        }
        this.setupOutput();
        try {
            AdvancedCheckerRunner runner = new AdvancedCheckerRunner(checkerConfigurationReader);
            CheckerLoggerGroup group = new CheckerLoggerGroup(new StructureCheckerLogger[0]);
            runner.setLogger(group);
            if (this.reportPattern != null && this.options.reportPath != null) {
                this.reporter = new TemplateBasedLogger(this.reportPattern, this.getReportStream());
                this.reporter.setEntryInfo(this.options.files);
                if (this.options.reportFormat != null) {
                    this.reporter.setFormat(this.options.reportFormat);
                }
                group.add(this.reporter);
            }
            if (this.isReporting() && this.options.reportProperty) {
                this.propertyReporter = new PropertyCheckerLogger();
                group.add(this.propertyReporter);
            }
            if (this.options.files != null && !this.options.files.isEmpty()) {
                for (String input : this.options.files) {
                    inputStream = this.createInputStream(input);
                    this.processInput(inputStream, runner, input);
                }
                if (this.discardedExporter != null) {
                    this.discardedExporter.close();
                }
                if (this.outputExporter != null) {
                    this.outputExporter.close();
                }
            } else {
                this.processInput(inputStream, runner, null);
                if (this.discardedExporter != null) {
                    this.discardedExporter.close();
                }
                if (this.outputExporter != null) {
                    this.outputExporter.close();
                }
            }
            if (this.reporter != null) {
                group.close();
                if (this.getReportStream() != null) {
                    this.getReportStream().close();
                }
            }
        }
        catch (Exception e) {
            this.printError(e.getMessage());
            e.printStackTrace(this.logStream);
        }
        this.isDone = true;
    }

    private void setupOutput() {
        switch (this.options.type) {
            case Accepted: {
                if (this.options.discardedPath == null || this.options.discardedPath.isEmpty()) {
                    this.outputStream = this.createOutputStream(this.options.outputPath);
                    this.discardedStream = null;
                    break;
                }
                throw new IllegalArgumentException("For output type \"accepted\" the following parameter is not usable: -d --discarded");
            }
            case Discarded: {
                if (this.options.outputPath == null || this.options.outputPath.isEmpty()) {
                    this.outputStream = null;
                    this.discardedStream = this.createOutputStream(this.options.discardedPath);
                    break;
                }
                throw new IllegalArgumentException("For output type \"discarded\" the following parameter is not usable: -o --output");
            }
            case Separated: {
                if ((this.options.discardedPath == null || this.options.discardedPath.isEmpty()) && (this.options.outputPath == null || this.options.outputPath.isEmpty())) {
                    throw new IllegalArgumentException("For output type \"separated\" must define one of the following: -o --output; -d --discarded");
                }
                this.outputStream = this.createOutputStream(this.options.outputPath);
                this.discardedStream = this.createOutputStream(this.options.discardedPath);
                break;
            }
            default: {
                this.discardedStream = this.outputStream = this.createOutputStream(this.options.outputPath);
            }
        }
    }

    private void processInput(InputStream inputStream, CheckerRunner runner, String name) throws IOException, MolExportException {
        boolean endReached;
        MolImporter importer = null;
        try {
            importer = new MolImporter(inputStream);
        }
        catch (IOException e) {
            if (inputStream != null) {
                inputStream.close();
            }
            this.printError("Can't process input: " + name + " skipping.");
            e.printStackTrace(this.logStream);
            return;
        }
        long inputCounter = 0L;
        Molecule tempMol = null;
        OCRErrorChecker doodleChecker = new OCRErrorChecker();
        tempMol = importer.read();
        boolean bl = endReached = tempMol == null;
        while (!endReached) {
            ++inputCounter;
            if (!this.options.ocr || doodleChecker.check(tempMol) == null) {
                runner.setMolecule(tempMol);
                this.isErrorOccured = this.isFixing() ? !runner.fix() : !runner.checkAndWait().isEmpty();
                try {
                    if (this.isErrorOccured) {
                        if (this.getDiscardedExporter() != null) {
                            this.getDiscardedExporter().write(tempMol);
                        }
                    } else if (this.getOutputExporter() != null) {
                        this.getOutputExporter().write(tempMol);
                    }
                }
                catch (Exception e) {
                    this.printError(e.getMessage());
                    e.printStackTrace(this.logStream);
                }
            }
            try {
                tempMol = importer.read();
                endReached = tempMol == null;
            }
            catch (MolFormatException ex) {
                ex.printStackTrace(this.logStream);
                String message = String.format("Can not read next molecule. %s Error found in input: %s, structure: %s.", ex.getMessage(), name, inputCounter);
                if (this.options.ignoreErrors) {
                    this.printError(message);
                    continue;
                }
                ex.printStackTrace(this.logStream);
                throw new MolFormatException(message, ex);
            }
        }
        importer.close();
    }

    private void printError(String error) {
        if (this.logStream != null) {
            this.logStream.println(error);
        }
        System.err.println("Error occured: " + error);
    }

    private InputStream createInputStream(String inputString) {
        InputStream inputStream = null;
        File inputFile = new File(inputString);
        if (inputFile.exists()) {
            try {
                inputStream = new FileInputStream(inputFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(this.logStream);
                throw new IllegalArgumentException(e);
            }
        } else {
            inputStream = new ByteArrayInputStream(inputString.getBytes());
        }
        return inputStream;
    }

    private OutputStream createOutputStream(String path) {
        FileOutputStream outputStream;
        if (path == null || path.isEmpty()) {
            return System.out;
        }
        try {
            outputStream = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(this.logStream);
            throw new IllegalArgumentException(e);
        }
        return outputStream;
    }

    private void printHelp() {
        System.out.println(HELP_STRING);
    }

    private void printCheckerActionHelp() {
        System.out.println(CHECKER_ACTION_STRING_HELP);
    }

    private void printFixerActionHelp() {
        System.out.println(FIXER_ACTION_STRING_HELP);
    }

    protected boolean isFixing() {
        return this.options.fix || this.options.mode.equals((Object)StructureCheckOptions.Mode.Fix);
    }

    protected boolean isHelpPrinting() {
        return this.options.help || this.options.config == null || this.options.config.isEmpty();
    }

    protected boolean isCheckerActionHelpPrinting() {
        return this.options.helpCheckerAction;
    }

    protected boolean isFixerActionHelpPrinting() {
        return this.options.helpFixerAction;
    }

    protected boolean isReporting() {
        return !this.options.noReport;
    }

    protected boolean isDone() {
        return this.isDone;
    }

    protected boolean isLogging() {
        return this.options.logPath != null && !this.options.logPath.isEmpty();
    }

    public boolean isErrorOccured() {
        return this.isErrorOccured;
    }

    private static boolean isDaylightFormatWithoutOptions(String format2) {
        return format2 != null && (format2.endsWith("smiles") || format2.endsWith("smarts"));
    }

    private MolExporter getOutputExporter() throws Exception {
        if (this.outputExporter == null) {
            String header;
            String string = header = StructureCheck.isDaylightFormatWithoutOptions(this.options.format) && !this.options.noReport ? this.options.format + ":T" + this.options.reportProperty : this.options.format;
            if (this.discardedStream != null && this.outputStream != null && this.discardedStream.equals(this.outputStream) && this.discardedExporter != null) {
                this.outputExporter = this.discardedExporter;
            } else if (this.outputStream != null) {
                try {
                    this.outputExporter = new MolExporter(this.outputStream, header);
                }
                catch (Exception e) {
                    this.printError("Output molecule file can not be written!");
                    e.printStackTrace(this.logStream);
                    throw e;
                }
            }
        }
        return this.outputExporter;
    }

    private MolExporter getDiscardedExporter() throws Exception {
        if (this.discardedExporter == null) {
            String header;
            String string = header = StructureCheck.isDaylightFormatWithoutOptions(this.options.format) && !this.options.noReport ? this.options.format + ":T" + this.options.reportProperty : this.options.format;
            if (this.discardedStream != null && this.outputStream != null && this.discardedStream.equals(this.outputStream) && this.outputExporter != null) {
                this.discardedExporter = this.outputExporter;
            } else if (this.discardedStream != null) {
                try {
                    this.discardedExporter = new MolExporter(this.discardedStream, header);
                }
                catch (Exception e) {
                    this.printError("Discarded molecule file can not be written!");
                    e.printStackTrace(this.logStream);
                    throw e;
                }
            }
        }
        return this.discardedExporter;
    }

    private PrintStream getReportStream() throws FileNotFoundException {
        if (this.reportStream == null) {
            try {
                this.reportStream = this.options.reportPath != null && !this.options.reportPath.isEmpty() ? new PrintStream(this.options.reportPath) : System.out;
            }
            catch (FileNotFoundException e) {
                this.printError("Report file can not be written!");
                e.printStackTrace(this.logStream);
                throw e;
            }
        }
        return this.reportStream;
    }

    public TemplateBasedLogger getReporter() {
        return this.reporter;
    }
}

