/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.FixMode;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureChecker;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class StructureCheckerDescriptor
implements Cloneable {
    public static final String CUSTOM_NAME = "customName";
    public static final String FIX_MODE = "fixMode";
    public static final String FIXER_CLASS_NAME = "fixerClassName";
    public static final String EDITOR_CLASS_NAME = "editorClassName";
    public static final String NAME = "name";
    public static final String LOCAL_MENU_NAME = "localMenuName";
    public static final String NO_ERROR_MESSAGE = "noErrorMessage";
    public static final String ONE_ERROR_MESSAGE = "oneErrorMessage";
    public static final String MORE_ERROR_MESSAGE = "moreErrorMessage";
    public static final String HELP_TEXT = "helpText";
    public static final String DESCRIPTION = "description";
    public static final String ICON_PATH = "iconPath";
    public static final String SEVERITY = "severity";
    public static final String ACTIONSTRING_TOKEN = "actionStringToken";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String name = "Unnamed";
    private String localMenuName = "Unnamed";
    private String noErrorMessage = "No errors";
    private String oneErrorMessage = "problem found";
    private String moreErrorMessage = "problems found";
    private String helpText = "No Help available";
    private String description = "No description";
    private String iconPath = "/chemaxon/icons/marvin/checker/defaultfeaturecheck.png";
    private String editorClassName = "chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor";
    private String[] actionStringTokens = new String[0];
    @Persistent(alias="name")
    private String customName = null;
    @Persistent(alias="fixMode")
    private FixMode fixMode = FixMode.ASK;
    @Persistent(alias="fixerClassName")
    private String fixerClassName = null;
    private CheckerSeverity severity = CheckerSeverity.WARNING;
    private Icon icon = null;
    private boolean iconIsDirty = true;

    public StructureCheckerDescriptor(Class<? extends StructureChecker> checkerClass) throws IllegalArgumentException {
        if (checkerClass == null) {
            throw new IllegalArgumentException("Checker class must not be null");
        }
        if (checkerClass.isAnnotationPresent(CheckerInfo.class)) {
            CheckerInfo info = checkerClass.getAnnotation(CheckerInfo.class);
            this.name = info.name();
            this.localMenuName = info.localMenuName();
            this.noErrorMessage = info.noErrorMessage();
            this.oneErrorMessage = info.oneErrorMessage();
            this.moreErrorMessage = info.moreErrorMessage();
            this.helpText = info.helpText();
            this.description = info.description();
            this.iconPath = info.iconPath();
            this.severity = info.severity();
            this.editorClassName = info.editorClassName();
            this.actionStringTokens = info.actionStringToken().split(",");
            if ("".equals(this.iconPath)) {
                switch (this.severity) {
                    case ERROR: {
                        this.iconPath = "/chemaxon/icons/marvin/checker/defaultcheck.png";
                        break;
                    }
                    default: {
                        this.iconPath = "/chemaxon/icons/marvin/checker/defaultfeaturecheck.png";
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.getName();
        this.name = name;
        this.propertyChangeSupport.firePropertyChange(NAME, oldValue, name);
    }

    public String getLocalMenuName() {
        return this.localMenuName;
    }

    public void setLocalMenuName(String localMenuName) {
        String oldValue = this.getLocalMenuName();
        this.localMenuName = localMenuName;
        this.propertyChangeSupport.firePropertyChange(LOCAL_MENU_NAME, oldValue, localMenuName);
    }

    public String getNoErrorMessage() {
        return this.noErrorMessage;
    }

    public void setNoErrorMessage(String noErrorMessage) {
        String oldValue = this.getNoErrorMessage();
        this.noErrorMessage = noErrorMessage;
        this.propertyChangeSupport.firePropertyChange(NO_ERROR_MESSAGE, oldValue, noErrorMessage);
    }

    public String getOneErrorMessage() {
        return this.oneErrorMessage;
    }

    public void setOneErrorMessage(String oneErrorMessage) {
        String oldValue = this.getOneErrorMessage();
        this.oneErrorMessage = oneErrorMessage;
        this.propertyChangeSupport.firePropertyChange(ONE_ERROR_MESSAGE, oldValue, oneErrorMessage);
    }

    public String getMoreErrorMessage() {
        return this.moreErrorMessage;
    }

    public void setMoreErrorMessage(String moreErrorMessage) {
        String oldValue = this.getMoreErrorMessage();
        this.moreErrorMessage = moreErrorMessage;
        this.propertyChangeSupport.firePropertyChange(MORE_ERROR_MESSAGE, oldValue, moreErrorMessage);
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        String oldValue = this.getHelpText();
        this.helpText = helpText;
        this.propertyChangeSupport.firePropertyChange(HELP_TEXT, oldValue, helpText);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = this.getDescription();
        this.description = description;
        this.propertyChangeSupport.firePropertyChange(DESCRIPTION, oldValue, description);
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        String oldValue = this.getIconPath();
        this.iconPath = iconPath;
        this.iconIsDirty = true;
        this.propertyChangeSupport.firePropertyChange(ICON_PATH, oldValue, iconPath);
    }

    public String getEditorClassName() {
        return this.editorClassName;
    }

    public void setEditorClassName(String editorClassName) {
        String oldValue = this.getEditorClassName();
        this.editorClassName = editorClassName;
        this.propertyChangeSupport.firePropertyChange(EDITOR_CLASS_NAME, oldValue, editorClassName);
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        String oldValue = this.getCustomName();
        this.customName = customName;
        this.propertyChangeSupport.firePropertyChange(CUSTOM_NAME, oldValue, customName);
    }

    public FixMode getFixMode() {
        return this.fixMode;
    }

    public void setFixMode(FixMode fixMode) {
        FixMode oldValue = this.getFixMode();
        this.fixMode = fixMode;
        this.propertyChangeSupport.firePropertyChange(FIX_MODE, (Object)oldValue, (Object)fixMode);
    }

    public String getFixerClassName() {
        return this.fixerClassName;
    }

    public void setFixerClassName(String fixerClassName) {
        String oldValue = this.getFixerClassName();
        this.fixerClassName = fixerClassName;
        this.propertyChangeSupport.firePropertyChange(FIXER_CLASS_NAME, oldValue, fixerClassName);
    }

    public CheckerSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(CheckerSeverity severity) {
        CheckerSeverity oldValue = this.getSeverity();
        this.severity = severity;
        this.propertyChangeSupport.firePropertyChange(SEVERITY, (Object)oldValue, (Object)severity);
    }

    public String[] getActionStringTokens() {
        return this.actionStringTokens;
    }

    public void setActionStringTokens(String[] actionStringTokens) {
        String[] oldActionStrings = this.getActionStringTokens();
        this.actionStringTokens = actionStringTokens;
        this.propertyChangeSupport.firePropertyChange(ACTIONSTRING_TOKEN, oldActionStrings, actionStringTokens);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.helpText == null ? 0 : this.helpText.hashCode());
        result = 31 * result + (this.iconPath == null ? 0 : this.iconPath.hashCode());
        result = 31 * result + (this.localMenuName == null ? 0 : this.localMenuName.hashCode());
        result = 31 * result + (this.moreErrorMessage == null ? 0 : this.moreErrorMessage.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.oneErrorMessage == null ? 0 : this.oneErrorMessage.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.customName == null ? 0 : this.customName.hashCode());
        result = 31 * result + (this.fixerClassName == null ? 0 : this.fixerClassName.hashCode());
        result = 31 * result + (this.fixMode == null ? 0 : this.fixMode.hashCode());
        if (this.actionStringTokens != null) {
            for (String token : this.actionStringTokens) {
                result = 31 * result + token.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureCheckerDescriptor other = (StructureCheckerDescriptor)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.helpText == null ? other.helpText != null : !this.helpText.equals(other.helpText)) {
            return false;
        }
        if (this.iconPath == null ? other.iconPath != null : !this.iconPath.equals(other.iconPath)) {
            return false;
        }
        if (this.localMenuName == null ? other.localMenuName != null : !this.localMenuName.equals(other.localMenuName)) {
            return false;
        }
        if (this.moreErrorMessage == null ? other.moreErrorMessage != null : !this.moreErrorMessage.equals(other.moreErrorMessage)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.oneErrorMessage == null ? other.oneErrorMessage != null : !this.oneErrorMessage.equals(other.oneErrorMessage)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.customName == null ? other.customName != null : !this.customName.equals(other.customName)) {
            return false;
        }
        if (this.fixerClassName == null ? other.fixerClassName != null : !this.fixerClassName.equals(other.fixerClassName)) {
            return false;
        }
        if (this.fixMode != other.fixMode) {
            return false;
        }
        if (this.actionStringTokens == null) {
            if (other.actionStringTokens != null) {
                return false;
            }
        } else {
            if (this.actionStringTokens.length != other.actionStringTokens.length) {
                return false;
            }
            for (int i = 0; i < this.actionStringTokens.length; ++i) {
                if (this.actionStringTokens[i].equals(other.actionStringTokens[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "StructureCheckerDescriptor [getName()=" + this.getName() + ", getLocalMenuName()=" + this.getLocalMenuName() + ", getActionStringTokens()=" + this.getActionStringTokens() + ", getNoErrorMessage()=" + this.getNoErrorMessage() + ", getOneErrorMessage()=" + this.getOneErrorMessage() + ", getMoreErrorMessage()=" + this.getMoreErrorMessage() + ", getHelpText()=" + this.getHelpText() + ", getDescription()=" + this.getDescription() + ", getIconPath()=" + this.getIconPath() + ", getSeverity()=" + (Object)((Object)this.getSeverity()) + ", hashCode()=" + this.hashCode() + "]";
    }

    public Icon getIcon() {
        if (this.icon == null || this.iconIsDirty) {
            this.icon = this.createIconFromPath(this.getIconPath());
        }
        return this.icon;
    }

    private Icon createIconFromPath(String iconPath) {
        Icon icon;
        if (GraphicsEnvironment.isHeadless()) {
            icon = new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                }

                @Override
                public int getIconWidth() {
                    return 24;
                }

                @Override
                public int getIconHeight() {
                    return 24;
                }
            };
        } else {
            URL url = this.getClass().getResource(iconPath);
            if (url != null) {
                icon = new ImageIcon(url);
            } else {
                BufferedImage image = new BufferedImage(24, 24, 6);
                icon = new ImageIcon(image);
            }
        }
        return icon;
    }

    public StructureCheckerDescriptor clone() throws CloneNotSupportedException {
        StructureCheckerDescriptor clone = (StructureCheckerDescriptor)super.clone();
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        clone.icon = null;
        clone.iconIsDirty = true;
        return clone;
    }
}

