/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.StructureChecker;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class StructureCheckerFactory {
    public static final String CHECKERCONFIG_XML = "checkerconfig.xml";
    public static final String USER_DEFINED_CHECKERCONFIG_XML = "userdefinedcheckers.xml";
    public static final String DEFAULT_CONFIGURATION_PATH = "/chemaxon/checkers/resource/defaultcheckerconfig.xml";
    public static final String DEFAULT_CONFIGURATION_SCHEMA = "/chemaxon/checkers/resource/checkerconfig.xsd";
    private static final Properties EXTERNAL_OVERRIDE_PROPERTIES = new Properties();
    private static final String CHECKER_PACKAGE_PREFIX = "chemaxon.checkers";
    private static final Map<String, Class<StructureChecker>> DEFAULT_MAP = StructureCheckerFactory.getMap(StructureCheckerFactory.class.getResourceAsStream("/chemaxon/checkers/resource/defaultcheckerconfig.xml"), StructureCheckerFactory.getExternalStream(), EXTERNAL_OVERRIDE_PROPERTIES);
    private Map<String, Class<StructureChecker>> map;

    public StructureCheckerFactory() {
        this.map = DEFAULT_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureCheckerFactory(String path, String externalPath) {
        InputStream internalCheckerConfigStream = null;
        FileInputStream externalCheckerConfigStream = null;
        try {
            File file;
            internalCheckerConfigStream = this.getClass().getResourceAsStream(path);
            if (externalPath != null && (file = new File(externalPath)).isFile() && file.canRead()) {
                externalCheckerConfigStream = new FileInputStream(file);
            }
            this.map = StructureCheckerFactory.getMap(internalCheckerConfigStream, externalCheckerConfigStream, EXTERNAL_OVERRIDE_PROPERTIES);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.map.clear();
        }
        finally {
            if (internalCheckerConfigStream != null) {
                try {
                    internalCheckerConfigStream.close();
                }
                catch (IOException e1) {
                    internalCheckerConfigStream = null;
                }
            }
            if (externalCheckerConfigStream != null) {
                try {
                    externalCheckerConfigStream.close();
                }
                catch (IOException e1) {
                    externalCheckerConfigStream = null;
                }
            }
        }
    }

    public List<StructureChecker> getAvailableCheckers() {
        ArrayList<StructureChecker> list = new ArrayList<StructureChecker>();
        for (String id : this.map.keySet()) {
            StructureChecker checker = this.getChecker(id, Collections.EMPTY_MAP);
            if (!checker.isAvailable()) continue;
            list.add(checker);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Class<StructureChecker>> getMap(InputStream internalCheckerConfigStream, InputStream externalCheckerConfigStream, Properties properties) {
        HashMap<String, Class<StructureChecker>> map = new HashMap<String, Class<StructureChecker>>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            URL schemaURL = StructureCheckerFactory.class.getResource(DEFAULT_CONFIGURATION_SCHEMA);
            if (schemaURL != null) {
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
                try {
                    factory.setSchema(schema);
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
            SAXParser parser = factory.newSAXParser();
            if (internalCheckerConfigStream != null) {
                parser.parse(internalCheckerConfigStream, (DefaultHandler)new CheckerFactoryHandler(map));
            }
            if (externalCheckerConfigStream != null) {
                parser.parse(externalCheckerConfigStream, (DefaultHandler)new CheckerFactoryHandler(map, properties, true));
            }
        }
        catch (SAXException e) {
            map.clear();
        }
        catch (ParserConfigurationException e) {
            map.clear();
        }
        catch (IOException e) {
            map.clear();
        }
        finally {
            if (internalCheckerConfigStream != null) {
                try {
                    internalCheckerConfigStream.close();
                }
                catch (IOException e) {}
            }
            if (externalCheckerConfigStream != null) {
                try {
                    externalCheckerConfigStream.close();
                }
                catch (IOException e) {}
            }
        }
        return map;
    }

    public StructureChecker getChecker(String checkerId, Map<String, String> params) {
        Class<StructureChecker> checkerClass = null;
        try {
            checkerClass = this.map.isEmpty() ? Class.forName(CHECKER_PACKAGE_PREFIX + checkerId) : this.map.get(checkerId);
        }
        catch (ClassNotFoundException e) {
            checkerClass = null;
        }
        if (checkerClass != null) {
            for (Constructor<?> constructor : checkerClass.getConstructors()) {
                URL imgURL;
                String iconPath;
                StructureChecker checker = null;
                if (params.isEmpty() && constructor.getParameterTypes().length == 0) {
                    try {
                        checker = (StructureChecker)constructor.newInstance(null);
                    }
                    catch (IllegalArgumentException e) {
                        checker = null;
                    }
                    catch (InstantiationException e) {
                        checker = null;
                    }
                    catch (IllegalAccessException e) {
                        checker = null;
                    }
                    catch (InvocationTargetException e) {
                        checker = null;
                    }
                } else if (!params.isEmpty() && constructor.getParameterTypes().length == 1) {
                    try {
                        checker = (StructureChecker)constructor.newInstance(params);
                    }
                    catch (IllegalArgumentException e) {
                        checker = null;
                    }
                    catch (InstantiationException e) {
                        checker = null;
                    }
                    catch (IllegalAccessException e) {
                        checker = null;
                    }
                    catch (InvocationTargetException e) {
                        checker = null;
                    }
                }
                if (checker == null) continue;
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".name")) {
                    checker.getDescriptor().setName(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".name"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".localMenuName")) {
                    checker.getDescriptor().setLocalMenuName(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".localMenuName"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".help")) {
                    checker.getDescriptor().setHelpText(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".help"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".noErrorMessage")) {
                    checker.getDescriptor().setNoErrorMessage(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".noErrorMessage"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".oneErrorMessage")) {
                    checker.getDescriptor().setOneErrorMessage(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".oneErrorMessage"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".moreErrorMessage")) {
                    checker.getDescriptor().setMoreErrorMessage(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".moreErrorMessage"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".description")) {
                    checker.getDescriptor().setDescription(EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".description"));
                }
                if (EXTERNAL_OVERRIDE_PROPERTIES.containsKey(checkerId + ".icon") && !"".equals(iconPath = EXTERNAL_OVERRIDE_PROPERTIES.getProperty(checkerId + ".icon")) && (imgURL = this.getClass().getResource(iconPath)) != null) {
                    checker.getDescriptor().setIconPath(iconPath);
                }
                return checker;
            }
        }
        return null;
    }

    private static InputStream getExternalStream() {
        FileInputStream externalStream = null;
        try {
            externalStream = new FileInputStream(DotfileUtil.getDotFile(USER_DEFINED_CHECKERCONFIG_XML));
        }
        catch (FileNotFoundException e) {
            externalStream = null;
        }
        return externalStream;
    }

    private static final class CheckerFactoryHandler
    extends DefaultHandler {
        Map<String, Class<StructureChecker>> map;
        Properties properties;
        final boolean isExternal;

        public CheckerFactoryHandler(Map<String, Class<StructureChecker>> map) {
            this(map, null, false);
        }

        public CheckerFactoryHandler(Map<String, Class<StructureChecker>> map, Properties properties, boolean isExternal) {
            this.map = map;
            this.properties = properties;
            this.isExternal = isExternal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("bundle".equals(qName) && this.properties != null) {
                InputStream inStream = null;
                try {
                    inStream = this.isExternal ? DotfileUtil.open(attributes.getValue("base")) : this.getClass().getResourceAsStream(attributes.getValue("base"));
                    this.properties.load(inStream);
                }
                catch (IOException e) {
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            inStream = null;
                        }
                    }
                }
            } else if ("checker".equals(qName)) {
                File file;
                String path = attributes.getValue("jar");
                ClassLoader loader = this.getClass().getClassLoader();
                if (path != null && !"".equals(path) && (file = new File(path)).canRead() && file.isFile()) {
                    try {
                        loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                try {
                    this.map.put(attributes.getValue("id"), Class.forName(attributes.getValue("class"), false, loader));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }
}

