/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureCheckerHelper {
    public static final double MINIMAL_ATOM_DISTANCE_LIMIT = 0.77;
    public static final double MINIMAL_DISTANCE_LIMIT = 1.2320000000000002;
    public static final double MAXIMAL_DISTANCE_LIMIT = 1.8479999999999999;
    private static final String DEFAULT_ABBREVGROUP_FILE = "/chemaxon/marvin/templates/default.abbrevgroup";
    private static Map<String, Molecule> defaultAbbrevGroupMap = null;

    public static double distance(MolAtom atom1, MolAtom atom2) {
        return Math.sqrt((atom1.getX() - atom2.getX()) * (atom1.getX() - atom2.getX()) + (atom1.getY() - atom2.getY()) * (atom1.getY() - atom2.getY()) + (atom1.getZ() - atom2.getZ()) * (atom1.getZ() - atom2.getZ()));
    }

    public static List<MolBond> createNeighbourBonds(Molecule molecule, MolBond bond, boolean ignoreRingBonds) {
        MolBond bond2;
        int i;
        ArrayList<MolBond> neighbourBonds = new ArrayList<MolBond>();
        MolAtom atom = bond.getAtom1();
        for (i = 0; i < atom.getBondCount(); ++i) {
            bond2 = atom.getBond(i);
            if (ignoreRingBonds && molecule.isRingBond(molecule.indexOf(bond2))) continue;
            neighbourBonds.add(bond2);
        }
        atom = bond.getAtom2();
        for (i = 0; i < atom.getBondCount(); ++i) {
            bond2 = atom.getBond(i);
            if (ignoreRingBonds && molecule.isRingBond(molecule.indexOf(bond2))) continue;
            neighbourBonds.add(bond2);
        }
        return neighbourBonds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, Molecule> getDefaultAbbrevgroups() throws MolFormatException, IOException {
        if (defaultAbbrevGroupMap == null) {
            defaultAbbrevGroupMap = new HashMap<String, Molecule>();
            InputStream is = null;
            MolImporter importer = null;
            try {
                is = BasicEnvironment.getResourceAsStream(StructureCheckerHelper.class, DEFAULT_ABBREVGROUP_FILE);
                importer = new MolImporter(is);
                Molecule mol = null;
                while ((mol = importer.read()) != null) {
                    mol.contractSgroups();
                    mol.setGUIContracted(true);
                    defaultAbbrevGroupMap.put(mol.getName(), mol);
                    SgroupAtom sgroupAtom = (SgroupAtom)mol.getAtom(0);
                    if (sgroupAtom.getLeftName() != null && !mol.getName().equals(sgroupAtom.getLeftName())) {
                        defaultAbbrevGroupMap.put(sgroupAtom.getLeftName(), mol);
                    }
                    if (sgroupAtom.getRightName() == null || mol.getName().equals(sgroupAtom.getRightName())) continue;
                    defaultAbbrevGroupMap.put(sgroupAtom.getRightName(), mol);
                }
            }
            finally {
                if (importer != null) {
                    importer.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        return defaultAbbrevGroupMap;
    }

    public static boolean isTerminal(MolBond molBond) {
        return molBond.getAtom1().isTerminalAtom() || molBond.getAtom2().isTerminalAtom();
    }

    public static boolean isAbsoluteStereoRelevant(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            int parity = mol.getParity(i);
            if (parity != 1 && parity != 2 || mol.getAtom(i).getStereoGroupType() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isChiral(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int ch = mol.getChirality(i);
            if (ch != 8 && ch != 16) continue;
            return true;
        }
        return false;
    }

    public static boolean isAromatic(int[] is, Molecule mol) {
        for (int i = 0; i < is.length - 1; ++i) {
            MolBond bond = mol.getAtom(is[i]).getBondTo(mol.getAtom(is[i + 1]));
            if (bond.getType() == 4) continue;
            return false;
        }
        return true;
    }

    public static boolean ringHasOnlyOneNeighbour(int[] is, Molecule mol, MolAtom atom) {
        for (int i = 0; i < is.length; ++i) {
            MolAtom ringAtom = mol.getAtom(is[i]);
            if (ringAtom.getBondCount() <= 3 && (ringAtom.getBondCount() != 3 || ringAtom.getBondTo(atom) != null)) continue;
            return false;
        }
        return true;
    }

    public static double calculateCosAFromScalarMul(MolBond bond1, MolBond bond2) {
        double scalar = 0.0;
        if (bond1.getAtom1() == bond2.getAtom1()) {
            scalar = (bond1.getAtom2().getX() - bond1.getAtom1().getX()) * (bond2.getAtom2().getX() - bond2.getAtom1().getX()) + (bond1.getAtom2().getY() - bond1.getAtom1().getY()) * (bond2.getAtom2().getY() - bond2.getAtom1().getY());
        } else if (bond1.getAtom2() == bond2.getAtom1()) {
            scalar = (bond1.getAtom1().getX() - bond1.getAtom2().getX()) * (bond2.getAtom2().getX() - bond2.getAtom1().getX()) + (bond1.getAtom1().getY() - bond1.getAtom2().getY()) * (bond2.getAtom2().getY() - bond2.getAtom1().getY());
        } else if (bond1.getAtom1() == bond2.getAtom2()) {
            scalar = (bond1.getAtom2().getX() - bond1.getAtom1().getX()) * (bond2.getAtom1().getX() - bond2.getAtom2().getX()) + (bond1.getAtom2().getY() - bond1.getAtom1().getY()) * (bond2.getAtom1().getY() - bond2.getAtom2().getY());
        } else if (bond1.getAtom2() == bond2.getAtom2()) {
            scalar = (bond1.getAtom1().getX() - bond1.getAtom2().getX()) * (bond2.getAtom1().getX() - bond2.getAtom2().getX()) + (bond1.getAtom1().getY() - bond1.getAtom2().getY()) * (bond2.getAtom1().getY() - bond2.getAtom2().getY());
        }
        return scalar / bond1.getLength() / bond2.getLength();
    }

    public static boolean isDaylightFormatWithoutOptions(String format2) {
        return format2 != null && (format2.endsWith("smiles") || format2.endsWith("smarts"));
    }
}

