/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.result.SubstructureCheckerResult;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.ModuleNotAvailableException;
import chemaxon.util.search.MolSearcher;
import chemaxon.util.search.MolSearcherFactory;
import chemaxon.util.search.SearchException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@CheckerInfo(name="Substructure Checker", localMenuName="Substructure", description="Detects specified substructure", noErrorMessage="No substructure found", oneErrorMessage="substructure found", moreErrorMessage="substructures found", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.SubstructureCheckerEditor", actionStringToken="substructure")
public class SubstructureChecker
extends AbstractStructureChecker {
    private static final String PROPERTY_KEY_REACTION_SMARTS = "reactionSmarts";
    private MolSearcher search = null;
    private Molecule query = null;
    @Persistent(alias="reactionSmarts")
    private String reactionSmarts = null;
    private boolean couldBeFixed = true;
    private boolean validSmarts = false;
    private boolean isAvailable = true;
    private static final Logger LOGGER = Logger.getLogger(SubstructureChecker.class.getName());

    public SubstructureChecker() {
        super(StructureCheckerErrorType.SUBSTRUCTURE);
        this.getSearch();
    }

    public SubstructureChecker(Map<String, String> params) {
        this();
        if (params.containsKey(PROPERTY_KEY_REACTION_SMARTS)) {
            try {
                this.setReactionSmarts(params.get(PROPERTY_KEY_REACTION_SMARTS));
            }
            catch (MolFormatException e) {
                this.reactionSmarts = params.get(PROPERTY_KEY_REACTION_SMARTS);
                this.validSmarts = false;
            }
        }
    }

    public SubstructureChecker(String areactionSmarts) throws ModuleNotAvailableException, MolFormatException {
        this();
        this.setReactionSmarts(areactionSmarts);
    }

    public String getReactionSmarts() {
        return this.reactionSmarts;
    }

    public void setReactionSmarts(String reactionSmarts) throws MolFormatException {
        boolean oldValid = this.isValid();
        try {
            if (!"".equals(reactionSmarts)) {
                Molecule mol = MolImporter.importMol(reactionSmarts, "smarts");
                RxnMolecule rxn = RxnMolecule.getReaction(mol);
                if (rxn == null) {
                    this.query = mol;
                    this.getSearch().setQuery(this.query);
                    this.couldBeFixed = false;
                } else {
                    Molecule[] reactants = rxn.getReactants();
                    Molecule fused = reactants[0].cloneMolecule();
                    for (int i = 1; i < reactants.length; ++i) {
                        fused.fuse(reactants[i].cloneMolecule());
                    }
                    this.query = fused;
                    this.getSearch().setQuery(this.query);
                    this.couldBeFixed = true;
                }
                String oldValue = this.getReactionSmarts();
                this.reactionSmarts = reactionSmarts;
                this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_REACTION_SMARTS, oldValue, reactionSmarts);
                this.validSmarts = true;
            } else {
                this.validSmarts = false;
            }
        }
        catch (MolFormatException e) {
            this.validSmarts = false;
            throw e;
        }
        finally {
            this.propertyChangeSupport.firePropertyChange("VALID", oldValid, this.isValid());
        }
    }

    @Override
    public StructureCheckerErrorType getErrorType() {
        return this.couldBeFixed ? StructureCheckerErrorType.SUBSTRUCTURE : StructureCheckerErrorType.SUBSTRUCTURE_NOFIX;
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (this.query != null) {
            this.search.setTarget(molecule);
            ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
            ArrayList<int[]> hitList = new ArrayList<int[]>();
            try {
                int[] hit;
                while ((hit = this.search.findNext()) != null) {
                    hitList.add(hit);
                    for (int i : hit) {
                        if (i < 0) continue;
                        atoms.add(molecule.getAtom(i));
                    }
                }
            }
            catch (SearchException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Substructure checker: error during substructure search.", e);
                }
                return null;
            }
            if (hitList.isEmpty()) {
                return null;
            }
            return new SubstructureCheckerResult(this, atoms, new ArrayList<MolBond>(), this.getErrorType(), molecule, this.getErrorDescription(hitList.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon(), hitList, this.reactionSmarts);
        }
        return null;
    }

    private MolSearcher getSearch() {
        if (this.search == null) {
            try {
                this.search = MolSearcherFactory.createStandardizedMolSearch();
            }
            catch (ModuleNotAvailableException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Substructure checker cannot be initialized. JChem module is not available.");
                }
                this.search = new MolSearcher(){

                    @Override
                    public void setTarget(Molecule target) {
                    }

                    @Override
                    public void setQuery(Molecule query) {
                    }

                    @Override
                    public int[] findNext() throws SearchException {
                        return null;
                    }
                };
                this.setDescription(this.getDescription() + " [Requires JChem]");
                this.isAvailable = false;
            }
        }
        return this.search;
    }

    @Override
    public boolean isValid() {
        return this.validSmarts && (this.getDescriptor().getCustomName() == null || this.getDescriptor().getCustomName().length() > 0) && super.isValid();
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable && super.isAvailable();
    }
}

