/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Three Dimension Checker", localMenuName="Three Dimensional Structure", description="Detects atoms with non-zero Z-coordinates", noErrorMessage="No three dimensional coordinate found", oneErrorMessage="atom with three dimensional coordinates found", moreErrorMessage="atoms with three dimensional coordinates found", actionStringToken="3d")
public class ThreeDimensionChecker
extends AtomChecker {
    public ThreeDimensionChecker() {
        super(StructureCheckerErrorType.THREE_DIM);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        return atom.getZ() != 0.0;
    }
}

