/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Map;

@CheckerInfo(name="Valence Property Checker", localMenuName="Valence Property", description="Detects valence properties", noErrorMessage="No valence property found", oneErrorMessage="valence property found", moreErrorMessage="valence properties found", actionStringToken="valenceproperty", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.ValencePropertyCheckerEditor")
public class ValencePropertyChecker
extends AtomChecker {
    public static final String PROPERTY_KEY_DEFAULT_VALENCE = "defaultValence";
    public static final String PROPERTY_KEY_NON_DEFAULT_VALENCE = "nonDefaultValence";
    public static final String PROPERTY_KEY_SEARCH_DEFAULT_VALENCE = "searchDefaultValence";
    public static final String PROPERTY_KEY_SEARCH_NON_DEFAULT_VALENCE = "searchNonDefaultValence";
    @Persistent(alias="defaultValence")
    private boolean searchDefaultValence = true;
    @Persistent(alias="nonDefaultValence")
    private boolean searchNonDefaultValence = true;

    public ValencePropertyChecker() {
        super(StructureCheckerErrorType.VALENCE_PROPERTY);
    }

    public ValencePropertyChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.VALENCE_PROPERTY);
        this.searchDefaultValence = Boolean.parseBoolean(params.get(PROPERTY_KEY_DEFAULT_VALENCE));
        this.searchNonDefaultValence = Boolean.parseBoolean(params.get(PROPERTY_KEY_NON_DEFAULT_VALENCE));
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom component) {
        boolean result = false;
        int vp = component.getValenceProp();
        if (vp != -1) {
            int dv = Math.abs(MolAtom.oxstateOf(component.getAtno(), 0));
            if (this.searchDefaultValence && vp == dv) {
                result = true;
            }
            if (this.searchNonDefaultValence && vp != dv) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ValencePropertyChecker other = (ValencePropertyChecker)obj;
        return this.searchDefaultValence == other.searchDefaultValence && this.searchNonDefaultValence == other.searchNonDefaultValence;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * (this.searchDefaultValence ? 1 : 0) + 31 * (this.searchNonDefaultValence ? 2 : 0);
    }

    public boolean isSearchDefaultValence() {
        return this.searchDefaultValence;
    }

    public boolean isSearchNonDefaultValence() {
        return this.searchNonDefaultValence;
    }

    public void setSearchDefaultValence(boolean value) {
        boolean oldValue = this.searchDefaultValence;
        this.searchDefaultValence = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_DEFAULT_VALENCE, oldValue, value);
    }

    public void setSearchNonDefaultValence(boolean value) {
        boolean oldValue = this.searchNonDefaultValence;
        this.searchNonDefaultValence = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_NON_DEFAULT_VALENCE, oldValue, value);
    }
}

