/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

@CheckerInfo(name="Wedge Error Checker", localMenuName="Wedge Error", description="Detects wedges of non chiral atoms and other wedge errors", noErrorMessage="No Invalid wedge found", oneErrorMessage="invalid wedge found", moreErrorMessage="invalid wedges found", severity=CheckerSeverity.ERROR, actionStringToken="wedge")
public class WedgeErrorChecker
extends AbstractStructureChecker {
    public WedgeErrorChecker() {
        super(StructureCheckerErrorType.INVALID_WEDGE);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        ArrayList<MolBond> wedgeBonds = new ArrayList<MolBond>();
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            MolBond bond = molecule.getBond(i);
            if ((bond.getFlags() & 0x30) == 0) continue;
            wedgeBonds.add(bond);
        }
        if (!wedgeBonds.isEmpty() && molecule.getDim() != 2) {
            return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), wedgeBonds, this.errorType, molecule, this.getErrorDescription(wedgeBonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (MolBond molBond : wedgeBonds) {
            boolean wigglyWedgeConnectedToCrossedDoubleBond;
            int type = molBond.getFlags() & 0x30;
            int parity1 = molecule.getParity(molecule.indexOf(molBond.getAtom1()));
            int parity2 = molecule.getParity(molecule.indexOf(molBond.getAtom2()));
            boolean wedgeBetweenTwoParityAtoms = parity1 != 0 && parity2 != 0;
            boolean rootHasNoParity = parity1 == 0;
            boolean upOrDownWedgeWithInvalidRootParity = (type == 16 || type == 32) && parity1 != 1 && parity1 != 2;
            boolean wigglyWedgeWithBadParity = type == 48 && parity1 != 3;
            boolean bl = wigglyWedgeConnectedToCrossedDoubleBond = type == 48 && this.connectedToCrossedDoubleBond(molBond);
            if (type == 48 && this.connectedToDoubleBond(molBond) || !wedgeBetweenTwoParityAtoms && !rootHasNoParity && !upOrDownWedgeWithInvalidRootParity && !wigglyWedgeWithBadParity && !wigglyWedgeConnectedToCrossedDoubleBond && !this.connectedToInvalidNeighbourWedge(molBond, wedgeBonds)) continue;
            bonds.add(molBond);
        }
        return bonds.isEmpty() ? null : new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), bonds, this.errorType, molecule, this.getErrorDescription(bonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    private boolean connectedToDoubleBond(MolBond molBond) {
        MolAtom atom1 = molBond.getAtom1();
        for (int i = 0; i < atom1.getBondCount(); ++i) {
            MolBond bond = atom1.getBond(i);
            if (bond.equals(molBond) || bond.getFlags() != 2) continue;
            return true;
        }
        return false;
    }

    private boolean connectedToCrossedDoubleBond(MolBond molBond) {
        MolAtom atom1 = molBond.getAtom1();
        for (int i = 0; i < atom1.getBondCount(); ++i) {
            MolBond bond = atom1.getBond(i);
            if (bond.equals(molBond) || bond.getType() != 2 || (bond.getFlags() & 0x1C0) != 192) continue;
            return true;
        }
        MolAtom atom2 = molBond.getAtom1();
        for (int i = 0; i < atom2.getBondCount(); ++i) {
            MolBond bond = atom2.getBond(i);
            if (bond.equals(molBond) || bond.getType() != 2 || (bond.getFlags() & 0x1C0) != 192) continue;
            return true;
        }
        return false;
    }

    private boolean connectedToInvalidNeighbourWedge(MolBond molBond, List<MolBond> wedgeBonds) {
        for (MolBond molBond2 : wedgeBonds) {
            if (molBond == molBond2 || !this.hasIncompatibleType(molBond, molBond2) || molBond.getAtom1() != molBond2.getAtom1() && molBond.getAtom1() != molBond2.getAtom2() && molBond.getAtom2() != molBond2.getAtom2() && molBond.getAtom2() != molBond2.getAtom1()) continue;
            return true;
        }
        return false;
    }

    private boolean hasIncompatibleType(MolBond molBond, MolBond molBond2) {
        int type1 = molBond.getFlags() & 0x30;
        int type2 = molBond2.getFlags() & 0x30;
        boolean wigglyWithUpOrDown = type1 == 48 && type2 != 48 || type1 != 48 && type2 == 48;
        boolean twoUpWedge = type1 == 16 && type2 == 16;
        boolean twoDownWedge = type1 == 32 && type2 == 32;
        return twoUpWedge || twoDownWedge || wigglyWithUpOrDown;
    }
}

