/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@CheckerInfo(name="Wiggly Double Bond Checker", localMenuName="Wiggly Double Bond", description="Detects unspecified double bonds represented by wiggly bonded ligands", noErrorMessage="No wiggly double bond found", oneErrorMessage="wiggly double bond found", moreErrorMessage="wiggly double bonds found", actionStringToken="wigglydoublebond")
public class WigglyDoubleBondChecker
extends AbstractStructureChecker {
    public WigglyDoubleBondChecker() {
        super(StructureCheckerErrorType.WIGGLY);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        Molecule mol = molecule.cloneMolecule();
        long grinvcc = mol.getGrinvCC();
        CleanUtil.setCTCrossedBond(mol);
        if (mol.getGrinvCC() != grinvcc) {
            ArrayList<MolBond> bonds = new ArrayList<MolBond>();
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                MolBond bond = molecule.getBond(i);
                if ((bond.getFlags() & 0x30) != 48) continue;
                bonds.add(bond);
            }
            return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), bonds, this.errorType, molecule, this.getErrorDescription(bonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        return null;
    }
}

