/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.logger.StructureCheckerLogger;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import chemaxon.struc.Molecule;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckerLoggerGroup
implements StructureCheckerLogger,
Closeable,
Flushable {
    private final Set<StructureCheckerLogger> loggers = new HashSet<StructureCheckerLogger>();

    public CheckerLoggerGroup(StructureCheckerLogger ... loggers) {
        for (StructureCheckerLogger log : loggers) {
            this.loggers.add(log);
        }
    }

    public boolean add(StructureCheckerLogger logger) {
        return this.loggers.add(logger);
    }

    public boolean remove(StructureCheckerLogger logger) {
        return this.loggers.remove(logger);
    }

    @Override
    public void onFirstCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        for (StructureCheckerLogger logger : this.loggers) {
            logger.onFirstCheck(molecule, resultList);
        }
    }

    @Override
    public void onFix(Molecule originalMolecule, Molecule fixedMolecule, StructureCheckerResult checkerResult, StructureFixer appliedFixer, boolean fixResult) {
        for (StructureCheckerLogger logger : this.loggers) {
            logger.onFix(originalMolecule, fixedMolecule, checkerResult, appliedFixer, fixResult);
        }
    }

    @Override
    public void onLastCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        for (StructureCheckerLogger logger : this.loggers) {
            logger.onLastCheck(molecule, resultList);
        }
    }

    @Override
    public void flush() throws IOException {
        for (StructureCheckerLogger logger : this.loggers) {
            if (!(logger instanceof Flushable)) continue;
            try {
                ((Flushable)((Object)logger)).flush();
            }
            catch (IOException e) {
                Logger.getLogger(CheckerLoggerGroup.class.getName()).log(Level.SEVERE, "Can not flush logger.", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (StructureCheckerLogger logger : this.loggers) {
            if (!(logger instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)logger)).close();
            }
            catch (IOException e) {
                Logger.getLogger(CheckerLoggerGroup.class.getName()).log(Level.SEVERE, "Can not close logger.", e);
            }
        }
    }
}

