/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.logger.StructureCheckerLogger;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import chemaxon.struc.Molecule;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultCheckerLogger
implements StructureCheckerLogger,
Closeable,
Flushable {
    private final OutputStream output;
    private long structureId = 0L;

    public DefaultCheckerLogger(OutputStream output) {
        this.output = output;
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void onFirstCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        ++this.structureId;
        StringBuilder builder = new StringBuilder("Structure ");
        builder.append(this.structureId);
        builder.append("\nIssues detected by following checkers:");
        this.writeCheckerList(builder.toString(), resultList);
        try {
            this.output.write("\nFixes applied: ".getBytes());
        }
        catch (IOException e) {
            Logger.getLogger(DefaultCheckerLogger.class.getName()).log(Level.SEVERE, "Failed to write log", e);
        }
    }

    @Override
    public void onFix(Molecule originalMolecule, Molecule fixedMolecule, StructureCheckerResult checkerResult, StructureFixer appliedFixer, boolean fixResult) {
        StringBuilder builder = new StringBuilder();
        if (appliedFixer == null) {
            builder.append("Manual");
        } else {
            builder.append(appliedFixer.getDescriptor().getName());
        }
        builder.append(" (");
        builder.append(fixResult ? "suceed" : "failed");
        builder.append(")\n");
        try {
            this.output.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            Logger.getLogger(DefaultCheckerLogger.class.getName()).log(Level.SEVERE, "Failed to write log", e);
        }
    }

    @Override
    public void onLastCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        this.writeCheckerList("\nRemaining issues detected by following checkers:", resultList);
    }

    protected void writeCheckerList(String prefix, List<StructureCheckerResult> resultList) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append("\n");
        for (StructureCheckerResult result : resultList) {
            builder.append(result.getName());
            builder.append("\n");
        }
        builder.append("\n");
        try {
            this.output.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            Logger.getLogger(DefaultCheckerLogger.class.getName()).log(Level.SEVERE, "Failed to write log", e);
        }
    }
}

